"""Legacy classes.

.. deprecated:: v.0.12.0b2
"""

from enum import Enum


class StudyType(Enum):
    """A tyype of study."""

    ADSORPTION = "adsorption"
    MECHANISM = "mechanism"
    SENSITIVITY = "sensitivity"

    DEFAULT = "sensitivity"  # noqa: PIE796

    def __str__(self) -> str:
        """A string representation of a ``StudyType``."""
        return self.value

    def is_implemented(self) -> bool:
        """Whether or not a ``StudyType`` is implemented."""
        implemented_study_types = [StudyType.SENSITIVITY]

        return self in implemented_study_types
