from pathlib import Path

import pytest

from autojob import SETTINGS
from autojob.tasks.scan import BondScan


@pytest.mark.usefixtures(
    "write_job_stats_file",
    "write_slurm_output_file",
    "scan_bond",
)
class TestFromDirectory:
    @staticmethod
    def test_should_load_bond_scan_from_directory(
        task_directory: Path,
        bond_scan: BondScan,
        calculate: None,  # noqa: ARG004
    ) -> None:
        _ = bond_scan.write_inputs(task_directory)
        bond_scan.task_outputs.atoms.write(
            Path(task_directory, SETTINGS.OUTPUT_ATOMS_FILE)
        )
        loaded_bond_scan = BondScan.from_directory(task_directory)
        assert loaded_bond_scan
