from pathlib import Path
from typing import Any

from pydantic import TypeAdapter
import pytest

from autojob.tasks.scan import BondScanOutputs
from autojob.tasks.scan import BondTuple


@pytest.mark.usefixtures("scan_bond")
class TestFromDirectory:
    @staticmethod
    def test_should_load_bond_scan_outputs_from_directory(
        task_directory: Path,
    ) -> None:
        bond_scan = BondScanOutputs.from_directory(src=task_directory)
        assert bond_scan


class TestValidation:
    @staticmethod
    @pytest.mark.parametrize("bond_tuple", ["1,2", (1, 2), [1, 2]])
    def test_should_validate_bond_tuple(bond_tuple: Any) -> None:
        validated = TypeAdapter(BondTuple).validate_python(bond_tuple)
        assert isinstance(validated, tuple)
        assert len(validated) == 2
        assert isinstance(validated[0], int)
        assert isinstance(validated[1], int)
