import pytest

from autojob.bases.task_base import TaskOutcome
from autojob.coordinator.job import JobError

DEFAULT_JOB_ERROR = JobError.TIME_LIMIT


@pytest.fixture(
    name="id_stem",
    params=["111111111", "123456789"],
)
def fixture_id_stem(request: pytest.FixtureRequest) -> str:
    id_stem: str = request.param
    return id_stem


@pytest.fixture(name="task_outcome", params=["success", "failed"])
def fixture_task_outcome(request: pytest.FixtureRequest) -> str:
    task_outcome: str = request.param
    return TaskOutcome(task_outcome)


@pytest.fixture(name="job_error")
def fixture_job_error(task_outcome: str) -> bool:
    if task_outcome == "success":
        return None

    return DEFAULT_JOB_ERROR
