# Advanced Variable Manager: avm

## By Grosse pastèque#6705


-------------


### WARNING :

__**This modules need some typing modifications !**__
**If you try to run it without these modifications, an Error will occur.**

For more informations go **[Here](./avm/__init__.py)**


-------------


### Usage :

- Function's args type checking
- Function's args fast converting
- Pattern matching
- Variable checking
- More types


------------


### Installation :

This module is now disponible on PyPi since version 0.9.1
So you can do `python -m pip install python-avm` or `pip install python-avm`

Then you will be able to use it as a module.

```python
import avm

...
```


-------------


### Functionnalities :

##### Functions :

| Functions | Decorator | Usage |
| :------------: | :------------: | :------------: |
| type_check | `YES` | Check function's args types |
| convertor | `YES` | Convert function's args values |
| parameters | `NO` | Return all arguments of the passed function |
| str_of | `YES` | Return a string vizualisation of the given class |
| add_ctype | `YES` | Adds a custom type to `custom_types` |
| length_check | `YES` | Check the length `(int: max-lenght, int: max-lenght) | int: max-lenght` of and object |
| *custom_types* | `NO` | Variable that contains all the Custom Types |
| tuple_check | `NO` | Checks a tuple, used for `avm.Union` |
| cisinstance | `NO` | Python `isinstance` but supports custom types |
| is_type_tuple | `NO` | Checks if the given argument is a tuple of types or custom types |
| is_length | `NO` | Checks if the given argument is a lenght `int | ... | (int | ..., int | ...)` |
| exp_check | `NO` | Checks the result of an expression, (like `True` is valid) |

##### Custom Types :

| CType | Has arguments | Usage |
| :------------:| :------------:| :------------: | 
| Generator | `NO` | Generator checking |
| Function | `NO` | Function checking (*NB: lambda functions type is also function*) |
| Method | `NO` | Methods checking |
| Module | `NO` | Module checking |
| BRange | `YES` | Better `range` and checking |
| Length | `YES` | Container length checking |
| Class | `YES` | Class checking (`is_init=False`) |
| Union | `YES` | Value type in `*args` |
| Float | `YES` | Better float checking |
| File | `YES` | File checking (checks if file exists) |
| Dict | `YES` | Better dict checking |
| Int | `YES` | Better int checking |
| Str | `YES` | Better str checking |

##### Important Features :
| Function | Usage |
| :------------:| :------------:|
| Pattern | Check a variable for the given pattern (uses recursions) |
| CType | Used as parent for new custom types |


------------


### Examples :

I have created three examples to help you understand a bit more if you want.
In [Here](./examples/).