nexrad = {
    "N0Q" : {
            'id': 94,
            'unit':'dBZ',
            'name':'0.5 deg Base Reflectivity',
            'ctable': ['NWSStormClearReflectivity',-20., 0.5],
            'res': 1000.,
            'elev': '0.5'},
    "N0U" : {
            'id': 99,
            'unit':'kts',
            'name':'0.5 deg Base Velocity',
            'ctable': ['NWS8bitVel',-100.,1.],
            'res': 250.,
            'elev': '0.5'},
    "EET" : {
            'id': 135,
            'unit':'kft',
            'name':'Enhanced Echo Tops',
            'ctable': ['NWSEnhancedEchoTops',2,1],
            'res': 1000.,
            'elev': '0.0'}
}
# Dictionary that maps VTEC codes to headlines
# Modified from com.raytheon.uf.edex.activetable/utility/common_static/base/vtec/VTECTable.py
# Colors from https://www.weather.gov/bro/mapcolors
vtec = {
    'AF.W' : {'phen': 'AF',
              'sig': 'W',
              'hdln': 'Ashfall Warning'},
    'AF.Y' : {'phen': 'AF',
              'sig': 'Y',
              'gray'
              'hdln': 'Ashfall Advisory'},
    'AQ.Y' : {'phen': 'AQ',
              'sig': 'Y',
              'hdln': 'Air Quality Alert'},
    'AS.O' : {'phen': 'AS',
              'sig': 'O',
              'hdln': 'Air Stagnation Outlook'},
    'AS.Y' : {'phen': 'AS',
              'sig': 'Y',
              'hdln': 'Air Stagnation Advisory'},
    'BH.S' : {'phen': 'BH',
              'sig': 'S',
              'hdln': 'Beach Hazards Statement'},
    'BW.Y' : {'phen': 'BW',
              'sig': 'Y',
              'hdln': 'Brisk Wind Advisory'},
    'BZ.A' : {'phen' : 'BZ',
              'sig' : 'A',
              'color': 'orangered',
              'hdln' : 'Blizzard Watch'},
    'BZ.W' : {'phen' : 'BZ',
              'sig' : 'W',
              'color': 'greenyellow',
              'hdln' : 'Blizzard Warning'},
    'CF.A' : {'phen': 'CF',
              'sig': 'A',
              'color': 'mediumaquamarine',
              'hdln': 'Coastal Flood Watch'},
    'CF.W' : {'phen': 'CF',
              'sig': 'W',
              'color': 'forestgreen',
              'hdln': 'Coastal Flood Warning'},
    'CF.Y' : {'phen': 'CF',
              'sig': 'Y',
              'color': 'lawngreen',
              'hdln': 'Coastal Flood Advisory'},
    'CF.S' : {'phen': 'CF',
              'sig': 'S',
              'color': 'olivedrab',
              'hdln': 'Coastal Flood Statement'}, 
    'DS.W' : {'phen': 'DS',
              'sig': 'W',
              'color': 'bisque',
              'hdln': 'Dust Storm Warning'},
    'DU.Y' : {'phen': 'DU',
              'sig': 'Y',
              'color': 'darkkhaki',
              'hdln': 'Blowing Dust Advisory'},
    'EC.A' : {'phen': 'EC',
              'sig': 'A',
              'hdln': 'Extreme Cold Watch'},
    'EC.W' : {'phen': 'EC',
              'sig': 'W',
              'hdln': 'Extreme Cold Warning'},
    'EH.A' : {'phen': 'EH',
              'sig': 'A',
              'hdln': 'Excessive Heat Watch'},
    'EH.W' : {'phen': 'EH',
              'sig': 'W',
              'hdln': 'Excessive Heat Warning'},
    'EW.W' : {'phen': 'EW',
              'sig': 'W',
              'color': 'deeppink',
              'hdln': 'Excessive Wind Warning'},
    'FA.A' : {'phen': 'FA',
              'sig': 'A',
              'color': 'seagreen',
              'hdln': 'Flood Watch'},
    'FA.W' : {'phen': 'FA',
              'sig': 'W',
              'color': 'seagreen',
              'hdln': 'Areal Flood Warning'},
    'FA.Y' : {'phen': 'FA',
              'sig': 'Y',
              'color': 'seagreen',
              'hdln': 'Areal Flood Advisory'},
    'FF.A' : {'phen': 'FF',
              'sig': 'A',
              'color': 'limegreen',
              'hdln': 'Flash Flood Watch'},
    'FF.S' : {'phen': 'FF',
              'sig': 'S',
              'color': 'yellowgreen',
              'hdln': 'Flash Flood Statement'},
    'FF.W' : {'phen': 'FF',
              'sig': 'W',
              'color': 'darkred',
              'hdln': 'Flash Flood Warning'},
    'FG.Y' : {'phen': 'FG',
              'sig': 'Y',
              'color': 'slategray',
              'hdln': 'Dense Fog Advisory'},
    'FL.A' : {'phen': 'FL',
              'sig': 'A',
              'color': 'seagreen',
              'hdln': 'Flood Watch'},
    'FL.W' : {'phen': 'FL',
              'sig': 'W',
              'color': 'green',
              'hdln': 'Flood Warning'},
    'FL.S' : {'phen': 'FL',
              'sig': 'S',
              'color': '#00ff7f',
              'hdln': 'Flood Statement'},
    'FL.Y' : {'phen': 'FL',
              'sig': 'Y',
              'color': '#00ff7f',
              'hdln': 'Flood Advisory'},
    'FR.Y' : {'phen': 'FR',
              'sig': 'Y',
              'hdln': 'Frost Advisory'},
    'FW.A' : {'phen': 'FW',
              'sig': 'A',
              'color': 'navajowhite',
              'hdln': 'Fire Weather Watch'},
    'FW.W' : {'phen': 'FW',
              'sig': 'W',
              'color': 'deeppink',
              'hdln': 'Red Flag Warning'},
    'FZ.A' : {'phen': 'FZ',
              'sig': 'A',
              'color': 'royalblue',
              'hdln': 'Freeze Watch'},
    'FZ.W' : {'phen': 'FZ',
              'sig': 'W',
              'color': 'cyan',
              'hdln': 'Freeze Warning'},
    'GL.A' : {'phen': 'GL',
              'sig': 'A',
              'color': 'pink',
              'hdln': 'Gale Watch'},
    'GL.W' : {'phen': 'GL',
              'sig': 'W',
              'color': '#dda0dd',
              'hdln': 'Gale Warning'},
    'HF.A' : {'phen': 'HF',
              'sig': 'A',
              'color': 'darkorchid',
              'hdln': 'Hurricane Force Wind Watch'},
    'HF.W' : {'phen': 'HF',
              'sig': 'W',
              'color': '#cd5c5c',
              'hdln': 'Hurricane Force Wind Warning'},
    'HT.Y' : {'phen': 'HT',
              'sig': 'Y',
              'hdln': 'Heat Advisory'},
    'HU.A' : {'phen': 'HU',
              'sig': 'A',
              'color': '#ff00ff',
              'hdln': 'Hurricane Watch'},
    'HU.S' : {'phen': 'HU',
              'sig': 'S',
              'color': 'yellow',
              'hdln': 'Hurricane Statement'},
    'HU.W' : {'phen': 'HU',
              'sig': 'W',
              'color': '#dc143c',
              'hdln': 'Hurricane Warning'},
    'HW.A' : {'phen': 'HW',
              'sig': 'A',
              'color': 'darkgoldenrod',
              'hdln': 'High Wind Watch'},
    'HW.W' : {'phen': 'HW',
              'sig': 'W',
              'color': 'goldenrod',
              'hdln': 'High Wind Warning'},
    'HZ.A' : {'phen': 'HZ',
              'sig': 'A',
              'color': 'royalblue',
              'hdln': 'Hard Freeze Watch'},
    'HZ.W' : {'phen': 'HZ',
              'sig': 'W',
              'color': 'blue',
              'hdln': 'Hard Freeze Warning'},
    'IS.W' : {'phen': 'IS',
              'sig': 'W',
              'hdln': 'Ice Storm Warning'},
    'LE.A' : {'phen': 'LE',
              'sig': 'A',
              'hdln': 'Lake Effect Snow Watch'},
    'LE.W' : {'phen': 'LE',
              'sig': 'W',
              'hdln': 'Lake Effect Snow Warning'},
    'LE.Y' : {'phen': 'LE',
              'sig': 'Y',
              'hdln': 'Lake Effect Snow Advisory'},
    'LO.Y' : {'phen': 'LO',
              'sig': 'Y',
              'hdln': 'Low Water Advisory'},
    'LS.A' : {'phen': 'LS',
              'sig': 'A',
              'hdln': 'Lakeshore Flood Watch'},
    'LS.S' : {'phen': 'LS',
              'sig': 'S',
              'hdln': 'Lakeshore Flood Statement'},
    'LS.W' : {'phen': 'LS',
              'sig': 'W',
              'hdln': 'Lakeshore Flood Warning'},
    'LS.Y' : {'phen': 'LS',
              'sig': 'Y',
              'hdln': 'Lakeshore Flood Advisory'},
    'LW.Y' : {'phen': 'LW',
              'sig': 'Y',
              'hdln': 'Lake Wind Advisory'},
    'MA.A' : {'phen': 'MA',
              'sig': 'A',
              'color': 'peachpuff',
              'hdln': 'Special Marine Advisory'},
    'MA.S' : {'phen': 'MA',
              'sig': 'S',
              'color': 'peachpuff',
              'hdln': 'Special Marine Statement'},
    'MA.W' : {'phen': 'MA',
              'sig': 'W',
              'color': 'palevioletred',
              'hdln': 'Special Marine Warning'},
    'MF.Y' : {'phen': 'MF',
              'sig': 'Y',
              'hdln': 'Dense Fog Advisory'}, # Marine Fog
    'MH.W' : {'phen': 'MH',
              'sig': 'W',
              'hdln': 'Ashfall Warning'}, # Marine Ashfall
    'MH.Y' : {'phen': 'MH',
              'sig': 'Y',
              'hdln': 'Ashfall Advisory'}, # Marine Ashfall
    'MS.Y' : {'phen': 'MS',
              'sig': 'Y',
              'hdln': 'Dense Smoke Advisory'}, # Marine Smoke
    'RB.Y' : {'phen': 'RB',
              'sig': 'Y',
              'hdln': 'Small Craft Advisory for rough bar'},
    'RP.S' : {'phen': 'RP',
              'sig' : 'S',
              'color': 'turquoise',
              'hdln': 'High Rip Current Risk'},
    'SC.Y' : {'phen': 'SC',
              'sig': 'Y',
              'thistle'
              'hdln': 'Small Craft Advisory'},
    'SE.A' : {'phen': 'SE',
              'sig': 'A',
              'hdln': 'Hazardous Seas Watch'},
    'SE.W' : {'phen': 'SE',
              'sig': 'W',
              'hdln': 'Hazardous Seas Warning'},
    'SI.Y' : {'phen': 'SI',
              'sig': 'Y',
              'thistle'
              'hdln': 'Small Craft Advisory for winds'},
    'SM.Y' : {'phen': 'SM',
              'sig': 'Y',
              'khaki'
              'hdln': 'Dense Smoke Advisory'},
    'SR.A' : {'phen': 'SR',
              'sig': 'A',
              'color': 'violet',
              'hdln': 'Storm Watch'},
    'SR.W' : {'phen': 'SR',
              'sig': 'W',
              'color': 'darkorchid',
              'hdln': 'Storm Warning'},
    'SS.A' : {'phen': 'SS',
              'sig': 'A',
              'hdln': 'Storm Surge Watch'},
    'SS.W' : {'phen': 'SS',
              'sig': 'W',
              'hdln': 'Storm Surge Warning'},
    'SU.W' : {'phen': 'SU',
              'sig': 'W',
              'color': 'forestgreen',
              'hdln': 'High Surf Warning'},
    'SU.Y' : {'phen': 'SU',
              'sig': 'Y',
              'color': 'mediumorchid',
              'hdln': 'High Surf Advisory'},             
    'SV.A' : {'phen': 'SV',
              'sig': 'A',
              'color': 'palevioletred',
              'hdln': 'Severe Thunderstorm Watch'},             
    'SV.S' : {'phen': 'SV',
              'sig': 'S',
              'color': 'aqua',
              'hdln': 'Severe Weather Statement'},
    'SV.W' : {'phen': 'SV',
              'sig': 'W',
              'color': 'orange',
              'hdln': 'Severe Thunderstorm Warning'},
    'SW.Y' : {'phen': 'SW',
              'sig': 'Y',
              'thistle'
              'hdln': 'Small Craft Advisory for hazardous seas'},
    'TO.A' : {'phen': 'TO',
              'sig': 'A',
              'color': 'yellow',
              'hdln': 'Tornado Watch'},
    'TO.W' : {'phen': 'TO',
              'sig': 'W',
              'color': 'red',
              'hdln': 'Tornado Warning'},
    'TR.A' : {'phen': 'TR',
              'sig': 'A',
              'color': '#f08080',
              'hdln': 'Tropical Storm Watch'},
    'TR.W' : {'phen': 'TR',
              'sig': 'W',
              'color': '#b22222',
              'hdln': 'Tropical Storm Warning'},
    'TS.A' : {'phen': 'TS',
              'sig': 'A',
              'hdln': 'Tsunami Watch'},
    'TS.W' : {'phen': 'TS',
              'sig': 'W',
              'hdln': 'Tsunami Warning'},
    'TS.Y' : {'phen': 'TS',
              'sig': 'Y',
              'hdln': 'Tsunami Advisory'},
    'TY.A' : {'phen': 'TY',
              'sig': 'A',
              'hdln': 'Typhoon Watch'},
    'TY.W' : {'phen': 'TY',
              'sig': 'W',
              'hdln': 'Typhoon Warning'},
    'UP.A' : {'phen': 'UP',
              'sig': 'A',
              'hdln': 'Heavy Freezing Spray Watch'},
    'UP.W' : {'phen': 'UP',
              'sig': 'W',
              'hdln': 'Heavy Freezing Spray Warning'},
    'UP.Y' : {'phen': 'UP',
              'sig': 'Y',
              'hdln': 'Freezing Spray Advisory'},
    'WC.A' : {'phen': 'WC',
              'sig': 'A',
              'color': 'cadetblue',
              'hdln': 'Wind Chill Watch'},
    'WC.W' : {'phen': 'WC',
              'sig': 'W',
              'color': 'lightsteelblue',
              'hdln': 'Wind Chill Warning'},
    'WC.Y' : {'phen': 'WC',
              'sig': 'Y',
              'color': 'paleturquoise',
              'hdln': 'Wind Chill Advisory'},
    'WI.Y' : {'phen': 'WI',
              'sig': 'Y',
              'color': 'tan',
              'hdln': 'Wind Advisory'},
    'WS.A' : {'phen': 'WS',
              'sig': 'A',
              'color': '#4682b4',
              'hdln': 'Winter Storm Watch'},
    'WS.W' : {'phen': 'WS',
              'sig': 'W',
              'color': 'hotpink',
              'hdln': 'Winter Storm Warning'},
    'WW.Y' : {'phen': 'WW',
              'sig': 'Y',
              'color': '#7b68ee',
              'hdln': 'Winter Weather Advisory'},
    'ZF.Y' : {'phen': 'ZF',
              'sig': 'Y',
              'hdln': 'Freezing Fog Advisory'},
    'ZR.Y' : {'phen': 'ZR',
              'sig': 'Y',
              'hdln': 'Freezing Rain Advisory'},
    }

#
# Upgrade Hazards Dictionary - upgradeHazardsDict is a dictionary of 
# phen/sig combinations defining upgrades. Each key is the proposed hazard. 
# The associated list are the hazards which are upgraded by the 
# proposed hazard.
#

upgradeHazardsDict = {
'WC.W': ['WC.A', 'WC.Y'], 
'WC.Y': ['WC.A'],
'BZ.W': ['WS.W', 'LE.W', 'ZR.Y', 'LE.Y', 'WW.Y',
         'BZ.A', 'WS.A', 'LE.A'],
'IS.W': ['WS.W', 'LE.W', 'ZR.Y', 'LE.Y', 'WW.Y',
         'BZ.A', 'WS.A', 'LE.A'],
'LE.W': ['ZR.Y', 'LE.Y', 'WW.Y',
         'BZ.A', 'WS.A', 'LE.A'],
'WS.W': ['ZR.Y', 'LE.Y', 'WW.Y',
         'BZ.A', 'WS.A', 'LE.A'],
'ZR.Y': ['BZ.A', 'WS.A', 'LE.A'],
'LE.Y': ['BZ.A', 'WS.A', 'LE.A'],
'WW.Y': ['BZ.A', 'WS.A', 'LE.A'],
'EH.W': ['EH.A', 'HT.Y'],
'HT.Y': ['EH.A'],
'FZ.W': ['FZ.A', 'FR.Y', 'HZ.A'],
'HZ.W': ['FZ.A', 'FR.Y', 'HZ.A'],
'FR.Y': ['FZ.A', 'HZ.A'],
'HW.W': ['DU.Y', 'LW.Y', 'WI.Y', 'HW.A'],
'DS.W': ['DU.Y', 'LW.Y', 'WI.Y', 'HW.A'],
'WI.Y': ['HW.A'],
'EC.W': ['EC.A'],
'FW.W': ['FW.A'],
'CF.W': ['CF.A', 'CF.Y'],
'CF.Y': ['CF.A'],
'LS.W': ['LS.A', 'LS.Y'],
'LS.Y': ['LS.A'],
'BW.Y': ['GL.A', 'SR.A', 'HF.A', 'SE.A'],
'RB.Y': ['GL.A', 'SR.A', 'HF.A', 'SE.A'],
'SC.Y': ['GL.A', 'SR.A', 'HF.A', 'SE.A'],
'SI.Y': ['GL.A', 'SR.A', 'HF.A', 'SE.A'],
'SW.Y': ['SE.A'],
'UP.Y': ['UP.A'],
'HF.W': ['SR.W', 'GL.W', 'SC.Y', 'SW.Y', 'BW.Y', 'SI.Y', 'RB.Y', 'GL.A', 'SR.A', 'HF.A', 'SE.A'],
'SR.W': ['GL.W', 'SC.Y', 'SW.Y', 'BW.Y', 'SI.Y', 'RB.Y', 'GL.A', 'SR.A', 'HF.A', 'SE.A'],
'GL.W': ['SC.Y', 'SW.Y', 'BW.Y', 'SI.Y', 'RB.Y', 'GL.A', 'SR.A', 'HF.A', 'SE.A'],
'SE.W': ['SC.Y', 'RB.Y', 'GL.A', 'SR.A', 'HF.A', 'SE.A'],
'UP.W': ['UP.Y', 'UP.A'],
'SU.W': ['SU.Y'],
'SS.W': ['SS.A'],
'HU.W': ['HU.A', 'TR.W', 'TR.A'],
'HU.A': ['TR.A'],
'TR.W': ['TR.A', 'HU.A', 'TY.A'],
'TY.W': ['TY.A', 'TR.W', 'TR.A'],
'TY.A': ['TR.A'],
'AF.W': ['AF.Y'],
'MH.W': ['MH.Y'],
 }
 
#
# When passed a phen/sig for both the current hazard and the proposed hazard,
# checkForUpgrade returns a 1 if the proposed hazard is an upgrade, otherwise 0
#

def checkForUpgrade(pPhen, pSig, cPhen, cSig):
    proposed = pPhen + "." + pSig
    current = cPhen + "." + cSig
    if upgradeHazardsDict.has_key(proposed):
        if current in upgradeHazardsDict[proposed]:
            return 1
        else:
            return 0
    else:
        return 0

#
# Downgrade Hazards Dictionary - downgradeHazardsDict is a dictionary of 
# phen/sig combinations defining downgrades. Each key is the proposed hazard. 
# The associated list are the hazards which are downgraded by the 
# proposed hazard.
#

downgradeHazardsDict = {
'ZR.Y': ['BZ.W', 'LE.W', 'IS.W', 'WS.W'],
'LE.Y': ['BZ.W', 'LE.W', 'IS.W', 'WS.W'],
'WW.Y': ['BZ.W', 'LE.W', 'IS.W', 'WS.W'],
'WC.Y': ['WC.W'],
'WS.W': ['BZ.W', 'IS.W'],
'LE.W': ['BZ.W', 'IS.W'],
'DU.Y': ['DS.W', 'HW.W'],
'LW.Y': ['DS.W', 'HW.W', 'WI.Y'],
'WI.Y': ['DS.W', 'HW.W'],
'HT.Y': ['EH.W'],
'FR.Y': ['FZ.W', 'HZ.W'],
'TR.W': ['HU.W', 'TY.W'],
'UP.Y': ['UP.W'],
'SR.W': ['HF.W'],
'GL.W': ['HF.W', 'SR.W'],
'SC.Y': ['HF.W', 'SR.W', 'GL.W', 'SE.W'],
'SW.Y': ['SE.W'],
'RB.Y': ['HF.W', 'SR.W', 'GL.W', 'SE.W'],
'SU.Y': ['SU.W'],
'BW.Y': ['HF.W', 'SR.W', 'GL.W'],
'SI.Y': ['HF.W', 'SR.W', 'GL.W'],
'LS.Y': ['LS.W'],
'CF.Y': ['CF.W'],
'AF.Y': ['AF.W'],
'MH.Y': ['MH.W'],
}

#
# When passed a phen/sig for both the current hazard and the proposed hazard,
# checkForDowngrade returns a 1 if the proposed hazard is an downgrade, otherwise 0
#

def checkForDowngrade(pPhen, pSig, cPhen, cSig):
    proposed = pPhen + "." + pSig
    current = cPhen + "." + cSig
    if downgradeHazardsDict.has_key(proposed):
        if current in downgradeHazardsDict[proposed]:
            return 1
        else:
            return 0
    else:
        return 0
