from __future__ import annotations

import pytest

from barcode.codex import Gs1_128

FNC1_CHAR = "\xf1"
FNC1 = 102
START_B = 104
START_C = 105
FROM_AC_TO_B = 100
FROM_AB_TO_C = 99
FROM_BC_TO_A = 101
CODE_BUILD_TEST = (
    # '(01)01234567891011(11)200622(17)240622(21)88888888'  # noqa: ERA001
    (
        "010123456789101111200622172406222188888888",
        [
            START_C,
            FNC1,
            1,
            1,
            23,
            45,
            67,
            89,
            10,
            11,
            11,
            20,
            6,
            22,
            17,
            24,
            6,
            22,
            21,
            88,
            88,
            88,
            88,
        ],
    ),
    # '(01)01234567891011(11)200622(17)240622(21)888888888'  # noqa: ERA001
    (
        "0101234567891011112006221724062221888888888",
        [
            START_C,
            FNC1,
            1,
            1,
            23,
            45,
            67,
            89,
            10,
            11,
            11,
            20,
            6,
            22,
            17,
            24,
            6,
            22,
            21,
            88,
            88,
            88,
            88,
            100,
            24,
        ],
    ),
    # '(01)01234567891011(11)200622(10)12345(21)1234'  # noqa: ERA001
    (
        "0101234567891011112006221012345" + FNC1_CHAR + "211234",
        [
            START_C,
            FNC1,
            1,
            1,
            23,
            45,
            67,
            89,
            10,
            11,
            11,
            20,
            6,
            22,
            10,
            12,
            34,
            FROM_AC_TO_B,
            21,
            FNC1,
            FROM_AB_TO_C,
            21,
            12,
            34,
        ],
    ),
    # '(01)01234567891011(11)200622(10)1234(21)1234'  # noqa: ERA001
    (
        "010123456789101111200622101234" + FNC1_CHAR + "211234",
        [
            START_C,
            FNC1,
            1,
            1,
            23,
            45,
            67,
            89,
            10,
            11,
            11,
            20,
            6,
            22,
            10,
            12,
            34,
            FNC1,
            21,
            12,
            34,
        ],
    ),
    # '(01)01234567891011(11)200622(10)240622(21)888888888'  # noqa: ERA001
    (
        "01012345678910111120062210240622" + FNC1_CHAR + "21888888888",
        [
            START_C,
            FNC1,
            1,
            1,
            23,
            45,
            67,
            89,
            10,
            11,
            11,
            20,
            6,
            22,
            10,
            24,
            6,
            22,
            FNC1,
            21,
            88,
            88,
            88,
            88,
            100,
            24,
        ],
    ),
    # '(01)08720299927469(11)240621(17)250621(10)20240621/0001(21)xyz'  # noqa: ERA001
    (
        "010872029992746911240621172506211020240621/0001" + FNC1_CHAR + "21xyz",
        [
            105,
            102,
            1,
            8,
            72,
            2,
            99,
            92,
            74,
            69,
            11,
            24,
            6,
            21,
            17,
            25,
            6,
            21,
            10,
            20,
            24,
            6,
            21,
            100,
            15,
            99,
            0,
            1,
            102,
            21,
            100,
            88,
            89,
            90,
        ],
    ),
)


@pytest.mark.parametrize(("target", "answer"), CODE_BUILD_TEST)
def test_code_build(target, answer):
    gs1_128 = Gs1_128(target)
    assert gs1_128._build() == answer
