/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import loci.common.FileHandle;
import loci.common.IRandomAccess;
import loci.common.Location;
import loci.common.ReflectException;
import loci.common.ReflectedUniverse;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.MissingLibraryException;
import loci.formats.gui.AWTImageTools;
import loci.formats.in.BIFormatReader;
import loci.formats.in.TiffReader;
import loci.formats.meta.MetadataStore;

public class TiffJAIReader
extends BIFormatReader {
    private static final String NO_JAI_MSG = "Java Advanced Imaging (JAI) is required to read some TIFF files. Please install JAI from https://jai.dev.java.net/";
    protected ReflectedUniverse r;

    public TiffJAIReader() {
        super("Tagged Image File Format", TiffReader.TIFF_SUFFIXES);
        this.domains = new String[]{"Graphics"};
    }

    public Object openPlane(int no, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, -1, x, y, w, h);
        BufferedImage img = this.openBufferedImage(no);
        return AWTImageTools.getSubimage(img, this.isLittleEndian(), x, y, w, h);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initFile(String id) throws FormatException, IOException {
        int numPages;
        LOGGER.info("Checking for JAI");
        try {
            this.r = new ReflectedUniverse();
            this.r.exec("import javax.media.jai.NullOpImage");
            this.r.exec("import javax.media.jai.OpImage");
            this.r.exec("import com.sun.media.jai.codec.FileSeekableStream");
            this.r.exec("import com.sun.media.jai.codec.ImageDecoder");
            this.r.exec("import com.sun.media.jai.codec.ImageCodec");
        }
        catch (ReflectException exc) {
            throw new MissingLibraryException(NO_JAI_MSG, exc);
        }
        super.initFile(id);
        LOGGER.info("Reading movie dimensions");
        IRandomAccess ira = Location.getMappedFile(id);
        if (ira != null) {
            if (!(ira instanceof FileHandle)) throw new FormatException("Unsupported handle type" + ira.getClass().getName());
            FileHandle fh = (FileHandle)ira;
            this.r.setVar("file", fh.getRandomAccessFile());
        } else {
            String mapId = Location.getMappedId(id);
            File file2 = new File(mapId);
            if (!file2.exists()) throw new FileNotFoundException(id);
            this.r.setVar("file", file2);
        }
        this.r.setVar("tiff", "tiff");
        this.r.setVar("param", null);
        try {
            this.r.exec("s = new FileSeekableStream(file)");
            this.r.exec("dec = ImageCodec.createImageDecoder(tiff, s, param)");
            numPages = (Integer)this.r.exec("dec.getNumPages()");
        }
        catch (ReflectException exc) {
            throw new FormatException(exc);
        }
        if (numPages < 0) {
            throw new FormatException("Invalid page count: " + numPages);
        }
        BufferedImage img = this.openBufferedImage(0);
        if (img == null) {
            throw new FormatException("Invalid image stream");
        }
        LOGGER.info("Populating metadata");
        this.core[0].imageCount = numPages;
        this.core[0].sizeX = img.getWidth();
        this.core[0].sizeY = img.getHeight();
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = img.getSampleModel().getNumBands();
        this.core[0].sizeT = numPages;
        this.core[0].rgb = this.core[0].sizeC > 1;
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].pixelType = AWTImageTools.getPixelType(img);
        this.core[0].interleaved = true;
        this.core[0].littleEndian = false;
        this.core[0].metadataComplete = true;
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        MetadataTools.setDefaultCreationDate(store, id, 0);
    }

    protected BufferedImage openBufferedImage(int no) throws FormatException {
        RenderedImage img;
        this.r.setVar("no", no);
        try {
            this.r.exec("img = dec.decodeAsRenderedImage(no)");
            img = (RenderedImage)this.r.exec("new NullOpImage(img, null, OpImage.OP_IO_BOUND, null)");
        }
        catch (ReflectException exc) {
            throw new FormatException(exc);
        }
        return AWTImageTools.convertRenderedImage(img);
    }
}

