/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.radial;

import java.util.HashMap;
import java.util.List;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dt.EarthLocation;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.dt.TypedDatasetImpl;
import ucar.nc2.dt.radial.RadialCoordSys;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonRect;

public abstract class RadialDatasetSweepAdapter
extends TypedDatasetImpl
implements RadialDatasetSweep {
    protected EarthLocation origin;
    protected HashMap csHash = new HashMap();
    protected DateUnit dateUnits;

    public RadialDatasetSweepAdapter() {
    }

    public RadialDatasetSweepAdapter(NetcdfDataset ds) {
        super(ds);
        this.parseInfo.append("RadialDatasetAdapter look for RadialVariables\n");
        List<Variable> vars = ds.getVariables();
        for (int i = 0; i < vars.size(); ++i) {
            VariableEnhanced varDS = (VariableEnhanced)((Object)vars.get(i));
            this.constructCoordinateSystems(ds, varDS);
        }
    }

    protected void constructCoordinateSystems(NetcdfDataset ds, VariableEnhanced v) {
        if (v instanceof StructureDS) {
            StructureDS s = (StructureDS)v;
            List<Variable> members = s.getVariables();
            for (int i = 0; i < members.size(); ++i) {
                VariableEnhanced nested = (VariableEnhanced)((Object)members.get(i));
                this.constructCoordinateSystems(ds, nested);
            }
        } else {
            CoordinateSystem cs;
            RadialCoordSys rcs = null;
            List<CoordinateSystem> csys = v.getCoordinateSystems();
            for (int j = 0; j < csys.size() && (rcs = RadialCoordSys.makeRadialCoordSys(this.parseInfo, cs = csys.get(j), v)) == null; ++j) {
            }
            if (rcs != null) {
                this.addRadialVariable(v, rcs);
            }
        }
    }

    protected void addRadialVariable(VariableEnhanced varDS, RadialCoordSys gcs) {
        RadialCoordSys gcsUse = (RadialCoordSys)this.csHash.get(gcs.getName());
        if (null == gcsUse) {
            this.csHash.put(gcs.getName(), gcs);
            this.parseInfo.append(" -make new RadialCoordSys= " + gcs.getName() + "\n");
            gcsUse = gcs;
        }
        RadialDatasetSweep.RadialVariable rsvar = this.makeRadialVariable(varDS, gcsUse);
        this.dataVariables.add(rsvar);
    }

    protected abstract RadialDatasetSweep.RadialVariable makeRadialVariable(VariableEnhanced var1, RadialCoordSys var2);

    protected abstract void setTimeUnits();

    public String getDetailInfo() {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append(" Radar ID = " + this.getRadarID() + "\n");
        sbuff.append(" Radar Name = " + this.getRadarName() + "\n");
        sbuff.append(" Data Format Name= " + this.getDataFormat() + "\n");
        sbuff.append(" Common Type = " + this.getCommonType() + "\n");
        sbuff.append(" Common Origin = " + this.getCommonOrigin() + "\n");
        sbuff.append(" Date Unit = " + this.getTimeUnits().getUnitsString() + "\n");
        sbuff.append(" isStationary = " + this.isStationary() + "\n");
        sbuff.append(" isVolume = " + this.isVolume() + "\n");
        sbuff.append("\n");
        sbuff.append(super.getDetailInfo());
        return sbuff.toString();
    }

    protected abstract void setEarthLocation();

    public RadialDatasetSweep.Type getCommonType() {
        return null;
    }

    public DateUnit getTimeUnits() {
        return this.dateUnits;
    }

    public EarthLocation getEarthLocation() {
        return this.origin;
    }

    protected void setBoundingBox() {
        LatLonRect largestBB = null;
        for (RadialCoordSys sys : this.csHash.values()) {
            sys.setOrigin(this.origin);
            LatLonRect bb = sys.getBoundingBox();
            if (largestBB == null) {
                largestBB = bb;
                continue;
            }
            largestBB.extend(bb);
        }
        this.boundingBox = largestBB;
    }
}

