/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.vertical;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VerticalCT;
import ucar.unidata.geoloc.vertical.VerticalTransformImpl;

public class HybridSigmaPressure
extends VerticalTransformImpl {
    public static final String P0 = "P0_variableName";
    public static final String PS = "SurfacePressure_variableName";
    public static final String A = "A_variableName";
    public static final String B = "B_variableName";
    private double p0;
    private Variable psVar;
    private Variable aVar;
    private Variable bVar;
    private Variable p0Var;
    private Array aArray = null;
    private Array bArray = null;

    public HybridSigmaPressure(NetcdfDataset ds, Dimension timeDim, VerticalCT vCT) {
        super(timeDim);
        String psName = vCT.findParameterIgnoreCase(PS).getStringValue();
        String aName = vCT.findParameterIgnoreCase(A).getStringValue();
        String bName = vCT.findParameterIgnoreCase(B).getStringValue();
        String p0Name = vCT.findParameterIgnoreCase(P0).getStringValue();
        this.psVar = ds.findStandardVariable(psName);
        this.aVar = ds.findStandardVariable(aName);
        this.bVar = ds.findStandardVariable(bName);
        this.p0Var = ds.findStandardVariable(p0Name);
        this.units = ds.findAttValueIgnoreCase(this.psVar, "units", "none");
    }

    public ArrayDouble.D3 getCoordinateArray(int timeIndex) throws IOException, InvalidRangeException {
        Array psArray = this.readArray(this.psVar, timeIndex);
        if (null == this.aArray) {
            this.aArray = this.aVar.read();
            this.bArray = this.bVar.read();
            this.p0 = this.p0Var.readScalarDouble();
        }
        int nz = (int)this.aArray.getSize();
        Index aIndex = this.aArray.getIndex();
        Index bIndex = this.bArray.getIndex();
        int[] shape2D = psArray.getShape();
        int ny = shape2D[0];
        int nx = shape2D[1];
        Index psIndex = psArray.getIndex();
        ArrayDouble.D3 press = new ArrayDouble.D3(nz, ny, nx);
        for (int z = 0; z < nz; ++z) {
            double term1 = this.aArray.getDouble(aIndex.set(z)) * this.p0;
            double bz = this.bArray.getDouble(bIndex.set(z));
            for (int y = 0; y < ny; ++y) {
                for (int x = 0; x < nx; ++x) {
                    double ps = psArray.getDouble(psIndex.set(y, x));
                    press.set(z, y, x, term1 + bz * ps);
                }
            }
        }
        return press;
    }
}

