/*
 * Decompiled with CFR 0.152.
 */
package ucar.units;

import java.io.Serializable;
import ucar.units.Base;

public final class Factor
implements Serializable {
    private final Base _base;
    private final int _exponent;

    public Factor(Base base) {
        this(base, 1);
    }

    public Factor(Factor factor, int exponent) {
        this(factor.getBase(), exponent);
    }

    public Factor(Base base, int exponent) {
        this._base = base;
        this._exponent = exponent;
    }

    public Base getBase() {
        return this._base;
    }

    public String getID() {
        return this.getBase().getID();
    }

    public int getExponent() {
        return this._exponent;
    }

    public Factor pow(int power) {
        return new Factor(this.getBase(), this.getExponent() * power);
    }

    public final String toString() {
        return this.getExponent() == 0 ? "" : (this.getExponent() == 1 ? this.getBase().toString() : this.getBase().toString() + this.getExponent());
    }

    public boolean equals(Object object) {
        boolean equals;
        if (this == object) {
            equals = true;
        } else if (!(object instanceof Factor)) {
            equals = false;
        } else {
            Factor that = (Factor)object;
            equals = this.getExponent() != that.getExponent() ? false : this.getExponent() == 0 || ((Object)this.getBase()).equals(that.getBase());
        }
        return equals;
    }

    public boolean isReciprocalOf(Factor that) {
        return ((Object)this.getBase()).equals(that.getBase()) && this.getExponent() == -that.getExponent();
    }

    public boolean isDimensionless() {
        return this.getExponent() == 0 || this.getBase().isDimensionless();
    }
}

