/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.math.BigInteger;

public class FilePatternBlock {
    public static final String BLOCK_START = "<";
    public static final String BLOCK_END = ">";
    private String[] elements;
    private boolean fixed;
    private int zeroes;
    private String block;
    private BigInteger begin = null;
    private BigInteger end = null;
    private BigInteger step = null;

    public FilePatternBlock(String block) {
        this.block = block;
        this.explode();
    }

    public String[] getElements() {
        return this.elements;
    }

    public String getBlock() {
        return this.block;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public BigInteger getFirst() {
        return this.begin;
    }

    public BigInteger getLast() {
        return this.end;
    }

    public BigInteger getStep() {
        return this.step;
    }

    private void explode() {
        String s;
        String b;
        String e;
        int dash = this.block.indexOf("-");
        if (dash < 0) {
            int comma = this.block.indexOf(",");
            if (comma > 0) {
                this.elements = this.block.substring(1, this.block.length() - 1).split(",");
                return;
            }
            b = e = this.block.substring(1, this.block.length() - 1);
            s = "1";
        } else {
            int colon = this.block.indexOf(":");
            b = this.block.substring(1, dash);
            if (colon < 0) {
                e = this.block.substring(dash + 1, this.block.length() - 1);
                s = "1";
            } else {
                e = this.block.substring(dash + 1, colon);
                s = this.block.substring(colon + 1, this.block.length() - 1);
            }
        }
        boolean numeric = true;
        try {
            this.begin = new BigInteger(b);
            this.end = new BigInteger(e);
            this.step = new BigInteger(s);
        }
        catch (NumberFormatException exc) {
            numeric = false;
            this.begin = new BigInteger(b, 26);
            this.end = new BigInteger(e, 26);
            this.step = new BigInteger(s, 26);
        }
        this.fixed = b.length() == e.length();
        this.zeroes = 0;
        this.zeroes = 0;
        while (this.zeroes < e.length() && e.charAt(this.zeroes) == '0') {
            ++this.zeroes;
        }
        int count = this.end.subtract(this.begin).divide(this.step).intValue() + 1;
        this.elements = new String[count];
        for (int i = 0; i < count; ++i) {
            String value;
            BigInteger v = this.begin.add(this.step.multiply(BigInteger.valueOf(i)));
            String string = value = numeric ? v.toString() : v.toString(26);
            if (!numeric) {
                value = Character.isLowerCase(b.charAt(0)) ? value.toLowerCase() : value.toUpperCase();
            }
            int padChars = this.fixed ? e.length() - value.length() : 0;
            this.elements[i] = value;
            for (int j = 0; j < padChars; ++j) {
                this.elements[i] = "0" + this.elements[i];
            }
        }
    }
}

