/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.prefs;

import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.IniTable;
import loci.plugins.prefs.BooleanOption;
import loci.plugins.prefs.Option;
import loci.plugins.prefs.StringOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionsList {
    public static final String INI_TYPE = "type";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_STRING = "string";
    protected HashMap<String, Option> options = new HashMap();

    public OptionsList(String path, Class<?> c) throws IOException {
        this(new IniParser().parseINI(path, c));
    }

    public OptionsList(IniList ini) {
        for (IniTable entry : ini) {
            Option o;
            String type = (String)entry.get(INI_TYPE);
            if (type.equals(TYPE_BOOLEAN)) {
                o = new BooleanOption(entry);
            } else if (type.equals(TYPE_STRING)) {
                o = new StringOption(entry);
            } else {
                throw new IllegalArgumentException("Unknown type: " + type);
            }
            this.options.put(o.getKey(), o);
        }
    }

    public void parseOptions(String arg) {
        for (Option o : this.options.values()) {
            o.parseOption(arg);
        }
    }

    public void loadOptions() {
        for (Option o : this.options.values()) {
            o.loadOption();
        }
    }

    public void saveOptions() {
        for (Option o : this.options.values()) {
            o.saveOption();
        }
    }

    public boolean isSaved(String key) {
        return this.options.get(key).isSaved();
    }

    public String getLabel(String key) {
        return this.options.get(key).getLabel();
    }

    public String getInfo(String key) {
        return this.options.get(key).getInfo();
    }

    public String[] getPossible(String key) {
        Option o = this.options.get(key);
        if (o instanceof StringOption) {
            Vector<String> possible = ((StringOption)o).getPossible();
            return possible.toArray(new String[0]);
        }
        throw new IllegalArgumentException("Not a string key: " + key);
    }

    public boolean isPossible(String key, String value) {
        Option o = this.options.get(key);
        if (o instanceof StringOption) {
            Vector<String> possible = ((StringOption)o).getPossible();
            return possible.contains(value);
        }
        throw new IllegalArgumentException("Not a string key: " + key);
    }

    public boolean isSetByDefault(String key) {
        Option o = this.options.get(key);
        if (o instanceof BooleanOption) {
            return ((BooleanOption)o).getDefault();
        }
        throw new IllegalArgumentException("Not a boolean key: " + key);
    }

    public String getDefaultValue(String key) {
        Option o = this.options.get(key);
        if (o instanceof StringOption) {
            return ((StringOption)o).getDefault();
        }
        throw new IllegalArgumentException("Not a string key: " + key);
    }

    public boolean isSet(String key) {
        Option o = this.options.get(key);
        if (o instanceof BooleanOption) {
            return ((BooleanOption)o).getValue();
        }
        throw new IllegalArgumentException("Not a boolean key: " + key);
    }

    public String getValue(String key) {
        Option o = this.options.get(key);
        if (o instanceof StringOption) {
            return ((StringOption)o).getValue();
        }
        throw new IllegalArgumentException("Not a string key: " + key);
    }

    public void setValue(String key, boolean value) {
        Option o = this.options.get(key);
        if (!(o instanceof BooleanOption)) {
            throw new IllegalArgumentException("Not a boolean key: " + key);
        }
        ((BooleanOption)o).setValue(value);
    }

    public void setValue(String key, String value) {
        Option o = this.options.get(key);
        if (!(o instanceof StringOption)) {
            throw new IllegalArgumentException("Not a string key: " + key);
        }
        ((StringOption)o).setValue(value);
    }

    public Option getOption(String key) {
        return this.options.get(key);
    }

    public BooleanOption getBooleanOption(String key) {
        Option o = this.options.get(key);
        if (o instanceof BooleanOption) {
            return (BooleanOption)o;
        }
        throw new IllegalArgumentException("Not a boolean key: " + key);
    }

    public StringOption getStringOption(String key) {
        Option o = this.options.get(key);
        if (o instanceof StringOption) {
            return (StringOption)o;
        }
        throw new IllegalArgumentException("Not a string key: " + key);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof OptionsList)) {
            return false;
        }
        OptionsList optionsList = (OptionsList)o;
        if (this.options.size() != optionsList.options.size()) {
            return false;
        }
        for (String key : this.options.keySet()) {
            Option a = this.options.get(key);
            Option b = optionsList.options.get(key);
            if (a != null && b == null || a == null && b != null) {
                return false;
            }
            if (a == null && b == null) continue;
            if (a instanceof BooleanOption && b instanceof BooleanOption) {
                if (((BooleanOption)a).getValue() == ((BooleanOption)b).getValue()) continue;
                return false;
            }
            if (a instanceof StringOption && b instanceof StringOption) {
                String aValue = ((StringOption)a).getValue();
                String bValue = ((StringOption)b).getValue();
                if (aValue == null && bValue == null) continue;
                if (aValue == null) {
                    return false;
                }
                if (aValue != null && aValue.equals(bValue)) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

