/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataA;
import ucar.ma2.StructureMembers;

public class ArrayStructureMA
extends ArrayStructure {
    public ArrayStructureMA(StructureMembers members, int[] shape) {
        super(members, shape);
    }

    public void setMemberArray(String memberName, Array data) {
        StructureMembers.Member m = this.members.findMember(memberName);
        m.setDataObject(data);
    }

    protected StructureData makeStructureData(ArrayStructure as, int index) {
        return new StructureDataA(as, index);
    }

    public Object getStorage() {
        return this.members;
    }

    public double getScalarDouble(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.DOUBLE) {
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be double");
        }
        Array data = (Array)m.getDataObject();
        return data.getDouble(recnum * m.getSize());
    }

    public double[] getJavaArrayDouble(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.DOUBLE) {
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be double");
        }
        int count = m.getSize();
        Array data = (Array)m.getDataObject();
        double[] pa = new double[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getDouble(recnum * count + i);
        }
        return pa;
    }

    public float getScalarFloat(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.FLOAT) {
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be float");
        }
        Array data = (Array)m.getDataObject();
        return data.getFloat(recnum * m.getSize());
    }

    public float[] getJavaArrayFloat(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.FLOAT) {
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be float");
        }
        int count = m.getSize();
        Array data = (Array)m.getDataObject();
        float[] pa = new float[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getFloat(recnum * count + i);
        }
        return pa;
    }

    public byte getScalarByte(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.BYTE) {
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be byte");
        }
        Array data = (Array)m.getDataObject();
        return data.getByte(recnum * m.getSize());
    }

    public byte[] getJavaArrayByte(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.BYTE) {
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be byte");
        }
        int count = m.getSize();
        Array data = (Array)m.getDataObject();
        byte[] pa = new byte[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getByte(recnum * count + i);
        }
        return pa;
    }

    public short getScalarShort(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.SHORT) {
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be short");
        }
        Array data = (Array)m.getDataObject();
        return data.getShort(recnum * m.getSize());
    }

    public short[] getJavaArrayShort(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.SHORT) {
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be short");
        }
        int count = m.getSize();
        Array data = (Array)m.getDataObject();
        short[] pa = new short[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getShort(recnum * count + i);
        }
        return pa;
    }

    public int getScalarInt(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.INT) {
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be int");
        }
        Array data = (Array)m.getDataObject();
        return data.getInt(recnum * m.getSize());
    }

    public int[] getJavaArrayInt(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.INT) {
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be int");
        }
        int count = m.getSize();
        Array data = (Array)m.getDataObject();
        int[] pa = new int[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getInt(recnum * count + i);
        }
        return pa;
    }

    public long getScalarLong(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.LONG) {
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be long");
        }
        Array data = (Array)m.getDataObject();
        return data.getLong(recnum * m.getSize());
    }

    public long[] getJavaArrayLong(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.LONG) {
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be long");
        }
        int count = m.getSize();
        Array data = (Array)m.getDataObject();
        long[] pa = new long[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getLong(recnum * count + i);
        }
        return pa;
    }

    public char getScalarChar(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.CHAR) {
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be char");
        }
        Array data = (Array)m.getDataObject();
        return data.getChar(recnum * m.getSize());
    }

    public char[] getJavaArrayChar(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.CHAR) {
            throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be char");
        }
        int count = m.getSize();
        Array data = (Array)m.getDataObject();
        char[] pa = new char[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getChar(recnum * count + i);
        }
        return pa;
    }

    public String getScalarString(int recnum, StructureMembers.Member m) {
        if (m.getDataType() == DataType.CHAR) {
            ArrayChar data = (ArrayChar)m.getDataObject();
            return data.getString(recnum);
        }
        if (m.getDataType() == DataType.STRING) {
            ArrayObject data = (ArrayObject)m.getDataObject();
            return (String)data.getObject(recnum);
        }
        throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be String or char");
    }

    public String[] getJavaArrayString(int recnum, StructureMembers.Member m) {
        int n = m.getSize();
        String[] result = new String[n];
        if (m.getDataType() == DataType.CHAR) {
            ArrayChar data = (ArrayChar)m.getDataObject();
            for (int i = 0; i < n; ++i) {
                result[i] = data.getString(recnum * n + i);
            }
            return result;
        }
        if (m.getDataType() == DataType.STRING) {
            Array data = (Array)m.getDataObject();
            for (int i = 0; i < n; ++i) {
                result[i] = (String)data.getObject(recnum * n + i);
            }
            return result;
        }
        throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be String or char");
    }

    public StructureData getScalarStructure(int recnum, StructureMembers.Member m) {
        if (m.getDataType() == DataType.STRUCTURE) {
            ArrayStructure data = (ArrayStructure)m.getDataObject();
            return data.getStructureData(recnum * m.getSize());
        }
        throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be Structure");
    }

    public ArrayStructure getArrayStructure(int recnum, StructureMembers.Member m) {
        if (m.getDataType() == DataType.STRUCTURE) {
            int[] shape;
            StructureData[] this_sdata;
            ArrayStructure array = (ArrayStructure)m.getDataObject();
            if (array instanceof ArraySequence) {
                ArraySequence arraySeq = (ArraySequence)array;
                int count = arraySeq.getSequenceLength(recnum);
                int start = arraySeq.getSequenceOffset(recnum);
                this_sdata = new StructureData[count];
                for (int i = 0; i < count; ++i) {
                    this_sdata[i] = arraySeq.makeStructureData(arraySeq, start + i);
                }
                shape = new int[]{count};
            } else {
                int count = m.getSize();
                this_sdata = new StructureData[count];
                for (int i = 0; i < count; ++i) {
                    this_sdata[i] = array.getStructureData(recnum * count + i);
                }
                shape = m.getShape();
            }
            return new ArrayStructureW(array.getStructureMembers(), shape, this_sdata);
        }
        throw new IllegalArgumentException("Type is " + m.getDataType() + ", must be Structure");
    }
}

