/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.grid;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.ma2.Range;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.FileWriter;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordTransBuilder;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dataset.grid.GridCoordSys;
import ucar.nc2.dataset.grid.GridDataset;
import ucar.nc2.util.NamedObject;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.util.Format;

public class GeoGrid
implements NamedObject {
    private GridDataset dataset;
    private GridCoordSys gcs;
    private VariableEnhanced vs;
    private int xDimOrgIndex = -1;
    private int yDimOrgIndex = -1;
    private int zDimOrgIndex = -1;
    private int tDimOrgIndex = -1;
    private int xDimNewIndex = -1;
    private int yDimNewIndex = -1;
    private int zDimNewIndex = -1;
    private int tDimNewIndex = -1;
    private ArrayList mydims;
    private boolean debugArrayShape = false;
    private volatile int hashCode = 0;

    public GeoGrid(GridDataset dataset, VariableEnhanced dsvar, GridCoordSys gcs) {
        this.dataset = dataset;
        this.vs = dsvar;
        this.gcs = gcs;
        if (gcs.isProductSet()) {
            this.xDimOrgIndex = this.findDimension(gcs.getXHorizAxis().getDimension(0));
            this.yDimOrgIndex = this.findDimension(gcs.getYHorizAxis().getDimension(0));
        } else {
            this.yDimOrgIndex = this.findDimension(gcs.getXHorizAxis().getDimension(0));
            this.xDimOrgIndex = this.findDimension(gcs.getXHorizAxis().getDimension(1));
        }
        if (gcs.getVerticalAxis() != null) {
            this.zDimOrgIndex = this.findDimension(gcs.getVerticalAxis().getDimension(0));
        }
        if (gcs.getTimeAxis() != null) {
            this.tDimOrgIndex = this.findDimension(gcs.getTimeAxis().getDimension(0));
        }
        int count = 0;
        this.mydims = new ArrayList();
        if (this.tDimOrgIndex >= 0) {
            this.mydims.add(dsvar.getDimension(this.tDimOrgIndex));
            this.tDimNewIndex = count++;
        }
        if (this.zDimOrgIndex >= 0) {
            this.mydims.add(dsvar.getDimension(this.zDimOrgIndex));
            this.zDimNewIndex = count++;
        }
        if (this.yDimOrgIndex >= 0) {
            this.mydims.add(dsvar.getDimension(this.yDimOrgIndex));
            this.yDimNewIndex = count++;
        }
        if (this.xDimOrgIndex >= 0) {
            this.mydims.add(dsvar.getDimension(this.xDimOrgIndex));
            this.xDimNewIndex = count++;
        }
    }

    private int findDimension(Dimension want) {
        List<Dimension> dims = this.vs.getDimensions();
        for (int i = 0; i < dims.size(); ++i) {
            Dimension d = dims.get(i);
            if (!d.equals(want)) continue;
            return i;
        }
        return -1;
    }

    public List getDimensions() {
        return new ArrayList(this.mydims);
    }

    public Dimension getDimension(int i) {
        if (i < 0 || i >= this.mydims.size()) {
            return null;
        }
        return (Dimension)this.mydims.get(i);
    }

    public Dimension getTimeDimension() {
        return this.tDimNewIndex < 0 ? null : this.getDimension(this.tDimNewIndex);
    }

    public Dimension getZDimension() {
        return this.zDimNewIndex < 0 ? null : this.getDimension(this.zDimNewIndex);
    }

    public Dimension getYDimension() {
        return this.yDimNewIndex < 0 ? null : this.getDimension(this.yDimNewIndex);
    }

    public Dimension getXDimension() {
        return this.xDimNewIndex < 0 ? null : this.getDimension(this.xDimNewIndex);
    }

    public int getTimeDimensionIndex() {
        return this.tDimNewIndex;
    }

    public int getZDimensionIndex() {
        return this.zDimNewIndex;
    }

    public int getYDimensionIndex() {
        return this.yDimNewIndex;
    }

    public int getXDimensionIndex() {
        return this.xDimNewIndex;
    }

    public Attribute findAttributeIgnoreCase(String name) {
        return this.vs.findAttributeIgnoreCase(name);
    }

    public String findAttValueIgnoreCase(String attName, String defaultValue) {
        return this.dataset.getNetcdfDataset().findAttValueIgnoreCase((Variable)((Object)this.vs), attName, defaultValue);
    }

    public int getRank() {
        return this.vs.getRank();
    }

    public int[] getShape() {
        return this.vs.getShape();
    }

    public DataType getDataType() {
        return this.vs.getDataType();
    }

    public List getAttributes() {
        return this.vs.getAttributes();
    }

    public VariableEnhanced getVariable() {
        return this.vs;
    }

    public String getName() {
        return this.vs.getName();
    }

    public GridCoordSys getCoordinateSystem() {
        return this.gcs;
    }

    public ProjectionImpl getProjection() {
        return this.gcs.getProjection();
    }

    public ArrayList getLevels() {
        return this.gcs.getLevels();
    }

    public ArrayList getTimes() {
        return this.gcs.getTimes();
    }

    public String getDescription() {
        return this.vs.getDescription();
    }

    public String getUnitsString() {
        String units = this.vs.getUnitsString();
        return units == null ? "" : units;
    }

    public String getUnitString() {
        return this.getUnitsString();
    }

    public boolean hasMissingData() {
        return this.vs.hasMissing();
    }

    public boolean isMissingData(double val) {
        return this.vs.isMissing(val);
    }

    public float[] setMissingToNaN(float[] values) {
        if (!this.vs.hasMissing()) {
            return values;
        }
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            double value = values[i];
            if (!this.vs.isMissing(value)) continue;
            values[i] = Float.NaN;
        }
        return values;
    }

    public MAMath.MinMax getMinMaxSkipMissingData(Array a) {
        if (!this.hasMissingData()) {
            return MAMath.getMinMax(a);
        }
        IndexIterator iter = a.getIndexIterator();
        double max = -1.7976931348623157E308;
        double min = Double.MAX_VALUE;
        while (iter.hasNext()) {
            double val = iter.getDoubleNext();
            if (this.isMissingData(val)) continue;
            if (val > max) {
                max = val;
            }
            if (!(val < min)) continue;
            min = val;
        }
        return new MAMath.MinMax(min, max);
    }

    public Array readVolumeData(int t) throws IOException {
        return this.readDataSlice(t, -1, -1, -1);
    }

    public Array readYXData(int t, int z) throws IOException {
        return this.readDataSlice(t, z, -1, -1);
    }

    public Array readZYData(int t, int x) throws IOException {
        return this.readDataSlice(t, -1, -1, x);
    }

    public Array getDataSlice(int t, int z, int y, int x) throws IOException {
        return this.readDataSlice(t, z, y, x);
    }

    public Array readDataSlice(int t, int z, int y, int x) throws IOException {
        Array dataVolume;
        int rank = this.vs.getRank();
        int[] start = new int[rank];
        int[] shape = new int[rank];
        for (int i = 0; i < rank; ++i) {
            start[i] = 0;
            shape[i] = 1;
        }
        Dimension xdim = this.getXDimension();
        Dimension ydim = this.getYDimension();
        Dimension zdim = this.getZDimension();
        Dimension tdim = this.getTimeDimension();
        if (tdim != null) {
            if (t >= 0 && t < tdim.getLength()) {
                start[this.tDimOrgIndex] = t;
            } else {
                shape[this.tDimOrgIndex] = tdim.getLength();
            }
        }
        if (zdim != null) {
            if (z >= 0 && z < zdim.getLength()) {
                start[this.zDimOrgIndex] = z;
            } else {
                shape[this.zDimOrgIndex] = zdim.getLength();
            }
        }
        if (ydim != null) {
            if (y >= 0 && y < ydim.getLength()) {
                start[this.yDimOrgIndex] = y;
            } else {
                shape[this.yDimOrgIndex] = ydim.getLength();
            }
        }
        if (xdim != null) {
            if (x >= 0 && x < xdim.getLength()) {
                start[this.xDimOrgIndex] = x;
            } else {
                shape[this.xDimOrgIndex] = xdim.getLength();
            }
        }
        if (this.debugArrayShape) {
            System.out.println("read shape from org variable = ");
            for (int i = 0; i < rank; ++i) {
                System.out.println("   start = " + start[i] + " shape = " + shape[i] + " name = " + this.vs.getDimension(i).getName());
            }
        }
        try {
            dataVolume = this.vs.read(start, shape);
        }
        catch (Exception e) {
            System.out.println("Exception: GeoGrid.getdataSlice() on dataset " + this.getName());
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        ArrayList<Dimension> oldDims = new ArrayList<Dimension>(this.vs.getDimensions());
        int[] permuteIndex = new int[dataVolume.getRank()];
        int count = 0;
        if (oldDims.contains(tdim)) {
            permuteIndex[count++] = oldDims.indexOf(tdim);
        }
        if (oldDims.contains(zdim)) {
            permuteIndex[count++] = oldDims.indexOf(zdim);
        }
        if (oldDims.contains(ydim)) {
            permuteIndex[count++] = oldDims.indexOf(ydim);
        }
        if (oldDims.contains(xdim)) {
            permuteIndex[count++] = oldDims.indexOf(xdim);
        }
        if (this.debugArrayShape) {
            int i;
            System.out.println("oldDims = ");
            for (i = 0; i < oldDims.size(); ++i) {
                System.out.println("   oldDim = " + oldDims.get(i).getName());
            }
            System.out.println("permute dims = ");
            for (i = 0; i < permuteIndex.length; ++i) {
                System.out.println("   oldDim index = " + permuteIndex[i]);
            }
        }
        dataVolume = dataVolume.permute(permuteIndex);
        count = 0;
        if (tdim != null) {
            if (t >= 0) {
                dataVolume = dataVolume.reduce(count);
            } else {
                ++count;
            }
        }
        if (zdim != null) {
            if (z >= 0) {
                dataVolume = dataVolume.reduce(count);
            } else {
                ++count;
            }
        }
        if (ydim != null) {
            if (y >= 0) {
                dataVolume = dataVolume.reduce(count);
            } else {
                ++count;
            }
        }
        if (xdim != null) {
            if (x >= 0) {
                dataVolume = dataVolume.reduce(count);
            } else {
                ++count;
            }
        }
        return dataVolume;
    }

    public GeoGrid subset(Range t_range, Range z_range, LatLonRect bbox, int z_stride, int y_stride, int x_stride) throws InvalidRangeException {
        Dimension zdim;
        if (z_range == null && z_stride > 1 && (zdim = this.getZDimension()) != null) {
            z_range = new Range(0, zdim.getLength() - 1, z_stride);
        }
        Range y_range = null;
        Range x_range = null;
        if (bbox != null) {
            List yx_ranges = this.gcs.getLatLonBoundingBox(bbox);
            y_range = (Range)yx_ranges.get(0);
            x_range = (Range)yx_ranges.get(1);
        }
        if (y_stride > 1) {
            if (y_range == null) {
                Dimension ydim = this.getYDimension();
                y_range = new Range(0, ydim.getLength() - 1, y_stride);
            } else {
                y_range = new Range(y_range.first(), y_range.last(), y_stride);
            }
        }
        if (x_stride > 1) {
            if (x_range == null) {
                Dimension xdim = this.getXDimension();
                x_range = new Range(0, xdim.getLength() - 1, x_stride);
            } else {
                x_range = new Range(x_range.first(), x_range.last(), x_stride);
            }
        }
        return this.subset(t_range, z_range, y_range, x_range);
    }

    public GeoGrid subset(Range t_range, Range z_range, Range y_range, Range x_range) throws InvalidRangeException {
        int rank = this.getRank();
        Range[] ranges = new Range[rank];
        if (null != this.getXDimension()) {
            ranges[this.xDimOrgIndex] = x_range;
        }
        if (null != this.getYDimension()) {
            ranges[this.yDimOrgIndex] = y_range;
        }
        if (null != this.getZDimension()) {
            ranges[this.zDimOrgIndex] = z_range;
        }
        if (null != this.getTimeDimension()) {
            ranges[this.tDimOrgIndex] = t_range;
        }
        List<Range> rangesList = Arrays.asList(ranges);
        VariableDS v_section = (VariableDS)this.vs.section(rangesList);
        List<Dimension> dims = v_section.getDimensions();
        for (int j = 0; j < dims.size(); ++j) {
            Dimension dim = dims.get(j);
            dim.setShared(true);
        }
        GridCoordSys gcs_section = new GridCoordSys(this.gcs, t_range, z_range, y_range, x_range);
        return new GeoGrid(this.dataset, v_section, gcs_section);
    }

    public void writeFile(String filename) throws IOException {
        Variable v;
        FileWriter writer = new FileWriter(filename, true);
        ArrayList<Variable> varList = new ArrayList<Variable>();
        varList.add((Variable)((Object)this.vs));
        List<CoordinateAxis> axes = this.gcs.getCoordinateAxes();
        for (int i = 0; i < axes.size(); ++i) {
            v = axes.get(i);
            varList.add(v);
        }
        writer.writeVariables(varList);
        ProjectionCT projCT = this.gcs.getProjectionCT();
        if (projCT != null) {
            v = CoordTransBuilder.makeDummyTransformVariable(this.dataset.getNetcdfDataset(), projCT);
            v.addAttribute(new Attribute("_CoordinateAxisTypes", "GeoX GeoY"));
            writer.writeVariable(v);
        }
        String location = this.dataset.getNetcdfDataset().getLocation();
        writer.writeGlobalAttribute(new Attribute("History", "GeoGrid extracted from dataset " + location));
        writer.writeGlobalAttribute(new Attribute("Convention", "_Coordinates"));
        writer.finish();
    }

    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (!(oo instanceof GeoGrid)) {
            return false;
        }
        GeoGrid d = (GeoGrid)oo;
        if (!this.getName().equals(d.getName())) {
            return false;
        }
        return this.getCoordinateSystem().equals(d.getCoordinateSystem());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.getName().hashCode();
            this.hashCode = result = 37 * result + this.getCoordinateSystem().hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return this.getName();
    }

    public String getInfo() {
        StringBuffer buf = new StringBuffer(200);
        buf.setLength(0);
        buf.append(this.getName());
        Format.tab(buf, 15, true);
        buf.append(this.getUnitsString());
        Format.tab(buf, 30, true);
        buf.append(this.hasMissingData());
        Format.tab(buf, 40, true);
        buf.append(this.getDescription());
        return buf.toString();
    }
}

