/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.point;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.AxisType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class UnidataObsDatasetHelper {
    public static Date getStartDate(NetcdfDataset ds) {
        Attribute att = ds.findGlobalAttributeIgnoreCase("time_coverage_start");
        if (null == att) {
            throw new IllegalArgumentException("Must have a time_coverage_start global attribute");
        }
        if (att.getDataType() == DataType.STRING) {
            return DateUnit.getStandardOrISO(att.getStringValue());
        }
        throw new IllegalArgumentException("time_coverage_start must be a ISO or udunit date string");
    }

    public static Date getEndDate(NetcdfDataset ds) {
        Attribute att = ds.findGlobalAttributeIgnoreCase("time_coverage_end");
        if (null == att) {
            throw new IllegalArgumentException("Must have a time_coverage_end global attribute");
        }
        if (att.getDataType() != DataType.STRING) {
            throw new IllegalArgumentException("time_coverage_end must be a ISO or udunit date string");
        }
        Date result = DateUnit.getStandardOrISO(att.getStringValue());
        return result;
    }

    public static LatLonRect getBoundingBox(NetcdfDataset ds) {
        double lat_max = UnidataObsDatasetHelper.getAttAsDouble(ds, "geospatial_lat_max");
        double lat_min = UnidataObsDatasetHelper.getAttAsDouble(ds, "geospatial_lat_min");
        double lon_max = UnidataObsDatasetHelper.getAttAsDouble(ds, "geospatial_lon_max");
        double lon_min = UnidataObsDatasetHelper.getAttAsDouble(ds, "geospatial_lon_min");
        return new LatLonRect(new LatLonPointImpl(lat_min, lon_min), lat_max - lat_min, lon_max - lon_min);
    }

    private static double getAttAsDouble(NetcdfDataset ds, String attname) {
        Attribute att = ds.findGlobalAttributeIgnoreCase(attname);
        if (null == att) {
            throw new IllegalArgumentException("Must have a " + attname + " global attribute");
        }
        if (att.getDataType() == DataType.STRING) {
            return Double.parseDouble(att.getStringValue());
        }
        return att.getNumericValue().doubleValue();
    }

    public static Variable getCoordinate(NetcdfDataset ds, AxisType a) {
        List<Variable> varList = ds.getVariables();
        for (int i = 0; i < varList.size(); ++i) {
            Variable v = varList.get(i);
            if (v instanceof Structure) {
                ArrayList vars = (ArrayList)((Structure)v).getVariables();
                for (int j = 0; j < vars.size(); ++j) {
                    Variable vs = (Variable)vars.get(j);
                    String axisType = ds.findAttValueIgnoreCase(vs, "_CoordinateAxisType", null);
                    if (axisType == null || !axisType.equals(a.toString())) continue;
                    return vs;
                }
                continue;
            }
            String axisType = ds.findAttValueIgnoreCase(v, "_CoordinateAxisType", null);
            if (axisType == null || !axisType.equals(a.toString())) continue;
            return v;
        }
        if (a == AxisType.Lat) {
            return UnidataObsDatasetHelper.findVariable(ds, "latitude");
        }
        if (a == AxisType.Lon) {
            return UnidataObsDatasetHelper.findVariable(ds, "longitude");
        }
        if (a == AxisType.Time) {
            return UnidataObsDatasetHelper.findVariable(ds, "time");
        }
        if (a == AxisType.Height) {
            Variable v = UnidataObsDatasetHelper.findVariable(ds, "altitude");
            if (null == v) {
                v = UnidataObsDatasetHelper.findVariable(ds, "depth");
            }
            return v;
        }
        return null;
    }

    public static Variable findVariable(NetcdfDataset ds, String name) {
        Variable result = ds.findVariable(name);
        if (result == null) {
            String aname = ds.findAttValueIgnoreCase(null, name + "_coordinate", null);
            if (aname != null) {
                result = ds.findVariable(aname);
            } else {
                aname = ds.findAttValueIgnoreCase(null, name + "_variable", null);
                if (aname != null) {
                    result = ds.findVariable(aname);
                }
            }
        }
        return result;
    }

    public static Dimension findDimension(NetcdfFile ds, String name) {
        String aname;
        Dimension result = ds.findDimension(name);
        if (result == null && (aname = ds.findAttValueIgnoreCase(null, name + "Dimension", null)) != null) {
            result = ds.findDimension(aname);
        }
        return result;
    }
}

