/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc;

import java.io.Serializable;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.util.Format;

public class LatLonPointImpl
implements LatLonPoint,
Serializable {
    static StringBuffer latBuff = new StringBuffer(20);
    static StringBuffer lonBuff = new StringBuffer(20);
    private double lat;
    private double lon;

    public static boolean betweenLon(double lon, double lonBeg, double lonEnd) {
        lonBeg = LatLonPointImpl.lonNormal(lonBeg, lon);
        lonEnd = LatLonPointImpl.lonNormal(lonEnd, lon);
        return lon >= lonBeg && lon <= lonEnd;
    }

    public static double range180(double lon) {
        return LatLonPointImpl.lonNormal(lon);
    }

    public static double lonNormal360(double lon) {
        return LatLonPointImpl.lonNormal(lon, 180.0);
    }

    public static double lonNormal(double lon, double center) {
        return center + Math.IEEEremainder(lon - center, 360.0);
    }

    public static double lonNormal(double lon) {
        if (lon < -180.0 || lon > 180.0) {
            return Math.IEEEremainder(lon, 360.0);
        }
        return lon;
    }

    public static double latNormal(double lat) {
        if (lat < -90.0) {
            return -90.0;
        }
        if (lat > 90.0) {
            return 90.0;
        }
        return lat;
    }

    public static String latToString(double lat, int sigDigits) {
        boolean is_north;
        boolean bl = is_north = lat >= 0.0;
        if (!is_north) {
            lat = -lat;
        }
        latBuff.setLength(0);
        latBuff.append(Format.d(lat, sigDigits));
        latBuff.append(is_north ? "N" : "S");
        return latBuff.toString();
    }

    public static String lonToString(double lon, int sigDigits) {
        boolean is_east;
        double wlon = LatLonPointImpl.lonNormal(lon);
        boolean bl = is_east = wlon >= 0.0;
        if (!is_east) {
            wlon = -wlon;
        }
        lonBuff.setLength(0);
        lonBuff.append(Format.d(wlon, sigDigits));
        lonBuff.append(is_east ? "E" : "W");
        return lonBuff.toString();
    }

    public LatLonPointImpl() {
        this(0.0, 0.0);
    }

    public LatLonPointImpl(LatLonPoint pt) {
        this(pt.getLatitude(), pt.getLongitude());
    }

    public LatLonPointImpl(double lat, double lon) {
        this.setLatitude(lat);
        this.setLongitude(lon);
    }

    public double getLongitude() {
        return this.lon;
    }

    public double getLatitude() {
        return this.lat;
    }

    public void set(LatLonPoint pt) {
        this.setLongitude(pt.getLongitude());
        this.setLatitude(pt.getLatitude());
    }

    public void set(double lat, double lon) {
        this.setLongitude(lon);
        this.setLatitude(lat);
    }

    public void set(float lat, float lon) {
        this.setLongitude(lon);
        this.setLatitude(lat);
    }

    public void setLongitude(double lon) {
        this.lon = LatLonPointImpl.lonNormal(lon);
    }

    public void setLatitude(double lat) {
        this.lat = LatLonPointImpl.latNormal(lat);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LatLonPointImpl)) {
            return false;
        }
        LatLonPointImpl that = (LatLonPointImpl)obj;
        return this.lat == that.lat && this.lon == that.lon;
    }

    public boolean equals(LatLonPoint pt) {
        boolean lonOk = this.closeEnough(pt.getLongitude(), this.lon);
        if (!lonOk) {
            lonOk = this.closeEnough(LatLonPointImpl.lonNormal360(pt.getLongitude()), LatLonPointImpl.lonNormal360(this.lon));
        }
        return lonOk && this.closeEnough(pt.getLatitude(), this.lat);
    }

    private boolean closeEnough(double d1, double d2) {
        if (d1 != 0.0) {
            return Math.abs((d1 - d2) / d1) < 1.0E-9;
        }
        if (d2 != 0.0) {
            return Math.abs((d1 - d2) / d2) < 1.0E-9;
        }
        return true;
    }

    public String toString() {
        return this.toString(4);
    }

    public String toString(int sigDigits) {
        StringBuffer sbuff = new StringBuffer(40);
        sbuff.setLength(0);
        sbuff.append(LatLonPointImpl.latToString(this.lat, sigDigits));
        sbuff.append(" ");
        sbuff.append(LatLonPointImpl.lonToString(this.lon, sigDigits));
        return sbuff.toString();
    }
}

