/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;

public class LambertAzimuthalEqualArea
extends ProjectionImpl {
    private double R;
    private double sinLat0;
    private double cosLat0;
    private double lon0Degrees;
    private double lat0;
    private double lon0;
    private double falseEasting;
    private double falseNorthing;
    private LatLonPointImpl origin;
    private boolean spherical = true;

    public ProjectionImpl constructCopy() {
        return new LambertAzimuthalEqualArea(this.getOriginLat(), this.getOriginLon(), this.getFalseEasting(), this.getFalseNorthing(), this.R);
    }

    public LambertAzimuthalEqualArea() {
        this(40.0, 100.0);
    }

    public LambertAzimuthalEqualArea(double lat0, double lon0) {
        this(lat0, lon0, 0.0, 0.0, EARTH_RADIUS);
    }

    public LambertAzimuthalEqualArea(double lat0, double lon0, double false_easting, double false_northing, double earthRadius) {
        this.lat0 = Math.toRadians(lat0);
        this.lon0Degrees = lon0;
        this.lon0 = Math.toRadians(lon0);
        this.R = earthRadius;
        if (Double.isNaN(false_easting)) {
            false_easting = 0.0;
        }
        if (Double.isNaN(false_northing)) {
            false_northing = 0.0;
        }
        this.falseEasting = false_easting;
        this.falseNorthing = false_northing;
        this.origin = new LatLonPointImpl(lat0, lon0);
        this.precalculate();
        this.addParameter("Projection_Name", "lambert_azimuthal_equal_area");
        this.addParameter("latitude_of_projection_origin", lat0);
        this.addParameter("longitude_of_projection_origin", lon0);
        if (false_easting != 0.0 || false_northing != 0.0) {
            this.addParameter("false_easting", false_easting);
            this.addParameter("false_northing", false_northing);
            this.addParameter("units", "km");
        }
    }

    private void precalculate() {
        this.sinLat0 = Math.sin(this.lat0);
        this.cosLat0 = Math.cos(this.lat0);
        this.lon0Degrees = Math.toDegrees(this.lon0);
    }

    public Object clone() {
        LambertAzimuthalEqualArea cl = (LambertAzimuthalEqualArea)super.clone();
        cl.origin = new LatLonPointImpl(this.getOriginLat(), this.getOriginLon());
        return cl;
    }

    public boolean equals(Object proj) {
        if (!(proj instanceof LambertAzimuthalEqualArea)) {
            return false;
        }
        LambertAzimuthalEqualArea oo = (LambertAzimuthalEqualArea)proj;
        return this.getOriginLat() == oo.getOriginLat() && this.getOriginLon() == oo.getOriginLon() && this.defaultMapArea.equals(oo.defaultMapArea);
    }

    public double getOriginLon() {
        return this.origin.getLongitude();
    }

    public void setOriginLon(double lon) {
        this.origin.setLongitude(lon);
        this.lon0 = Math.toRadians(lon);
        this.precalculate();
    }

    public double getOriginLat() {
        return this.origin.getLatitude();
    }

    public void setOriginLat(double lat) {
        this.origin.setLatitude(lat);
        this.lat0 = Math.toRadians(lat);
        this.precalculate();
    }

    public double getFalseEasting() {
        return this.falseEasting;
    }

    public void setFalseEasting(double falseEasting) {
        this.falseEasting = falseEasting;
    }

    public double getFalseNorthing() {
        return this.falseNorthing;
    }

    public void setFalseNorthing(double falseNorthing) {
        this.falseNorthing = falseNorthing;
    }

    public String getProjectionTypeLabel() {
        return "Lambert Azimuth Equal Area";
    }

    public String paramsToString() {
        return " origin " + this.origin.toString();
    }

    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        if (ProjectionPointImpl.isInfinite(pt1) || ProjectionPointImpl.isInfinite(pt2)) {
            return true;
        }
        return pt1.getX() * pt2.getX() < 0.0 && Math.abs(pt1.getX() - pt2.getX()) > 5000.0;
    }

    public ProjectionPoint latLonToProj(LatLonPoint latLon, ProjectionPointImpl result) {
        double fromLat = latLon.getLatitude();
        double fromLon = latLon.getLongitude();
        fromLat = Math.toRadians(fromLat);
        double lonDiff = Math.toRadians(LatLonPointImpl.lonNormal(fromLon - this.lon0Degrees));
        double g = this.sinLat0 * Math.sin(fromLat) + this.cosLat0 * Math.cos(fromLat) * Math.cos(lonDiff);
        double kPrime = Math.sqrt(2.0 / (1.0 + g));
        double toX = this.R * kPrime * Math.cos(fromLat) * Math.sin(lonDiff) + this.falseEasting;
        double toY = this.R * kPrime * (this.cosLat0 * Math.sin(fromLat) - this.sinLat0 * Math.cos(fromLat) * Math.cos(lonDiff)) + this.falseNorthing;
        result.setLocation(toX, toY);
        return result;
    }

    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        double toLat;
        double fromX = world.getX();
        double fromY = world.getY();
        double rho = Math.sqrt((fromX -= this.falseEasting) * fromX + (fromY -= this.falseNorthing) * fromY);
        double c = 2.0 * Math.asin(rho / (2.0 * this.R));
        double toLon = this.lon0;
        double temp = 0.0;
        if (Math.abs(rho) > 1.0E-6) {
            toLat = Math.asin(Math.cos(c) * this.sinLat0 + fromY * Math.sin(c) * this.cosLat0 / rho);
            if (Math.abs(this.lat0 - 0.7853981633974483) > 1.0E-6) {
                temp = rho * this.cosLat0 * Math.cos(c) - fromY * this.sinLat0 * Math.sin(c);
                toLon = this.lon0 + Math.atan(fromX * Math.sin(c) / temp);
            } else if (this.lat0 == 0.7853981633974483) {
                toLon = this.lon0 + Math.atan(fromX / -fromY);
                temp = -fromY;
            } else {
                toLon = this.lon0 + Math.atan(fromX / fromY);
                temp = fromY;
            }
        } else {
            toLat = this.lat0;
        }
        toLat = Math.toDegrees(toLat);
        toLon = Math.toDegrees(toLon);
        if (temp < 0.0) {
            toLon += 180.0;
        }
        toLon = LatLonPointImpl.lonNormal(toLon);
        result.setLatitude(toLat);
        result.setLongitude(toLon);
        return result;
    }

    public float[][] latLonToProj(float[][] from, float[][] to, int latIndex, int lonIndex) {
        int cnt = from[0].length;
        float[] fromLatA = from[latIndex];
        float[] fromLonA = from[lonIndex];
        float[] resultXA = to[0];
        float[] resultYA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double fromLat = fromLatA[i];
            double fromLon = fromLonA[i];
            fromLat = Math.toRadians(fromLat);
            double lonDiff = Math.toRadians(LatLonPointImpl.lonNormal(fromLon - this.lon0Degrees));
            double g = this.sinLat0 * Math.sin(fromLat) + this.cosLat0 * Math.cos(fromLat) * Math.cos(lonDiff);
            double kPrime = Math.sqrt(2.0 / (1.0 + g));
            double toX = this.R * kPrime * Math.cos(fromLat) * Math.sin(lonDiff) + this.falseEasting;
            double toY = this.R * kPrime * (this.cosLat0 * Math.sin(fromLat) - this.sinLat0 * Math.cos(fromLat) * Math.cos(lonDiff)) + this.falseNorthing;
            resultXA[i] = (float)toX;
            resultYA[i] = (float)toY;
        }
        return to;
    }

    public float[][] projToLatLon(float[][] from, float[][] to) {
        int cnt = from[0].length;
        float[] fromXA = from[0];
        float[] fromYA = from[1];
        float[] toLatA = to[0];
        float[] toLonA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double toLat;
            double fromX = fromXA[i];
            double fromY = fromYA[i];
            double rho = Math.sqrt((fromX -= this.falseEasting) * fromX + (fromY -= this.falseNorthing) * fromY);
            double c = 2.0 * Math.asin(rho / (2.0 * this.R));
            double toLon = this.lon0;
            double temp = 0.0;
            if (Math.abs(rho) > 1.0E-6) {
                toLat = Math.asin(Math.cos(c) * this.sinLat0 + fromY * Math.sin(c) * this.cosLat0 / rho);
                if (Math.abs(this.lat0 - 0.7853981633974483) > 1.0E-6) {
                    temp = rho * this.cosLat0 * Math.cos(c) - fromY * this.sinLat0 * Math.sin(c);
                    toLon = this.lon0 + Math.atan(fromX * Math.sin(c) / temp);
                } else if (this.lat0 == 0.7853981633974483) {
                    toLon = this.lon0 + Math.atan(fromX / -fromY);
                    temp = -fromY;
                } else {
                    toLon = this.lon0 + Math.atan(fromX / fromY);
                    temp = fromY;
                }
            } else {
                toLat = this.lat0;
            }
            toLat = Math.toDegrees(toLat);
            toLon = Math.toDegrees(toLon);
            if (temp < 0.0) {
                toLon += 180.0;
            }
            toLon = LatLonPointImpl.lonNormal(toLon);
            toLatA[i] = (float)toLat;
            toLonA[i] = (float)toLon;
        }
        return to;
    }

    public double[][] latLonToProj(double[][] from, double[][] to, int latIndex, int lonIndex) {
        int cnt = from[0].length;
        double[] fromLatA = from[latIndex];
        double[] fromLonA = from[lonIndex];
        double[] resultXA = to[0];
        double[] resultYA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double fromLat = fromLatA[i];
            double fromLon = fromLonA[i];
            fromLat = Math.toRadians(fromLat);
            double lonDiff = Math.toRadians(LatLonPointImpl.lonNormal(fromLon - this.lon0Degrees));
            double g = this.sinLat0 * Math.sin(fromLat) + this.cosLat0 * Math.cos(fromLat) * Math.cos(lonDiff);
            double kPrime = Math.sqrt(2.0 / (1.0 + g));
            double toX = this.R * kPrime * Math.cos(fromLat) * Math.sin(lonDiff) + this.falseEasting;
            double toY = this.R * kPrime * (this.cosLat0 * Math.sin(fromLat) - this.sinLat0 * Math.cos(fromLat) * Math.cos(lonDiff)) + this.falseNorthing;
            resultXA[i] = toX;
            resultYA[i] = toY;
        }
        return to;
    }

    public double[][] projToLatLon(double[][] from, double[][] to) {
        int cnt = from[0].length;
        double[] fromXA = from[0];
        double[] fromYA = from[1];
        double[] toLatA = to[0];
        double[] toLonA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double toLat;
            double fromX = fromXA[i];
            double fromY = fromYA[i];
            double rho = Math.sqrt((fromX -= this.falseEasting) * fromX + (fromY -= this.falseNorthing) * fromY);
            double c = 2.0 * Math.asin(rho / (2.0 * this.R));
            double toLon = this.lon0;
            double temp = 0.0;
            if (Math.abs(rho) > 1.0E-6) {
                toLat = Math.asin(Math.cos(c) * this.sinLat0 + fromY * Math.sin(c) * this.cosLat0 / rho);
                if (Math.abs(this.lat0 - 0.7853981633974483) > 1.0E-6) {
                    temp = rho * this.cosLat0 * Math.cos(c) - fromY * this.sinLat0 * Math.sin(c);
                    toLon = this.lon0 + Math.atan(fromX * Math.sin(c) / temp);
                } else if (this.lat0 == 0.7853981633974483) {
                    toLon = this.lon0 + Math.atan(fromX / -fromY);
                    temp = -fromY;
                } else {
                    toLon = this.lon0 + Math.atan(fromX / fromY);
                    temp = fromY;
                }
            } else {
                toLat = this.lat0;
            }
            toLat = Math.toDegrees(toLat);
            toLon = Math.toDegrees(toLon);
            if (temp < 0.0) {
                toLon += 180.0;
            }
            toLon = LatLonPointImpl.lonNormal(toLon);
            toLatA[i] = toLat;
            toLonA[i] = toLon;
        }
        return to;
    }

    public static void main(String[] args) {
        LambertAzimuthalEqualArea a = new LambertAzimuthalEqualArea(40.0, -100.0);
        ProjectionPointImpl p = a.latLonToProj(-20.0, 100.0);
        System.out.println("proj point = " + p);
        LatLonPoint ll = a.projToLatLon(p);
        System.out.println("ll = " + ll);
    }
}

