/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.UnsupportedCompressionException;
import loci.formats.meta.MetadataStore;

public class LIMReader
extends FormatReader {
    private static final int PIXELS_OFFSET = 2379;
    private boolean isCompressed;

    public LIMReader() {
        super("Laboratory Imaging", "lim");
        this.domains = new String[]{"Light Microscopy"};
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(2379L);
        this.readPlane(this.in, x, y, w, h, buf);
        if (this.isRGB()) {
            for (int i = 0; i < buf.length / 3; ++i) {
                byte tmp = buf[i * 3];
                buf[i * 3] = buf[i * 3 + 2];
                buf[i * 3 + 2] = tmp;
            }
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.isCompressed = false;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.core[0].littleEndian = true;
        this.in.order(this.isLittleEndian());
        this.core[0].sizeX = this.in.readShort() & Short.MAX_VALUE;
        this.core[0].sizeY = this.in.readShort();
        int bits = this.in.readShort();
        while (bits % 8 != 0) {
            ++bits;
        }
        if (bits % 3 == 0) {
            this.core[0].sizeC = 3;
            bits /= 3;
        }
        this.core[0].pixelType = FormatTools.pixelTypeFromBytes(bits / 8, false, false);
        this.isCompressed = this.in.readShort() != 0;
        this.addGlobalMeta("Is compressed", this.isCompressed);
        if (this.isCompressed) {
            throw new UnsupportedCompressionException("Compressed LIM files not supported.");
        }
        this.core[0].imageCount = 1;
        this.core[0].sizeZ = 1;
        this.core[0].sizeT = 1;
        if (this.getSizeC() == 0) {
            this.core[0].sizeC = 1;
        }
        this.core[0].rgb = this.getSizeC() > 1;
        this.core[0].dimensionOrder = "XYZCT";
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        this.core[0].interleaved = true;
        this.core[0].metadataComplete = true;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        MetadataTools.setDefaultCreationDate(store, id, 0);
    }
}

