/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.ddf;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import loci.poi.ddf.EscherBSERecord;
import loci.poi.ddf.EscherBitmapBlip;
import loci.poi.ddf.EscherBlipRecord;
import loci.poi.ddf.EscherChildAnchorRecord;
import loci.poi.ddf.EscherClientAnchorRecord;
import loci.poi.ddf.EscherClientDataRecord;
import loci.poi.ddf.EscherContainerRecord;
import loci.poi.ddf.EscherDgRecord;
import loci.poi.ddf.EscherDggRecord;
import loci.poi.ddf.EscherMetafileBlip;
import loci.poi.ddf.EscherOptRecord;
import loci.poi.ddf.EscherRecord;
import loci.poi.ddf.EscherRecordFactory;
import loci.poi.ddf.EscherSpRecord;
import loci.poi.ddf.EscherSpgrRecord;
import loci.poi.ddf.EscherSplitMenuColorsRecord;
import loci.poi.ddf.EscherTextboxRecord;
import loci.poi.ddf.UnknownEscherRecord;
import loci.poi.hssf.record.RecordFormatException;

public class DefaultEscherRecordFactory
implements EscherRecordFactory {
    private static Class[] escherRecordClasses = new Class[]{EscherBSERecord.class, EscherOptRecord.class, EscherClientAnchorRecord.class, EscherDgRecord.class, EscherSpgrRecord.class, EscherSpRecord.class, EscherClientDataRecord.class, EscherDggRecord.class, EscherSplitMenuColorsRecord.class, EscherChildAnchorRecord.class, EscherTextboxRecord.class};
    private static Map recordsMap = DefaultEscherRecordFactory.recordsToMap(escherRecordClasses);

    public EscherRecord createRecord(byte[] data, int offset) {
        EscherRecord.EscherRecordHeader header = EscherRecord.EscherRecordHeader.readHeader(data, offset);
        if ((header.getOptions() & 0xF) == 15 && header.getRecordId() != -4083) {
            EscherContainerRecord r = new EscherContainerRecord();
            r.setRecordId(header.getRecordId());
            r.setOptions(header.getOptions());
            return r;
        }
        if (header.getRecordId() >= -4072 && header.getRecordId() <= -3817) {
            EscherBlipRecord r = header.getRecordId() == -4065 || header.getRecordId() == -4067 || header.getRecordId() == -4066 ? new EscherBitmapBlip() : (header.getRecordId() == -4070 || header.getRecordId() == -4069 || header.getRecordId() == -4068 ? new EscherMetafileBlip() : new EscherBlipRecord());
            r.setRecordId(header.getRecordId());
            r.setOptions(header.getOptions());
            return r;
        }
        Constructor recordConstructor = (Constructor)recordsMap.get(new Short(header.getRecordId()));
        EscherRecord escherRecord = null;
        if (recordConstructor != null) {
            try {
                escherRecord = (EscherRecord)recordConstructor.newInstance(new Object[0]);
                escherRecord.setRecordId(header.getRecordId());
                escherRecord.setOptions(header.getOptions());
            }
            catch (Exception e) {
                escherRecord = null;
            }
        }
        return escherRecord == null ? new UnknownEscherRecord() : escherRecord;
    }

    private static Map recordsToMap(Class[] records) {
        HashMap result = new HashMap();
        for (int i = 0; i < records.length; ++i) {
            Constructor constructor;
            Class record = null;
            short sid = 0;
            record = records[i];
            try {
                sid = record.getField("RECORD_ID").getShort(null);
                constructor = record.getConstructor(new Class[0]);
            }
            catch (Exception illegalArgumentException) {
                throw new RecordFormatException("Unable to determine record types");
            }
            result.put(new Short(sid), constructor);
        }
        return result;
    }
}

