/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf4;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class TagEnum {
    private static Map<Short, TagEnum> hash = new HashMap<Short, TagEnum>(100);
    public static final TagEnum NONE = new TagEnum("NONE", "", 0);
    public static final TagEnum NULL = new TagEnum("NULL", "", 1);
    public static final TagEnum LINKED = new TagEnum("LINKED", "linked-block special element", 20);
    public static final TagEnum VERSION = new TagEnum("VERSION", "", 30);
    public static final TagEnum COMPRESSED = new TagEnum("COMPRESSED", "compressed special element", 40);
    public static final TagEnum VLINKED = new TagEnum("VLINKED", "variable-len linked-block header", 50);
    public static final TagEnum VLINKED_DATA = new TagEnum("VLINKED_DATA", "variable-len linked-block data", 51);
    public static final TagEnum CHUNKED = new TagEnum("CHUNKED", "chunked special element header", 60);
    public static final TagEnum CHUNK = new TagEnum("CHUNK", "chunk element", 61);
    public static final TagEnum FID = new TagEnum("FID", "File identifier", 100);
    public static final TagEnum FD = new TagEnum("FD", "File description", 101);
    public static final TagEnum TID = new TagEnum("TID", "Tag identifier", 102);
    public static final TagEnum TD = new TagEnum("TD", "Tag descriptor", 103);
    public static final TagEnum DIL = new TagEnum("DIL", "data identifier label", 104);
    public static final TagEnum DIA = new TagEnum("DIA", "data identifier annotation", 105);
    public static final TagEnum NT = new TagEnum("NT", "number type", 106);
    public static final TagEnum MT = new TagEnum("MT", "machine type", 107);
    public static final TagEnum FREE = new TagEnum("FREE", "free space in the file", 108);
    public static final TagEnum ID8 = new TagEnum("ID8", "8-bit Image dimension", 200);
    public static final TagEnum IP8 = new TagEnum("IP8", "8-bit Image palette", 201);
    public static final TagEnum RI8 = new TagEnum("RI8", "Raster-8 image", 202);
    public static final TagEnum CI8 = new TagEnum("CI8", "RLE compressed 8-bit image", 203);
    public static final TagEnum II8 = new TagEnum("II8", "IMCOMP compressed 8-bit image", 204);
    public static final TagEnum ID = new TagEnum("ID", "Image DimRec", 300);
    public static final TagEnum LUT = new TagEnum("LUT", "Image Palette", 301);
    public static final TagEnum RI = new TagEnum("RI", "Raster Image", 302);
    public static final TagEnum CI = new TagEnum("CI", "Compressed Image", 303);
    public static final TagEnum NRI = new TagEnum("NRI", "New-format Raster Image", 304);
    public static final TagEnum RIG = new TagEnum("RIG", "Raster Image Group", 306);
    public static final TagEnum LD = new TagEnum("LD", "Palette DimRec", 307);
    public static final TagEnum MD = new TagEnum("MD", "Matte DimRec", 308);
    public static final TagEnum MA = new TagEnum("MA", "Matte Data", 309);
    public static final TagEnum CCN = new TagEnum("CCN", "color correction", 310);
    public static final TagEnum CFM = new TagEnum("CFM", "color format", 311);
    public static final TagEnum AR = new TagEnum("AR", "aspect ratio", 312);
    public static final TagEnum DRAW = new TagEnum("DRAW", "Draw these images in sequence", 400);
    public static final TagEnum RUN = new TagEnum("RUN", "run this as a program/script", 401);
    public static final TagEnum XYP = new TagEnum("XYP", "x-y position", 500);
    public static final TagEnum MTO = new TagEnum("MTO", "machine-type override", 501);
    public static final TagEnum T14 = new TagEnum("T14", "TEK 4014 data", 602);
    public static final TagEnum T105 = new TagEnum("T105", "TEK 4105 data", 603);
    public static final TagEnum SDG = new TagEnum("SDG", "Scientific Data Group", 700);
    public static final TagEnum SDD = new TagEnum("SDD", "Scientific Data DimRec", 701);
    public static final TagEnum SD = new TagEnum("SD", "Scientific Data", 702);
    public static final TagEnum SDS = new TagEnum("SDS", "Scales", 703);
    public static final TagEnum SDL = new TagEnum("SDL", "Labels", 704);
    public static final TagEnum SDU = new TagEnum("SDU", "Units", 705);
    public static final TagEnum SDF = new TagEnum("SDF", "Formats", 706);
    public static final TagEnum SDM = new TagEnum("SDM", "Max/Min", 707);
    public static final TagEnum SDC = new TagEnum("SDC", "Coord sys", 708);
    public static final TagEnum SDT = new TagEnum("SDT", "Transpose", 709);
    public static final TagEnum SDLNK = new TagEnum("SDLNK", "Links related to the dataset", 710);
    public static final TagEnum NDG = new TagEnum("NDG", "Numeric Data Group", 720);
    public static final TagEnum CAL = new TagEnum("CAL", "Calibration information", 731);
    public static final TagEnum FV = new TagEnum("FV", "Fill Value information", 732);
    public static final TagEnum BREQ = new TagEnum("BREQ", "Beginning of required tags", 799);
    public static final TagEnum SDRAG = new TagEnum("SDRAG", "List of ragged array line lengths", 781);
    public static final TagEnum EREQ = new TagEnum("EREQ", "Current end of the range", 780);
    public static final TagEnum VG = new TagEnum("VG", "Vgroup", 1965);
    public static final TagEnum VH = new TagEnum("VH", "Vdata Header", 1962);
    public static final TagEnum VS = new TagEnum("VS", "Vdata Storage", 1963);
    public static final TagEnum RLE = new TagEnum("RLE", "run length encoding", 11);
    public static final TagEnum IMC = new TagEnum("IMC", "IMCOMP compression alias", 12);
    public static final TagEnum IMCOMP = new TagEnum("IMCOMP", "IMCOMP compression", 12);
    public static final TagEnum JPEG = new TagEnum("JPEG", "JPEG compression (24-bit data)", 13);
    public static final TagEnum GREYJPEG = new TagEnum("GREYJPEG", "JPEG compression (8-bit data)", 14);
    public static final TagEnum JPEG5 = new TagEnum("JPEG5", "JPEG compression (24-bit data)", 15);
    public static final TagEnum GREYJPEG5 = new TagEnum("GREYJPEG5", "JPEG compression (8-bit data)", 16);
    private String name;
    private String desc;
    private short code;

    private TagEnum(String name, String desc, short code) {
        this.name = name;
        this.desc = desc;
        this.code = code;
        hash.put(code, this);
    }

    public String getDesc() {
        return this.desc;
    }

    public String getName() {
        return this.name;
    }

    public short getCode() {
        return this.code;
    }

    public String toString() {
        return this.name + " (" + this.code + ") " + this.desc;
    }

    public static TagEnum getTag(short code) {
        return hash.get(code);
    }

    public static void main(String[] args) throws IOException {
        String line;
        FileInputStream ios = new FileInputStream("C:/dev/hdf4/HDF4.2r1/hdf/src/htags.h");
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
        while ((line = dataIS.readLine()) != null) {
            String code;
            if (!line.startsWith("#define")) continue;
            StringTokenizer stoker = new StringTokenizer(line, " ()");
            stoker.nextToken();
            String name = stoker.nextToken();
            if (!stoker.hasMoreTokens()) continue;
            if (name.startsWith("DFTAG_")) {
                name = name.substring(6);
            }
            if ((code = stoker.nextToken()).startsWith("u")) {
                code = stoker.nextToken();
            }
            int pos = line.indexOf("/*");
            String desc = "";
            if (pos > 0) {
                int pos2 = line.indexOf("*/");
                desc = pos2 > 0 ? line.substring(pos + 3, pos2) : line.substring(pos + 3);
                desc = desc.trim();
            }
            System.out.println("  public final static Tags " + name + " = new Tags(\"" + name + "\", \"" + desc + "\", (short) " + code + ");");
        }
    }
}

