/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.services;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import loci.common.services.AbstractService;
import loci.formats.services.MDBService;
import mdbtools.jdbc2.File;
import mdbtools.libmdb.Catalog;
import mdbtools.libmdb.Data;
import mdbtools.libmdb.Holder;
import mdbtools.libmdb.MdbCatalogEntry;
import mdbtools.libmdb.MdbColumn;
import mdbtools.libmdb.MdbHandle;
import mdbtools.libmdb.MdbTableDef;
import mdbtools.libmdb.Table;
import mdbtools.libmdb.file;
import mdbtools.libmdb.mem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MDBServiceImpl
extends AbstractService
implements MDBService {
    private MdbHandle mdb;
    private Vector<Holder> boundValues;

    public MDBServiceImpl() {
        this.checkClassDependency(File.class);
        this.checkClassDependency(Catalog.class);
    }

    @Override
    public void initialize(String filename) throws IOException {
        this.boundValues = new Vector();
        mem.mdb_init();
        File dbfile = new File(filename);
        this.mdb = file.mdb_open(dbfile);
        Catalog.mdb_read_catalog(this.mdb, 1);
    }

    @Override
    public Vector<Vector<String[]>> parseDatabase() throws IOException {
        ArrayList catalog = this.mdb.catalog;
        Vector<Vector<String[]>> rtn = new Vector<Vector<String[]>>();
        int previousColumnCount = 0;
        for (Object entry : catalog) {
            int type = ((MdbCatalogEntry)entry).object_type;
            String name = ((MdbCatalogEntry)entry).object_name;
            if (type != 1 || name.startsWith("MSys")) continue;
            Vector<String[]> tableData = new Vector<String[]>();
            MdbTableDef table = Table.mdb_read_table((MdbCatalogEntry)entry);
            Table.mdb_read_columns(table);
            int numCols = table.num_cols;
            for (int i = 0; i < numCols; ++i) {
                Holder h = new Holder();
                Data.mdb_bind_column(table, i + 1, h);
                this.boundValues.add(h);
            }
            String[] columnNames = new String[numCols + 1];
            columnNames[0] = name;
            for (int i = 0; i < numCols; ++i) {
                columnNames[i + 1] = ((MdbColumn)table.columns.get((int)i)).name;
            }
            tableData.add(columnNames);
            while (this.fetchRow(table)) {
                String[] row = new String[numCols];
                for (int i = 0; i < numCols; ++i) {
                    Holder h = this.boundValues.get(i + previousColumnCount);
                    row[i] = h.s;
                }
                tableData.add(row);
            }
            previousColumnCount += numCols;
            rtn.add(tableData);
        }
        return rtn;
    }

    @Override
    public void close() {
        this.mdb = null;
        this.boundValues = null;
    }

    private boolean fetchRow(MdbTableDef table) {
        try {
            return Data.mdb_fetch_row(table);
        }
        catch (Exception e) {
            return false;
        }
    }
}

