/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grib;

import java.io.IOException;
import java.util.ArrayList;
import ucar.grib.Index;
import ucar.grib.NoValidGribException;
import ucar.grib.NotSupportedException;
import ucar.grib.TableLookup;
import ucar.grib.grib1.Grib1Data;
import ucar.grib.grib1.Grib1Input;
import ucar.grib.grib1.Grib1Lookup;
import ucar.grib.grib1.Grib1Product;
import ucar.nc2.iosp.grib.GribServiceProvider;
import ucar.nc2.iosp.grib.Index2NC;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class Grib1ServiceProvider
extends GribServiceProvider {
    private Grib1Data dataReader;

    public boolean isValidFile(RandomAccessFile raf) {
        try {
            raf.seek(0L);
            raf.order(0);
            Grib1Input scanner = new Grib1Input(raf);
            int edition = scanner.getEdition();
            return edition == 1;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected void open(Index index, CancelTask cancelTask) throws IOException {
        long startTime = System.currentTimeMillis();
        if (GribServiceProvider.debugOpen) {
            System.out.println("GribServiceProvider open = " + this.ncfile.getLocation());
        }
        Grib1Product firstProduct = null;
        try {
            Grib1Input scanner = new Grib1Input(this.raf);
            long start2 = System.currentTimeMillis();
            this.raf.seek(0L);
            scanner.scan(true, true);
            ArrayList products = scanner.getProducts();
            if (products.size() == 0) {
                throw new IOException("no valid products were found");
            }
            firstProduct = (Grib1Product)products.get(0);
            if (debugTiming) {
                long took = System.currentTimeMillis() - start2;
                System.out.println("  read one record took=" + took + " msec ");
            }
        }
        catch (NoValidGribException noGrib) {
            System.err.println("NoValidGribException : " + (Object)((Object)noGrib));
        }
        catch (NotSupportedException noSupport) {
            System.err.println("NotSupportedException : " + (Object)((Object)noSupport));
        }
        Grib1Lookup lookup = new Grib1Lookup(firstProduct);
        Index2NC delegate = new Index2NC();
        delegate.open(index, (TableLookup)lookup, 1, this.ncfile, this.fmrcCoordSys, cancelTask);
        this.ncfile.finish();
        this.dataReader = new Grib1Data(this.raf);
        if (debugTiming) {
            long took = System.currentTimeMillis() - startTime;
            System.out.println(" open " + this.ncfile.getLocation() + " took=" + took + " msec ");
        }
    }

    protected float[] _readData(long dataOffset1, long dataOffset2, int decimalScale, boolean bmsExists) throws IOException {
        try {
            return this.dataReader.getData(dataOffset1, decimalScale, bmsExists);
        }
        catch (NotSupportedException e) {
            throw new IOException(e.getMessage());
        }
    }
}

