/*
 * Decompiled with CFR 0.152.
 */
package thredds.wcs.v1_0_0_Plus;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.wcs.v1_0_0_Plus.WcsRequest;
import ucar.nc2.dt.GridDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeCoverage
extends WcsRequest {
    private static Logger log = LoggerFactory.getLogger(DescribeCoverage.class);
    protected static final Namespace wcsNS = Namespace.getNamespace((String)"http://www.opengis.net/wcs");
    protected static final Namespace gmlNS = Namespace.getNamespace((String)"gml", (String)"http://www.opengis.net/gml");
    protected static final Namespace xlinkNS = Namespace.getNamespace((String)"xlink", (String)"http://www.w3.org/1999/xlink");
    private URI serverURI;
    private List<String> coverages;
    private Document describeCoverageDoc;

    public DescribeCoverage(WcsRequest.Operation operation, String version, String datasetPath, GridDataset dataset, URI serverURI, List<String> coverages) {
        super(operation, version, datasetPath, dataset);
        this.serverURI = serverURI;
        this.coverages = coverages;
        if (this.serverURI == null) {
            throw new IllegalArgumentException("Non-null server URI required.");
        }
        if (this.coverages == null) {
            throw new IllegalArgumentException("Non-null coverage list required.");
        }
        if (this.coverages.size() < 1) {
            throw new IllegalArgumentException("Coverage list must contain at least one ID <" + this.coverages.size() + ">.");
        }
    }

    public Document getDescribeCoverageDoc() {
        if (this.describeCoverageDoc == null) {
            this.describeCoverageDoc = this.generateDescribeCoverageDoc();
        }
        return this.describeCoverageDoc;
    }

    public void writeDescribeCoverageDoc(PrintWriter pw) throws IOException {
        XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
        xmlOutputter.output(this.getDescribeCoverageDoc(), (Writer)pw);
    }

    public Document generateDescribeCoverageDoc() {
        Element coverageDescriptionsElem = new Element("CoverageDescriptions", wcsNS);
        coverageDescriptionsElem.addNamespaceDeclaration(gmlNS);
        coverageDescriptionsElem.addNamespaceDeclaration(xlinkNS);
        for (String curCoverageId : this.coverages) {
            coverageDescriptionsElem.addContent((Content)this.genCovDescrip(curCoverageId));
        }
        return new Document(coverageDescriptionsElem);
    }

    public Element genCovDescrip(String covId) {
        Element covDescripElem = new Element("CoverageDescription", wcsNS);
        covDescripElem.addContent((Content)new Element("Identifier", wcsNS).addContent(covId));
        return covDescripElem;
    }
}

