/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.AxisType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml4.NcMLReader;
import ucar.nc2.util.CancelTask;

public class NsslRadarMosaicConvention
extends CoordSysBuilder {
    public static boolean isMine(NetcdfFile ncfile) {
        String s = ncfile.findAttValueIgnoreCase(null, "DataType", null);
        if (s == null || !s.equalsIgnoreCase("LatLonGrid") && !s.equalsIgnoreCase("LatLonHeightGrid")) {
            return false;
        }
        return null != ncfile.findGlobalAttribute("Latitude") && null != ncfile.findGlobalAttribute("Longitude") && null != ncfile.findGlobalAttribute("LatGridSpacing") && null != ncfile.findGlobalAttribute("LonGridSpacing") && null != ncfile.findGlobalAttribute("Time");
    }

    public NsslRadarMosaicConvention() {
        this.conventionName = "NSSL National Reflectivity Mosaic";
    }

    public void augmentDataset(NetcdfDataset ds, CancelTask cancelTask) throws IOException {
        if (null != ds.findVariable("Lat")) {
            return;
        }
        String s = ds.findAttValueIgnoreCase(null, "DataType", null);
        if (s.equalsIgnoreCase("LatLonGrid")) {
            this.augment2D(ds, cancelTask);
        } else {
            this.augment3D(ds, cancelTask);
        }
    }

    private void augment3D(NetcdfDataset ds, CancelTask cancelTask) throws IOException {
        NcMLReader.wrapNcMLresource(ds, "resources/nj22/coords/NsslRadarMosaic3D.ncml", cancelTask);
        this.addCoordSystem(ds);
        Variable var = ds.findVariable("mrefl_mosaic");
        assert (var != null);
        float scale_factor = Float.NaN;
        Attribute att = var.findAttributeIgnoreCase("Scale");
        if (att != null) {
            scale_factor = att.getNumericValue().floatValue();
            var.addAttribute(new Attribute("scale_factor", Float.valueOf(1.0f / scale_factor)));
        }
        if (null != (att = ds.findGlobalAttributeIgnoreCase("MissingData"))) {
            float val = att.getNumericValue().floatValue();
            if (!Float.isNaN(scale_factor)) {
                val *= scale_factor;
            }
            var.addAttribute(new Attribute("missing_value", (short)val));
        }
        Array missingData = Array.factory(DataType.SHORT.getClassType(), new int[]{2}, (Object)new short[]{-990, -9990});
        var.addAttribute(new Attribute("missing_value", missingData));
        var.addAttribute(new Attribute("_CoordinateAxes", "Height Lat Lon"));
    }

    private void augment2D(NetcdfDataset ds, CancelTask cancelTask) throws IOException {
        NcMLReader.wrapNcMLresource(ds, "resources/nj22/coords/NsslRadarMosaic.ncml", cancelTask);
        this.addCoordSystem(ds);
        for (Variable var : ds.getVariables()) {
            float scale_factor = Float.NaN;
            Attribute att = var.findAttributeIgnoreCase("Scale");
            if (att != null) {
                scale_factor = att.getNumericValue().floatValue();
                var.addAttribute(new Attribute("scale_factor", Float.valueOf(1.0f / scale_factor)));
            }
            if (null == (att = var.findAttributeIgnoreCase("MissingData"))) continue;
            float val = att.getNumericValue().floatValue();
            if (!Float.isNaN(scale_factor)) {
                val *= scale_factor;
            }
            var.addAttribute(new Attribute("missing_value", (short)val));
        }
        ds.finish();
    }

    private void addCoordSystem(NetcdfDataset ds) throws IOException {
        double lat = ds.findGlobalAttributeIgnoreCase("Latitude").getNumericValue().doubleValue();
        double lon = ds.findGlobalAttributeIgnoreCase("Longitude").getNumericValue().doubleValue();
        double dlat = ds.findGlobalAttributeIgnoreCase("LatGridSpacing").getNumericValue().doubleValue();
        double dlon = ds.findGlobalAttributeIgnoreCase("LonGridSpacing").getNumericValue().doubleValue();
        int time = ds.findGlobalAttributeIgnoreCase("Time").getNumericValue().intValue();
        if (this.debug) {
            System.out.println(ds.getLocation() + " Lat/Lon=" + lat + "/" + lon);
        }
        int nlat = ds.findDimension("Lat").getLength();
        int nlon = ds.findDimension("Lon").getLength();
        CoordinateAxis1D v = new CoordinateAxis1D(ds, null, "Lat", DataType.FLOAT, "Lat", "degrees_north", "latitude coordinate");
        ds.setValues(v, nlat, lat, -dlat);
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
        ds.addVariable(null, v);
        v = new CoordinateAxis1D(ds, null, "Lon", DataType.FLOAT, "Lon", "degrees_east", "longitude coordinate");
        ds.setValues(v, nlon, lon, dlon);
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
        ds.addVariable(null, v);
        ds.addDimension(null, new Dimension("Time", 1));
        v = new CoordinateAxis1D(ds, null, "Time", DataType.INT, "Time", "seconds since 1970-1-1 00:00:00", "time coordinate");
        ds.setValues(v, 1, time, 1.0);
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
        ds.addVariable(null, v);
    }
}

