/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ucar.nc2.dt.EarthLocationImpl;
import ucar.nc2.dt.Station;
import ucar.nc2.dt.StationObsDatatype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StationImpl
extends EarthLocationImpl
implements Station,
Comparable {
    protected String name;
    protected String desc;
    protected String wmoId;
    protected List<StationObsDatatype> obsList;
    protected int count = -1;

    public StationImpl() {
    }

    public StationImpl(String name, String desc, double lat, double lon, double alt) {
        super(lat, lon, alt);
        this.name = name;
        this.desc = desc;
    }

    public StationImpl(String name, String desc, double lat, double lon, double alt, int count) {
        this(name, desc, lat, lon, alt);
        this.count = count;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public String getWmoId() {
        return this.wmoId;
    }

    public int getNumObservations() {
        return this.obsList == null ? this.count : this.obsList.size();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String desc) {
        this.desc = desc;
    }

    public void setWmoId(String wmoId) {
        this.wmoId = wmoId;
    }

    public void incrCount() {
        ++this.count;
    }

    public List getObservations() throws IOException {
        if (this.obsList == null) {
            this.obsList = this.readObservations();
        }
        return this.obsList;
    }

    public void addObs(StationObsDatatype sobs) {
        if (null == this.obsList) {
            this.obsList = new ArrayList<StationObsDatatype>();
        }
        this.obsList.add(sobs);
    }

    protected List<StationObsDatatype> readObservations() throws IOException {
        return null;
    }

    public int compareTo(Object o) {
        StationImpl so = (StationImpl)o;
        return this.name.compareTo(so.getName());
    }

    @Override
    public String toString() {
        return "name=" + this.name + " desc=" + this.desc + " " + super.toString();
    }
}

