/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml4;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.ncml4.MyCrawlableDataset;
import ucar.nc2.ncml4.Scanner;
import ucar.nc2.units.TimeUnit;
import ucar.nc2.util.CancelTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetCollectionManager {
    protected static Logger logger = LoggerFactory.getLogger(DatasetCollectionManager.class);
    private List<Scanner> scanList = new ArrayList<Scanner>();
    private Map<String, MyCrawlableDataset> map;
    private TimeUnit recheck;
    private long lastScanned;
    private boolean debugSync = false;
    private boolean debugSyncDetail = false;

    public DatasetCollectionManager(String recheckS) {
        if (recheckS != null) {
            try {
                this.recheck = new TimeUnit(recheckS);
            }
            catch (Exception e) {
                logger.error("Invalid time unit for recheckEvery = {}", (Object)recheckS);
            }
        }
    }

    public void addDirectoryScan(Scanner scan) {
        this.scanList.add(scan);
    }

    public void scan(CancelTask cancelTask) throws IOException {
        HashMap<String, MyCrawlableDataset> newMap = new HashMap<String, MyCrawlableDataset>();
        this.scan(newMap, cancelTask);
        this.map = newMap;
        this.lastScanned = System.currentTimeMillis();
    }

    public boolean timeToRescan() {
        if (this.scanList.isEmpty()) {
            if (this.debugSyncDetail) {
                System.out.println(" *Sync not needed, no scanners");
            }
            return false;
        }
        if (this.recheck == null) {
            if (this.debugSyncDetail) {
                System.out.println(" *Sync not needed, recheck is null");
            }
            return false;
        }
        Date now = new Date();
        Date lastCheckedDate = new Date(this.lastScanned);
        Date need = this.recheck.add(lastCheckedDate);
        if (now.before(need)) {
            if (this.debugSync) {
                System.out.println(" *Sync not needed, last= " + lastCheckedDate + " now = " + now);
            }
            return false;
        }
        return true;
    }

    public boolean rescan() throws IOException {
        String path;
        if (this.debugSync) {
            System.out.println(" *Sync at " + new Date());
        }
        this.lastScanned = System.currentTimeMillis();
        HashMap<String, MyCrawlableDataset> newMap = new HashMap<String, MyCrawlableDataset>();
        this.scan(newMap, null);
        boolean changed = false;
        for (MyCrawlableDataset newDataset : newMap.values()) {
            path = newDataset.file.getPath();
            MyCrawlableDataset oldDataset = this.map.get(path);
            if (oldDataset != null) {
                newMap.put(path, oldDataset);
                if (!this.debugSyncDetail) continue;
                System.out.println("  sync using old Dataset= " + path);
                continue;
            }
            changed = true;
            if (!this.debugSyncDetail) continue;
            System.out.println("  sync found new Dataset= " + path);
        }
        if (!changed) {
            for (MyCrawlableDataset oldDataset : this.map.values()) {
                path = oldDataset.file.getPath();
                MyCrawlableDataset newDataset = (MyCrawlableDataset)newMap.get(path);
                if (newDataset != null) continue;
                changed = true;
                if (!this.debugSyncDetail) break;
                System.out.println("  sync found deleted Dataset= " + path);
                break;
            }
        }
        if (changed) {
            this.map = newMap;
        }
        return changed;
    }

    public TimeUnit getRecheck() {
        return this.recheck;
    }

    public long getLastScanned() {
        return this.lastScanned;
    }

    public Collection<MyCrawlableDataset> getFiles() {
        return this.map.values();
    }

    private void scan(Map<String, MyCrawlableDataset> map, CancelTask cancelTask) throws IOException {
        for (Scanner scanner : this.scanList) {
            scanner.scanDirectory(map, cancelTask);
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
    }
}

