/*
 * Decompiled with CFR 0.152.
 */
package ucar.units;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import ucar.units.NameException;
import ucar.units.NoSuchUnitException;
import ucar.units.Unit;
import ucar.units.UnitDB;
import ucar.units.UnitExistsException;
import ucar.units.UnitID;

public class UnitDBImpl
implements UnitDB,
Serializable {
    private final Set unitSet = new TreeSet(new Comparator(){

        public int compare(Object obj1, Object obj2) {
            return ((Unit)obj1).getName().compareTo(((Unit)obj2).getName());
        }
    });
    private final Map nameMap;
    private final Map symbolMap;

    protected UnitDBImpl(int nameCount, int symbolCount) {
        this.nameMap = new Hashtable(nameCount + 1);
        this.symbolMap = new Hashtable(symbolCount + 1);
    }

    public void add(UnitDBImpl that) throws UnitExistsException {
        this.unitSet.addAll(that.unitSet);
        this.nameMap.putAll(that.nameMap);
        this.symbolMap.putAll(that.symbolMap);
    }

    public int nameCount() {
        return this.nameMap.size();
    }

    public int symbolCount() {
        return this.symbolMap.size();
    }

    public void addUnit(Unit unit) throws UnitExistsException, NameException {
        if (unit.getName() == null) {
            throw new NameException("Unit name can't be null");
        }
        this.addByName(unit.getName(), unit);
        this.addByName(unit.getPlural(), unit);
        this.addBySymbol(unit.getSymbol(), unit);
        this.unitSet.add(unit);
    }

    public final void addAlias(String alias, String name) throws NoSuchUnitException, UnitExistsException {
        this.addAlias(alias, name, null);
    }

    public final void addAlias(String alias, String name, String symbol) throws NoSuchUnitException, UnitExistsException {
        this.addAlias(alias, name, symbol, null);
    }

    public final void addSymbol(String symbol, String name) throws NoSuchUnitException, UnitExistsException {
        this.addAlias(null, name, symbol, null);
    }

    public final void addAlias(String alias, String name, String symbol, String plural) throws NoSuchUnitException, UnitExistsException {
        this.addAlias(UnitID.newUnitID(alias, plural, symbol), name);
    }

    public final void addAlias(UnitID alias, String name) throws NoSuchUnitException, UnitExistsException {
        Unit unit = this.getByName(name);
        if (unit == null) {
            throw new NoSuchUnitException(name);
        }
        this.addByName(alias.getName(), unit);
        this.addByName(alias.getPlural(), unit);
        this.addBySymbol(alias.getSymbol(), unit);
    }

    public Unit get(String id) {
        Unit unit = this.getBySymbol(id);
        if (unit == null) {
            unit = this.getByName(id);
        }
        return unit;
    }

    public Unit getByName(String name) {
        return (Unit)this.nameMap.get(UnitDBImpl.canonicalize(name));
    }

    private static String canonicalize(String name) {
        return name.toLowerCase().replace(' ', '_');
    }

    public Unit getBySymbol(String symbol) {
        return (Unit)this.symbolMap.get(symbol);
    }

    public String toString() {
        return this.unitSet.toString();
    }

    public final Iterator getIterator() {
        return this.unitSet.iterator();
    }

    private final void addByName(String name, Unit newUnit) throws UnitExistsException {
        if (name != null) {
            UnitDBImpl.addUnique(this.nameMap, UnitDBImpl.canonicalize(name), newUnit);
        }
    }

    private final void addBySymbol(String symbol, Unit newUnit) throws UnitExistsException {
        if (symbol != null) {
            UnitDBImpl.addUnique(this.symbolMap, symbol, newUnit);
        }
    }

    private static final void addUnique(Map map, String key, Unit newUnit) throws UnitExistsException {
        Unit oldUnit = map.put(key, newUnit);
        if (oldUnit != null && !((Object)oldUnit).equals(newUnit)) {
            throw new UnitExistsException(oldUnit, newUnit);
        }
    }
}

