/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import loci.common.ReflectException;
import loci.common.ReflectedUniverse;

public final class DebugTools {
    private DebugTools() {
    }

    public static String getStackTrace(Throwable t) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            t.printStackTrace(new PrintStream((OutputStream)out, false, "UTF-8"));
            return new String(out.toByteArray(), "UTF-8");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static synchronized boolean enableLogging(String level) {
        String[][] toolClasses;
        for (String[] toolClass : toolClasses = new String[][]{{"loci.common.", "LogbackTools"}, {"loci.common.", "Log4jTools"}}) {
            try {
                Class<?> k = Class.forName(toolClass[0] + toolClass[1]);
                Method m = k.getMethod("enableLogging", String.class);
                m.invoke(null, level);
                return true;
            }
            catch (Throwable t) {
            }
        }
        return false;
    }

    public static synchronized boolean enableIJLogging(boolean debug) {
        ReflectedUniverse r = new ReflectedUniverse();
        try {
            r.exec("import loci.common.LogbackTools");
            r.exec("import loci.plugins.util.IJStatusEchoer");
            r.exec("appender = new IJStatusEchoer()");
            r.setVar("debug", debug);
            r.exec("LogbackTools.enableIJLogging(debug, appender)");
        }
        catch (ReflectException exc) {
            return false;
        }
        return true;
    }

    public static String getFieldName(Class<?> c, int value) {
        Field[] fields = c.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!Modifier.isStatic(fields[i].getModifiers())) continue;
            fields[i].setAccessible(true);
            try {
                if (fields[i].getInt(null) != value) continue;
                return fields[i].getName();
            }
            catch (IllegalAccessException exc) {
                continue;
            }
            catch (IllegalArgumentException exc) {
                // empty catch block
            }
        }
        return "" + value;
    }
}

