/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

public class Modulo {
    public String parentDimension;
    public double start = 0.0;
    public double step = 1.0;
    public double end = 0.0;
    public String parentType;
    public String type;
    public String typeDescription;
    public String unit;
    public String[] labels;

    public Modulo(String dimension) {
        this.parentDimension = dimension;
    }

    public int length() {
        if (this.labels != null) {
            return this.labels.length;
        }
        return (int)Math.rint((this.end - this.start) / this.step) + 1;
    }

    public String toXMLAnnotation() {
        StringBuffer xml = new StringBuffer("<ModuloAlong");
        xml.append(this.parentDimension);
        xml.append(" Type=\"");
        if (this.type != null) {
            this.type = this.type.toLowerCase();
        }
        if (!(this.type != null && (this.type.equals("angle") || this.type.equals("phase") || this.type.equals("tile") || this.type.equals("lifetime") || this.type.equals("lambda")))) {
            if (this.typeDescription == null) {
                this.typeDescription = this.type;
            }
            this.type = "other";
        }
        xml.append(this.type);
        xml.append("\"");
        if (this.typeDescription != null) {
            xml.append(" TypeDescription=\"");
            xml.append(this.typeDescription);
            xml.append("\"");
        }
        if (this.unit != null) {
            xml.append(" Unit=\"");
            xml.append(this.unit);
            xml.append("\"");
        }
        if (this.end > this.start) {
            xml.append(" Start=\"");
            xml.append(this.start);
            xml.append("\" Step=\"");
            xml.append(this.step);
            xml.append("\" End=\"");
            xml.append(this.end);
            xml.append("\"");
        }
        if (this.labels != null) {
            xml.append(">");
            for (String label : this.labels) {
                xml.append("\n<Label>");
                xml.append(label);
                xml.append("</Label>");
            }
            xml.append("\n</ModuloAlong");
            xml.append(this.parentDimension);
            xml.append(">");
        } else {
            xml.append("/>");
        }
        return xml.toString();
    }
}

