/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.MetadataTools;
import loci.formats.UnsupportedCompressionException;
import loci.formats.codec.BitBuffer;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.PositiveFloat;

public class BMPReader
extends FormatReader {
    public static final String BMP_MAGIC_STRING = "BM";
    private static final int RAW = 0;
    private static final int RLE_8 = 1;
    private static final int RLE_4 = 2;
    private static final int RGB_MASK = 3;
    private int bpp;
    private byte[][] palette;
    private int compression;
    private long global;
    private boolean invertY = false;

    public BMPReader() {
        super("Windows Bitmap", "bmp");
        this.domains = new String[]{"Graphics"};
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 2;
        if (!FormatTools.validStream(stream, 2, false)) {
            return false;
        }
        return stream.readString(2).startsWith(BMP_MAGIC_STRING);
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return this.palette;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (this.compression != 0 && this.in.length() < (long)FormatTools.getPlaneSize(this)) {
            throw new UnsupportedCompressionException(this.compression + " not supported");
        }
        int rowsToSkip = this.invertY ? y : this.getSizeY() - (h + y);
        int rowLength = this.getSizeX() * (this.isIndexed() ? 1 : this.getSizeC());
        this.in.seek(this.global + (long)(rowsToSkip * rowLength));
        int pad = rowLength * this.bpp / 8 % 2;
        pad = pad == 0 ? rowLength * this.bpp / 8 % 4 : (pad *= this.getSizeC());
        int planeSize = this.getSizeX() * this.getSizeC() * h;
        planeSize = this.bpp >= 8 ? (planeSize *= this.bpp / 8) : (planeSize /= 8 / this.bpp);
        if ((long)(planeSize += pad * h) + this.in.getFilePointer() > this.in.length()) {
            if ((long)((planeSize -= pad * h) + this.getSizeY()) + this.in.getFilePointer() <= this.in.length()) {
                pad = 1;
                planeSize += h;
            } else {
                pad = 0;
            }
        }
        this.in.skipBytes(rowsToSkip * pad);
        byte[] rawPlane = new byte[planeSize];
        this.in.read(rawPlane);
        BitBuffer bb = new BitBuffer(rawPlane);
        int effectiveC = this.palette != null && this.palette[0].length > 0 ? 1 : this.getSizeC();
        for (int row = h - 1; row >= 0; --row) {
            int rowIndex = this.invertY ? h - 1 - row : row;
            bb.skipBits(x * this.bpp * effectiveC);
            for (int i = 0; i < w * effectiveC; ++i) {
                if (this.bpp <= 8) {
                    buf[rowIndex * w * effectiveC + i] = (byte)(bb.getBits(this.bpp) & 0xFF);
                    continue;
                }
                for (int b = 0; b < this.bpp / 8; ++b) {
                    buf[this.bpp / 8 * (rowIndex * w * effectiveC + i) + b] = (byte)(bb.getBits(8) & 0xFF);
                }
            }
            if (row <= 0) continue;
            bb.skipBits((this.getSizeX() - w - x) * this.bpp * effectiveC + pad * 8);
        }
        if (this.getRGBChannelCount() > 1) {
            ImageTools.bgrToRgb(buf, this.isInterleaved(), 1, this.getRGBChannelCount());
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.compression = 0;
            this.bpp = 0;
            this.global = 0L;
            this.palette = null;
            this.invertY = false;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        LOGGER.info("Reading bitmap header");
        this.in.order(true);
        this.addGlobalMeta("Magic identifier", this.in.readString(2));
        this.addGlobalMeta("File size (in bytes)", this.in.readInt());
        this.in.skipBytes(4);
        this.global = this.in.readInt();
        this.in.skipBytes(4);
        m.sizeX = this.in.readInt();
        m.sizeY = this.in.readInt();
        if (this.getSizeX() < 1) {
            LOGGER.trace("Invalid width: {}; using the absolute value", (Object)this.getSizeX());
            m.sizeX = Math.abs(this.getSizeX());
        }
        if (this.getSizeY() < 1) {
            LOGGER.trace("Invalid height: {}; using the absolute value", (Object)this.getSizeY());
            m.sizeY = Math.abs(this.getSizeY());
            this.invertY = true;
        }
        this.addGlobalMeta("Color planes", this.in.readShort());
        this.bpp = this.in.readShort();
        this.compression = this.in.readInt();
        this.in.skipBytes(4);
        int pixelSizeX = this.in.readInt();
        int pixelSizeY = this.in.readInt();
        int nColors = this.in.readInt();
        if (nColors == 0 && this.bpp != 32 && this.bpp != 24) {
            nColors = this.bpp < 8 ? 1 << this.bpp : 256;
        }
        this.in.skipBytes(4);
        if (nColors != 0 && this.bpp == 8) {
            this.palette = new byte[3][256];
            for (int i = 0; i < nColors; ++i) {
                for (int j = this.palette.length - 1; j >= 0; --j) {
                    this.palette[j][i] = this.in.readByte();
                }
                this.in.skipBytes(1);
            }
        } else if (nColors != 0) {
            this.in.skipBytes(nColors * 4);
        }
        LOGGER.info("Populating metadata");
        int n = m.sizeC = this.bpp != 24 ? 1 : 3;
        if (this.bpp == 32) {
            m.sizeC = 4;
        }
        if (this.bpp > 8) {
            this.bpp /= this.getSizeC();
        }
        switch (this.bpp) {
            case 16: {
                m.pixelType = 3;
                break;
            }
            case 32: {
                m.pixelType = 5;
                break;
            }
            default: {
                m.pixelType = 1;
            }
        }
        m.rgb = this.getSizeC() > 1;
        m.littleEndian = true;
        m.interleaved = true;
        m.imageCount = 1;
        m.sizeZ = 1;
        m.sizeT = 1;
        m.dimensionOrder = "XYCTZ";
        m.metadataComplete = true;
        boolean bl = m.indexed = this.palette != null;
        if (this.isIndexed()) {
            m.sizeC = 1;
            m.rgb = false;
        }
        m.falseColor = false;
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            this.addGlobalMeta("Indexed color", this.palette != null);
            this.addGlobalMeta("Image width", this.getSizeX());
            this.addGlobalMeta("Image height", this.getSizeY());
            this.addGlobalMeta("Bits per pixel", this.bpp);
            String comp = "invalid";
            switch (this.compression) {
                case 0: {
                    comp = "None";
                    break;
                }
                case 1: {
                    comp = "8 bit run length encoding";
                    break;
                }
                case 2: {
                    comp = "4 bit run length encoding";
                    break;
                }
                case 3: {
                    comp = "RGB bitmap with mask";
                }
            }
            this.addGlobalMeta("Compression type", comp);
            this.addGlobalMeta("X resolution", pixelSizeX);
            this.addGlobalMeta("Y resolution", pixelSizeY);
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            double correctedX = pixelSizeX == 0 ? 0.0 : 1000000.0 / (double)pixelSizeX;
            double correctedY = pixelSizeY == 0 ? 0.0 : 1000000.0 / (double)pixelSizeY;
            PositiveFloat sizeX = FormatTools.getPhysicalSizeX(correctedX);
            PositiveFloat sizeY = FormatTools.getPhysicalSizeY(correctedY);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
        }
    }
}

