/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.Timestamp;

public class BrukerReader
extends FormatReader {
    private static final String DATE_FORMAT = "HH:mm:ss  d MMM yyyy";
    private ArrayList<String> pixelsFiles = new ArrayList();
    private ArrayList<String> allFiles = new ArrayList();

    public BrukerReader() {
        super("Bruker", "");
        this.suffixSufficient = false;
        this.domains = new String[]{"Medical Imaging"};
        this.hasCompanionFiles = true;
        this.datasetDescription = "One 'fid' and one 'acqp' plus several other metadata files and a 'pdata' directory";
    }

    @Override
    public int getRequiredDirectories(String[] files) throws FormatException, IOException {
        return 1;
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        Location file2 = new Location(name).getAbsoluteFile();
        return file2.getName().equals("fid") || file2.getName().equals("acqp");
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return false;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        RandomAccessInputStream s = new RandomAccessInputStream(this.pixelsFiles.get(this.getSeries()));
        s.seek(no * FormatTools.getPlaneSize(this));
        this.readPlane(s, x, y, w, h, buf);
        s.close();
        return buf;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        String dir = this.pixelsFiles.get(this.getSeries());
        Location realDir = new Location(dir).getParentFile();
        realDir = realDir.getParentFile();
        realDir = realDir.getParentFile();
        dir = realDir.getAbsolutePath();
        ArrayList<String> files = new ArrayList<String>();
        for (String f : this.allFiles) {
            if (!f.startsWith(dir) || f.endsWith("2dseq") && noPixels) continue;
            files.add(f);
        }
        return files.toArray(new String[files.size()]);
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelsFiles.clear();
            this.allFiles.clear();
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        Location originalFile = new Location(id).getAbsoluteFile();
        Location parent = originalFile.getParentFile().getParentFile();
        String[] acquisitionDirs = parent.list(true);
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                Integer i1 = 0;
                try {
                    i1 = new Integer(s1);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                Integer i2 = 0;
                try {
                    i2 = new Integer(s2);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                return i1.compareTo(i2);
            }
        };
        Arrays.sort(acquisitionDirs, comparator);
        ArrayList<String> acqpFiles = new ArrayList<String>();
        ArrayList<String> recoFiles = new ArrayList<String>();
        for (String f : acquisitionDirs) {
            String[] files;
            Location dir = new Location(parent, f);
            if (!dir.isDirectory()) continue;
            for (String file2 : files = dir.list(true)) {
                String[] moreFiles;
                Location child = new Location(dir, file2);
                if (!child.isDirectory()) {
                    this.allFiles.add(child.getAbsolutePath());
                    if (!file2.equals("acqp")) continue;
                    acqpFiles.add(child.getAbsolutePath());
                    continue;
                }
                Location grandchild = new Location(child, "1");
                if (!grandchild.exists()) continue;
                for (String m : moreFiles = grandchild.list(true)) {
                    Location ggc = new Location(grandchild, m);
                    if (ggc.isDirectory()) continue;
                    this.allFiles.add(ggc.getAbsolutePath());
                    if (m.equals("2dseq")) {
                        this.pixelsFiles.add(ggc.getAbsolutePath());
                        continue;
                    }
                    if (!m.equals("reco")) continue;
                    recoFiles.add(ggc.getAbsolutePath());
                }
            }
            if (acqpFiles.size() > this.pixelsFiles.size()) {
                acqpFiles.remove(acqpFiles.size() - 1);
            }
            if (recoFiles.size() <= this.pixelsFiles.size()) continue;
            recoFiles.remove(recoFiles.size() - 1);
        }
        String[] imageNames = new String[this.pixelsFiles.size()];
        String[] timestamps = new String[this.pixelsFiles.size()];
        String[] institutions = new String[this.pixelsFiles.size()];
        String[] users = new String[this.pixelsFiles.size()];
        this.core.clear();
        for (int series = 0; series < this.pixelsFiles.size(); ++series) {
            int zs;
            CoreMetadata ms = new CoreMetadata();
            this.core.add(ms);
            this.setSeries(series);
            String acqData = DataTools.readFile((String)acqpFiles.get(series));
            String[] lines = acqData.split("\n");
            String[] sizes = null;
            String[] ordering = null;
            int ni = 0;
            int nr = 0;
            int ns = 0;
            int bits = 0;
            boolean signed = false;
            boolean isFloat = false;
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                int index = line.indexOf("=");
                if (index < 0) continue;
                String key = line.substring(0, index);
                String value = line.substring(index + 1);
                if (value.startsWith("(") && (value = lines[i + 1].trim()).startsWith("<")) {
                    value = value.substring(1, value.length() - 1);
                }
                if (key.length() < 4) continue;
                this.addSeriesMeta(key.substring(3), value);
                if (key.equals("##$NI")) {
                    ni = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("##$NR")) {
                    nr = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("##$ACQ_word_size")) {
                    bits = Integer.parseInt(value.substring(1, value.lastIndexOf("_")));
                    continue;
                }
                if (key.equals("##$BYTORDA")) {
                    ms.littleEndian = value.toLowerCase().equals("little");
                    continue;
                }
                if (key.equals("##$ACQ_size")) {
                    sizes = value.split(" ");
                    continue;
                }
                if (key.equals("##$ACQ_obj_order")) {
                    ordering = value.split(" ");
                    continue;
                }
                if (key.equals("##$ACQ_time")) {
                    timestamps[series] = value;
                    continue;
                }
                if (key.equals("##$ACQ_institution")) {
                    institutions[series] = value;
                    continue;
                }
                if (key.equals("##$ACQ_operator")) {
                    users[series] = value;
                    continue;
                }
                if (key.equals("##$ACQ_scan_name")) {
                    imageNames[series] = value;
                    continue;
                }
                if (!key.equals("##$ACQ_ns_list_size")) continue;
                ns = Integer.parseInt(value);
            }
            String recoData = DataTools.readFile((String)recoFiles.get(series));
            lines = recoData.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                int index = line.indexOf("=");
                if (index < 0) continue;
                String key = line.substring(0, index);
                String value = line.substring(index + 1);
                if (value.startsWith("(") && (value = lines[i + 1].trim()).startsWith("<")) {
                    value = value.substring(1, value.length() - 1);
                }
                if (key.length() < 4) continue;
                this.addSeriesMeta(key.substring(3), value);
                if (key.equals("##$RECO_size")) {
                    sizes = value.split(" ");
                    continue;
                }
                if (!key.equals("##$RECO_wordtype")) continue;
                bits = Integer.parseInt(value.substring(1, value.indexOf("BIT")));
                signed = value.indexOf("_SGN_") >= 0;
                isFloat = !value.endsWith("_INT");
            }
            int td = Integer.parseInt((String)sizes[0]);
            int ys = sizes.length > 1 ? Integer.parseInt((String)sizes[1]) : 0;
            int n = zs = sizes.length > 2 ? Integer.parseInt((String)sizes[2]) : 0;
            if (sizes.length == 2) {
                if (ni == 1) {
                    ms.sizeY = ys;
                    ms.sizeZ = nr;
                } else {
                    ms.sizeY = ys;
                    ms.sizeZ = ni;
                }
            } else if (sizes.length == 3) {
                ms.sizeY = ni * ys;
                ms.sizeZ = nr * zs;
            }
            ms.sizeX = td;
            ms.sizeZ /= ns;
            ms.sizeT = ns * nr;
            ms.sizeC = 1;
            ms.imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
            ms.dimensionOrder = "XYCTZ";
            ms.rgb = false;
            ms.interleaved = false;
            ms.pixelType = FormatTools.pixelTypeFromBytes(bits / 8, signed, isFloat);
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        for (int series = 0; series < this.getSeriesCount(); ++series) {
            store.setImageName(imageNames[series] + " #" + (series + 1), series);
            String date = DateTools.formatDate(timestamps[series], DATE_FORMAT);
            if (date != null) {
                store.setImageAcquisitionDate(new Timestamp(date), series);
            }
            String expID = MetadataTools.createLSID("Experimenter", series);
            store.setExperimenterID(expID, series);
            store.setExperimenterLastName(users[series], series);
            store.setExperimenterInstitution(institutions[series], series);
            store.setImageExperimenterRef(expID, series);
        }
    }
}

