/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import loci.common.Location;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.MetadataConverter;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CellVoyagerReader
extends FormatReader {
    private static final String SINGLE_TIFF_PATH_BUILDER = "Image/W%dF%03dT%04dZ%02dC%d.tif";
    private Location measurementFolder;
    private List<ChannelInfo> channelInfos;
    private List<WellInfo> wells;
    private List<Integer> timePoints;
    private Location measurementResultFile;
    private Location omeMeasurementFile;

    public CellVoyagerReader() {
        super("CellVoyager", new String[]{"tif", "xml"});
        this.suffixNecessary = false;
        this.suffixSufficient = false;
        this.hasCompanionFiles = true;
        this.datasetDescription = "Directory with 2 master files 'MeasurementResult.xml' and 'MeasurementResult.ome.xml', used to stich together several TIF files.";
        this.domains = new String[]{"Histology", "Light Microscopy", "High-Content Screening (HCS)"};
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        CoreMetadata cm = (CoreMetadata)this.core.get(this.getSeries());
        int nImagesPerTimepoint = cm.sizeC * cm.sizeZ;
        int targetTindex = no / nImagesPerTimepoint;
        int rem = no % nImagesPerTimepoint;
        int targetZindex = rem / cm.sizeC;
        int targetCindex = rem % cm.sizeC;
        int[] indices = this.seriesToWellArea(this.getSeries());
        int wellIndex = indices[0];
        int areaIndex = indices[1];
        WellInfo well = this.wells.get(wellIndex);
        AreaInfo area = well.areas.get(areaIndex);
        MinimalTiffReader tiffReader = new MinimalTiffReader();
        for (FieldInfo field : area.fields) {
            String filename = String.format(SINGLE_TIFF_PATH_BUILDER, wellIndex + 1, field.index, targetTindex + 1, targetZindex + 1, targetCindex + 1);
            Location image = new Location(this.measurementFolder, filename = filename.replace('\\', File.separatorChar));
            if (!image.exists()) {
                throw new IOException("Could not find required file: " + image);
            }
            tiffReader.setId(image.getAbsolutePath());
            int tw = this.channelInfos.get((int)0).tileWidth;
            int th = this.channelInfos.get((int)0).tileHeight;
            int xbs0 = (int)field.xpixels;
            int ybs0 = (int)field.ypixels;
            if (x + w < xbs0 || xbs0 + tw < x || y + h < ybs0 || ybs0 + th < y) continue;
            int xs0 = Math.max(xbs0 - x, 0);
            int ys0 = Math.max(ybs0 - y, 0);
            int xs1 = Math.max(x - xbs0, 0);
            int ys1 = Math.max(y - ybs0, 0);
            int xe1 = Math.min(tw, x + w - xbs0);
            int ye1 = Math.min(th, y + h - ybs0);
            int w1 = xe1 - xs1;
            int h1 = ye1 - ys1;
            if (w1 <= 0 || h1 <= 0) continue;
            byte[] bytes = tiffReader.openBytes(0, xs1, ys1, w1, h1);
            int nbpp = cm.bitsPerPixel / 8;
            for (int row1 = 0; row1 < h1; ++row1) {
                int ls1 = nbpp * (row1 * w1);
                int length = nbpp * w1;
                int ls0 = nbpp * ((ys0 + row1) * w + xs0);
                System.arraycopy(bytes, ls1, buf, ls0, length);
            }
            tiffReader.close();
        }
        return buf;
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public int getRequiredDirectories(String[] files) throws FormatException, IOException {
        return 0;
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        String localName = new Location(name).getName();
        if (localName.equals("MeasurementResult.xml")) {
            return true;
        }
        Location parent = new Location(name).getAbsoluteFile().getParentFile();
        Location xml = new Location(parent, "MeasurementResult.xml");
        if (!xml.exists()) {
            return false;
        }
        return super.isThisType(name, open);
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.measurementFolder = new Location(id).getAbsoluteFile();
        if (!this.measurementFolder.exists()) {
            throw new IOException("File " + id + " does not exist.");
        }
        if (!this.measurementFolder.isDirectory()) {
            this.measurementFolder = this.measurementFolder.getParentFile();
        }
        this.measurementResultFile = new Location(this.measurementFolder, "MeasurementResult.xml");
        if (!this.measurementResultFile.exists()) {
            throw new IOException("Could not find " + this.measurementResultFile + " in folder.");
        }
        this.omeMeasurementFile = new Location(this.measurementFolder, "MeasurementResult.ome.xml");
        if (!this.omeMeasurementFile.exists()) {
            throw new IOException("Could not find " + this.omeMeasurementFile + " in folder.");
        }
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = null;
        try {
            dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LOGGER.debug("", e);
        }
        Document msDocument = null;
        try {
            msDocument = dBuilder.parse(this.measurementResultFile.getAbsolutePath());
        }
        catch (SAXException e) {
            LOGGER.debug("", e);
        }
        msDocument.getDocumentElement().normalize();
        String fileVersionMajor = CellVoyagerReader.getChildText(msDocument.getDocumentElement(), new String[]{"FileVersion", "Major"});
        String fileVersionMinor = CellVoyagerReader.getChildText(msDocument.getDocumentElement(), new String[]{"FileVersion", "Miner"});
        if (!fileVersionMajor.equals("1") || !fileVersionMinor.equals("0")) {
            LOGGER.warn("Detected a file version " + fileVersionMajor + "." + fileVersionMinor + ". This reader was built by reverse-engineering v1.0 files only. Errors might occur.");
        }
        Document omeDocument = null;
        try {
            omeDocument = dBuilder.parse(this.omeMeasurementFile.getAbsolutePath());
        }
        catch (SAXException e) {
            LOGGER.debug("", e);
        }
        omeDocument.getDocumentElement().normalize();
        this.readInfo(msDocument, omeDocument);
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            return new String[]{this.measurementResultFile.getAbsolutePath(), this.omeMeasurementFile.getAbsolutePath()};
        }
        int[] indices = this.seriesToWellArea(this.getSeries());
        int wellIndex = indices[0];
        int areaIndex = indices[1];
        AreaInfo area = this.wells.get((int)wellIndex).areas.get(areaIndex);
        int nFields = area.fields.size();
        String[] images = new String[this.getImageCount() * nFields + 2];
        int index = 0;
        images[index++] = this.measurementResultFile.getAbsolutePath();
        images[index++] = this.omeMeasurementFile.getAbsolutePath();
        for (Integer timepoint : this.timePoints) {
            for (int zslice = 1; zslice <= this.getSizeZ(); ++zslice) {
                for (int channel = 1; channel <= this.getSizeC(); ++channel) {
                    for (FieldInfo field : area.fields) {
                        images[index++] = this.measurementFolder.getAbsolutePath() + String.format(SINGLE_TIFF_PATH_BUILDER, wellIndex + 1, field.index, timepoint, zslice, channel);
                    }
                }
            }
        }
        return images;
    }

    private int[] seriesToWellArea(int series) {
        int nWell = -1;
        int seriesInc = -1;
        for (WellInfo well : this.wells) {
            ++nWell;
            int nAreas = -1;
            for (AreaInfo area : well.areas) {
                ++nAreas;
                if (series != ++seriesInc) continue;
                return new int[]{nWell, nAreas};
            }
        }
        throw new IllegalStateException("Cannot find a well for series " + series);
    }

    private void readInfo(Document msDocument, Document omeDocument) throws FormatException {
        double objectiveMagnification;
        Element msRoot = msDocument.getDocumentElement();
        double magnification = objectiveMagnification = Double.parseDouble(CellVoyagerReader.getChildText(msRoot, new String[]{"ObjectiveLens", "Magnification"}));
        NodeList nodeList = omeDocument.getElementsByTagName("*");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NamedNodeMap atts;
            Node namedItem;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || (namedItem = (atts = node.getAttributes()).getNamedItem("ID")) != null) continue;
            String name = node.getNodeName();
            String id = name + ":" + i;
            if (node.getParentNode().getNodeName().equals("LightSource")) continue;
            ((Element)node).setAttribute("ID", id);
        }
        String[] stringArray = new String[]{"Image", "Pixels"};
        Element pszEl = CellVoyagerReader.getChild(omeDocument.getDocumentElement(), stringArray);
        double physicalSizeZ = Double.parseDouble(pszEl.getAttribute("PhysicalSizeZ"));
        if (physicalSizeZ <= 0.0) {
            pszEl.setAttribute("PhysicalSizeZ", "1");
        }
        OMEXMLService service = null;
        String xml = null;
        try {
            xml = XMLTools.getXML(omeDocument);
        }
        catch (TransformerConfigurationException e2) {
            LOGGER.debug("", e2);
        }
        catch (TransformerException e2) {
            e2.printStackTrace();
        }
        try {
            service = new ServiceFactory().getInstance(OMEXMLService.class);
        }
        catch (DependencyException e1) {
            LOGGER.debug("", e1);
        }
        OMEXMLMetadata omeMD = null;
        try {
            omeMD = service.createOMEXMLMetadata(xml);
        }
        catch (ServiceException e) {
            LOGGER.debug("", e);
        }
        catch (NullPointerException npe) {
            LOGGER.debug("", npe);
            throw npe;
        }
        omeMD.setPixelsPhysicalSizeX(new PositiveFloat((Double)omeMD.getPixelsPhysicalSizeX(0).getValue() / magnification), 0);
        omeMD.setPixelsPhysicalSizeY(new PositiveFloat((Double)omeMD.getPixelsPhysicalSizeY(0).getValue() / magnification), 0);
        omeMD.setPixelsTimeIncrement(this.readFrameInterval(msDocument), 0);
        Element channelsEl = CellVoyagerReader.getChild(msRoot, "Channels");
        List<Element> channelEls = CellVoyagerReader.getChildren(channelsEl, "Channel");
        this.channelInfos = new ArrayList<ChannelInfo>();
        int channelIndex = 0;
        for (Element channelEl : channelEls) {
            boolean isEnabled = Boolean.parseBoolean(CellVoyagerReader.getChildText(channelEl, "IsEnabled"));
            if (!isEnabled) continue;
            ChannelInfo ci = this.readChannel(channelEl);
            this.channelInfos.add(ci);
            omeMD.setChannelColor(ci.color, 0, channelIndex++);
        }
        omeMD.setProjectID(MetadataTools.createLSID("Project", 0), 0);
        omeMD.setScreenID(MetadataTools.createLSID("Screen", 0), 0);
        omeMD.setPlateID(MetadataTools.createLSID("Plate", 0), 0);
        omeMD.setInstrumentID(MetadataTools.createLSID("Instrument", 0), 0);
        double pixelWidth = (Double)omeMD.getPixelsPhysicalSizeX(0).getValue();
        double pixelHeight = (Double)omeMD.getPixelsPhysicalSizeY(0).getValue();
        int tileWidth = this.channelInfos.get((int)0).tileWidth;
        int tileHeight = this.channelInfos.get((int)0).tileHeight;
        boolean sameAreaPerWell = Boolean.parseBoolean(CellVoyagerReader.getChildText(msRoot, "UsesSameAreaParWell"));
        ArrayList<AreaInfo> areas = null;
        if (sameAreaPerWell) {
            Element areasEl = CellVoyagerReader.getChild(msRoot, new String[]{"SameAreaUsingWell", "Areas"});
            List<Element> areaEls = CellVoyagerReader.getChildren(areasEl, "Area");
            int areaIndex = 0;
            areas = new ArrayList<AreaInfo>(areaEls.size());
            int fieldIndex = 1;
            for (Element areaEl : areaEls) {
                AreaInfo area = this.readArea(areaEl, fieldIndex, pixelWidth, pixelHeight, tileWidth, tileHeight);
                area.index = areaIndex++;
                areas.add(area);
                fieldIndex = area.fields.get((int)(area.fields.size() - 1)).index + 1;
            }
        }
        Element wellsEl = CellVoyagerReader.getChild(msRoot, "Wells");
        List<Element> wellEls = CellVoyagerReader.getChildren(wellsEl, "Well");
        this.wells = new ArrayList<WellInfo>();
        for (Element wellEl : wellEls) {
            boolean isWellEnabled = Boolean.parseBoolean(CellVoyagerReader.getChild(wellEl, "IsEnabled").getTextContent());
            if (!isWellEnabled) continue;
            WellInfo wi = this.readWellInfo(wellEl, pixelWidth, pixelHeight, tileWidth, tileHeight);
            if (sameAreaPerWell) {
                wi.areas = areas;
            }
            this.wells.add(wi);
        }
        int nZSlices = Integer.parseInt(CellVoyagerReader.getChildText(msRoot, new String[]{"ZStackConditions", "NumberOfSlices"}));
        this.timePoints = this.readTimePoints(msDocument);
        this.core.clear();
        for (WellInfo well : this.wells) {
            for (AreaInfo area : well.areas) {
                CoreMetadata ms = new CoreMetadata();
                this.core.add(ms);
                ms.sizeX = area.width;
                ms.sizeY = area.height;
                ms.sizeZ = nZSlices;
                ms.sizeC = this.channelInfos.size();
                ms.sizeT = this.timePoints.size();
                ms.dimensionOrder = "XYCZT";
                ms.rgb = false;
                ms.imageCount = nZSlices * this.channelInfos.size() * this.timePoints.size();
                switch (omeMD.getPixelsType(0)) {
                    case UINT8: {
                        ms.pixelType = 1;
                        ms.bitsPerPixel = 8;
                        break;
                    }
                    case UINT16: {
                        ms.pixelType = 3;
                        ms.bitsPerPixel = 16;
                        break;
                    }
                    case UINT32: {
                        ms.pixelType = 5;
                        ms.bitsPerPixel = 32;
                        break;
                    }
                    default: {
                        throw new FormatException("Cannot read image with pixel type = " + omeMD.getPixelsType(0));
                    }
                }
                ms.littleEndian = true;
            }
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        MetadataConverter.convertMetadata(omeMD, store);
        double pinholeSize = Double.parseDouble(CellVoyagerReader.getChildText(msRoot, new String[]{"PinholeDisk", "PinholeSize_um"}));
        Element containerEl = CellVoyagerReader.getChild(msRoot, new String[]{"Attachment", "HolderInfoList", "HolderInfo", "MountedSampleContainer"});
        String type = containerEl.getAttribute("xsi:type");
        if (type.equals("WellPlate")) {
            int nrows = Integer.parseInt(CellVoyagerReader.getChildText(containerEl, "RowCount"));
            int ncols = Integer.parseInt(CellVoyagerReader.getChildText(containerEl, "ColumnCount"));
            store.setPlateRows(new PositiveInteger(nrows), 0);
            store.setPlateColumns(new PositiveInteger(ncols), 0);
            String plateAcqID = MetadataTools.createLSID("PlateAcquisition", 0, 0);
            store.setPlateAcquisitionID(plateAcqID, 0, 0);
            Element dimInfoEl = CellVoyagerReader.getChild(msRoot, "DimensionsInfo");
            int maxNFields = Integer.parseInt(CellVoyagerReader.getChild(dimInfoEl, "F").getAttribute("Max"));
            PositiveInteger fieldCount = FormatTools.getMaxFieldCount(maxNFields);
            if (fieldCount != null) {
                store.setPlateAcquisitionMaximumFieldCount(fieldCount, 0, 0);
            }
            String beginTime = CellVoyagerReader.getChildText(msRoot, "BeginTime");
            String endTime = CellVoyagerReader.getChildText(msRoot, "EndTime");
            store.setPlateAcquisitionStartTime(new Timestamp(beginTime), 0, 0);
            store.setPlateAcquisitionEndTime(new Timestamp(endTime), 0, 0);
        }
        int seriesIndex = -1;
        int wellIndex = -1;
        for (WellInfo well : this.wells) {
            int wellNumber = well.number;
            store.setWellRow(new NonNegativeInteger(well.row), 0, ++wellIndex);
            store.setWellColumn(new NonNegativeInteger(well.col), 0, wellIndex);
            store.setWellID(MetadataTools.createLSID("Well", well.UID), 0, wellIndex);
            int areaIndex = -1;
            for (AreaInfo area : well.areas) {
                String imageName = "Well " + wellNumber + " (r=" + well.row + ", c=" + well.col + ") - Area " + ++areaIndex;
                store.setImageName(imageName, ++seriesIndex);
                store.setWellSampleIndex(new NonNegativeInteger(area.index), 0, wellIndex, areaIndex);
                store.setWellSampleID(MetadataTools.createLSID("WellSample", area.UID), 0, wellIndex, areaIndex);
                store.setWellSamplePositionX(well.centerX, 0, wellIndex, areaIndex);
                store.setWellSamplePositionY(well.centerY, 0, wellIndex, areaIndex);
                channelIndex = 0;
                for (int i = 0; i < this.channelInfos.size(); ++i) {
                    store.setChannelPinholeSize(pinholeSize, seriesIndex, channelIndex++);
                    store.setChannelName(this.channelInfos.get((int)i).name, seriesIndex, i);
                }
            }
        }
    }

    private ChannelInfo readChannel(Element channelEl) {
        String channelName;
        Color channelColor;
        ChannelInfo ci = new ChannelInfo();
        ci.isEnabled = Boolean.parseBoolean(CellVoyagerReader.getChildText(channelEl, "IsEnabled"));
        ci.channelNumber = Integer.parseInt(CellVoyagerReader.getChildText(channelEl, "Number"));
        Element acquisitionSettings = CellVoyagerReader.getChild(channelEl, "AcquisitionSetting");
        Element cameraEl = CellVoyagerReader.getChild(acquisitionSettings, "Camera");
        ci.tileWidth = Integer.parseInt(CellVoyagerReader.getChildText(cameraEl, "EffectiveHorizontalPixels_pixel"));
        ci.tileHeight = Integer.parseInt(CellVoyagerReader.getChildText(cameraEl, "EffectiveVerticalPixels_pixel"));
        ci.unmagnifiedPixelWidth = Double.parseDouble(CellVoyagerReader.getChildText(cameraEl, "HorizonalCellSize_um"));
        ci.unmagnifiedPixelHeight = Double.parseDouble(CellVoyagerReader.getChildText(cameraEl, "VerticalCellSize_um"));
        Element colorElement = CellVoyagerReader.getChild(channelEl, new String[]{"ContrastEnhanceParam", "Color"});
        int r = Integer.parseInt(CellVoyagerReader.getChildText(colorElement, "R"));
        int g = Integer.parseInt(CellVoyagerReader.getChildText(colorElement, "G"));
        int b = Integer.parseInt(CellVoyagerReader.getChildText(colorElement, "B"));
        int a = Integer.parseInt(CellVoyagerReader.getChildText(colorElement, "A"));
        ci.color = channelColor = new Color(r, g, b, a);
        String excitationType = CellVoyagerReader.getChild(channelEl, "Excitation").getAttribute("xsi:type");
        String excitationName = CellVoyagerReader.getChildText(channelEl, new String[]{"Excitation", "Name", "Value"});
        String emissionName = CellVoyagerReader.getChildText(channelEl, new String[]{"Emission", "Name", "Value"});
        String fluorophoreName = CellVoyagerReader.getChildText(channelEl, new String[]{"Emission", "FluorescentProbe", "Value"});
        if (null == fluorophoreName) {
            fluorophoreName = "\u00f8";
        }
        ci.name = channelName = "Ex: " + excitationType + "(" + excitationName + ") / Em: " + emissionName + " / Fl: " + fluorophoreName;
        return ci;
    }

    private WellInfo readWellInfo(Element wellEl, double pixelWidth, double pixelHeight, int tileWidth, int tileHeight) {
        WellInfo info = new WellInfo();
        info.UID = Integer.parseInt(CellVoyagerReader.getChildText(wellEl, "UniqueID"));
        info.number = Integer.parseInt(CellVoyagerReader.getChildText(wellEl, "Number"));
        info.row = Integer.parseInt(CellVoyagerReader.getChildText(wellEl, "Row"));
        info.col = Integer.parseInt(CellVoyagerReader.getChildText(wellEl, "Column"));
        info.centerX = Double.parseDouble(CellVoyagerReader.getChildText(wellEl, new String[]{"CenterCoord_mm", "X"}));
        info.centerY = Double.parseDouble(CellVoyagerReader.getChildText(wellEl, new String[]{"CenterCoord_mm", "Y"}));
        Element areasEl = CellVoyagerReader.getChild(wellEl, "Areas");
        List<Element> areaEls = CellVoyagerReader.getChildren(areasEl, "Area");
        int areaIndex = 0;
        int fieldIndex = 1;
        for (Element areaEl : areaEls) {
            AreaInfo area = this.readArea(areaEl, fieldIndex, pixelWidth, pixelHeight, tileWidth, tileHeight);
            area.index = areaIndex++;
            info.areas.add(area);
            fieldIndex = area.fields.get((int)(area.fields.size() - 1)).index + 1;
        }
        return info;
    }

    private AreaInfo readArea(Element areaEl, int startingFieldIndex, double pixelWidth, double pixelHeight, int tileWidth, int tileHeight) {
        AreaInfo info = new AreaInfo();
        info.UID = Integer.parseInt(CellVoyagerReader.getChildText(areaEl, "UniqueID"));
        double xmin = Double.POSITIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        Element fieldsEl = CellVoyagerReader.getChild(areaEl, "Fields");
        List<Element> fieldEls = CellVoyagerReader.getChildren(fieldsEl, "Field");
        for (Element fieldEl : fieldEls) {
            double yum;
            FieldInfo finfo = this.readField(fieldEl);
            info.fields.add(finfo);
            double xum = finfo.x;
            if (xum < xmin) {
                xmin = xum;
            }
            if (xum > xmax) {
                xmax = xum;
            }
            if ((yum = -finfo.y) < ymin) {
                ymin = yum;
            }
            if (!(yum > ymax)) continue;
            ymax = yum;
        }
        for (FieldInfo finfo : info.fields) {
            long xpixels = Math.round((finfo.x - xmin) / pixelWidth);
            long ypixels = Math.round((-ymin - finfo.y) / pixelHeight);
            finfo.xpixels = xpixels;
            finfo.ypixels = ypixels;
            finfo.index = startingFieldIndex++;
        }
        int width = 1 + (int)((xmax - xmin) / pixelWidth);
        int height = 1 + (int)((ymax - ymin) / pixelHeight);
        info.width = width + tileWidth;
        info.height = height + tileHeight;
        return info;
    }

    private FieldInfo readField(Element fieldEl) {
        FieldInfo info = new FieldInfo();
        info.x = Double.parseDouble(CellVoyagerReader.getChildText(fieldEl, "StageX_um"));
        info.y = Double.parseDouble(CellVoyagerReader.getChildText(fieldEl, "StageY_um"));
        return info;
    }

    private List<Integer> readTimePoints(Document document) {
        Element root = document.getDocumentElement();
        int nTimePoints = Integer.parseInt(CellVoyagerReader.getChildText(root, new String[]{"TimelapsCondition", "Iteration"}));
        ArrayList<Integer> timepoints = new ArrayList<Integer>(nTimePoints);
        for (int i = 0; i < nTimePoints; ++i) {
            timepoints.add(i);
        }
        return timepoints;
    }

    private double readFrameInterval(Document document) {
        Element root = document.getDocumentElement();
        double dt = Double.parseDouble(CellVoyagerReader.getChildText(root, new String[]{"TimelapsCondition", "Interval"}));
        return dt;
    }

    private static final Element getChild(Element parent, String childName) {
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            if (!item.getNodeName().equals(childName)) continue;
            return (Element)item;
        }
        return null;
    }

    private static final Element getChild(Element parent, String[] path) {
        if (path.length == 1) {
            return CellVoyagerReader.getChild(parent, path[0]);
        }
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            if (!item.getNodeName().equals(path[0])) continue;
            return CellVoyagerReader.getChild((Element)item, Arrays.copyOfRange(path, 1, path.length));
        }
        return null;
    }

    private static final List<Element> getChildren(Element parent, String name) {
        NodeList nodeList = parent.getElementsByTagName(name);
        int nEls = nodeList.getLength();
        ArrayList<Element> children = new ArrayList<Element>(nEls);
        for (int i = 0; i < nEls; ++i) {
            children.add((Element)nodeList.item(i));
        }
        return children;
    }

    private static final String getChildText(Element parent, String[] path) {
        if (path.length == 1) {
            return CellVoyagerReader.getChildText(parent, path[0]);
        }
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            if (!item.getNodeName().equals(path[0])) continue;
            return CellVoyagerReader.getChildText((Element)item, Arrays.copyOfRange(path, 1, path.length));
        }
        return null;
    }

    private static final String getChildText(Element parent, String childName) {
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            if (!item.getNodeName().equals(childName)) continue;
            return item.getTextContent();
        }
        return null;
    }

    public static void main(String[] args) throws IOException, FormatException, ServiceException {
        String[] usedFiles;
        String[] keys;
        String id = "/Users/tinevez/Projects/EArena/Data/TestDataset/20131030T142837";
        CellVoyagerReader importer = new CellVoyagerReader();
        importer.setId("/Users/tinevez/Projects/EArena/Data/TestDataset/20131030T142837");
        List<CoreMetadata> cms = importer.getCoreMetadataList();
        for (CoreMetadata coreMetadata : cms) {
            System.out.println(coreMetadata);
        }
        Hashtable<String, Object> meta = importer.getGlobalMetadata();
        for (String key : keys = MetadataTools.keys(meta)) {
            System.out.println(key + " = " + meta.get(key));
        }
        importer.openBytes(0);
        importer.setSeries(1);
        for (String file2 : usedFiles = importer.getSeriesUsedFiles()) {
            System.out.println("  " + file2);
        }
        importer.close();
    }

    private static final class ChannelInfo {
        public String name;
        public Color color;
        public int height;
        public int width;
        public boolean isEnabled;
        public double unmagnifiedPixelHeight;
        public double unmagnifiedPixelWidth;
        public int tileHeight;
        public int tileWidth;
        public int channelNumber;

        private ChannelInfo() {
        }

        public String toString() {
            StringBuffer str = new StringBuffer();
            str.append("Channel " + this.channelNumber + ": \n");
            str.append(" - name: " + this.name + "\n");
            str.append(" - isEnabled: " + this.isEnabled + "\n");
            str.append(" - width: " + this.width + "\n");
            str.append(" - height: " + this.height + "\n");
            str.append(" - tile width: " + this.tileWidth + "\n");
            str.append(" - tile height: " + this.tileHeight + "\n");
            str.append(" - unmagnifiedPixelWidth: " + this.unmagnifiedPixelWidth + "\n");
            str.append(" - unmagnifiedPixelHeight: " + this.unmagnifiedPixelHeight + "\n");
            return str.toString();
        }
    }

    private static final class WellInfo {
        public List<AreaInfo> areas = new ArrayList<AreaInfo>();
        public double centerY;
        public double centerX;
        public int col;
        public int row;
        public int number;
        public int UID;

        private WellInfo() {
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("Well ID = " + this.UID + '\n');
            str.append("\tnumber = " + this.number + '\n');
            str.append("\trow = " + this.row + '\n');
            str.append("\tcol = " + this.col + '\n');
            str.append("\tcenter X = " + this.centerX + " mm\n");
            str.append("\tcenter Y = " + this.centerY + " mm\n");
            for (AreaInfo areaInfo : this.areas) {
                str.append(areaInfo.toString());
            }
            return str.toString();
        }
    }

    private static final class AreaInfo {
        public int index;
        public int height;
        public int width;
        public List<FieldInfo> fields = new ArrayList<FieldInfo>();
        public int UID;

        private AreaInfo() {
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("\tArea ID = " + this.UID + '\n');
            str.append("\t\ttotal width = " + this.width + " pixels\n");
            str.append("\t\ttotal height = " + this.height + " pixels\n");
            for (FieldInfo fieldInfo : this.fields) {
                str.append(fieldInfo.toString());
            }
            return str.toString();
        }
    }

    private static final class FieldInfo {
        public int index;
        public long ypixels;
        public long xpixels;
        public double y;
        public double x;

        private FieldInfo() {
        }

        public String toString() {
            return "\t\tField index = " + this.index + "\n\t\t\tX = " + this.x + " \u00b5m\n\t\t\tY = " + this.y + " \u00b5m\n" + "\t\t\txi = " + this.xpixels + " pixels\n" + "\t\t\tyi = " + this.ypixels + " pixels\n";
        }
    }
}

