/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.PositiveFloat;

public class INRReader
extends FormatReader {
    private static final String INR_MAGIC = "#INRIMAGE";
    private static final int HEADER_SIZE = 256;

    public INRReader() {
        super("INR", "inr");
        this.domains = new String[]{"Unknown"};
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = INR_MAGIC.length();
        if (!FormatTools.validStream(stream, blockLen, false)) {
            return false;
        }
        return stream.readString(blockLen).indexOf(INR_MAGIC) == 0;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        long planeSize = FormatTools.getPlaneSize(this);
        this.in.seek(256L + (long)no * planeSize);
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        LOGGER.info("Reading header");
        String header = this.in.readString(256);
        String[] lines = header.split("\n");
        Double physicalSizeX = null;
        Double physicalSizeY = null;
        Double physicalSizeZ = null;
        boolean isSigned = false;
        int nBits = 0;
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        for (String line : lines) {
            int index = line.indexOf("=");
            if (index < 0) continue;
            String key = line.substring(0, index);
            String value = line.substring(index + 1);
            this.addGlobalMeta(key, value);
            if (key.equals("XDIM")) {
                m.sizeX = Integer.parseInt(value);
                continue;
            }
            if (key.equals("YDIM")) {
                m.sizeY = Integer.parseInt(value);
                continue;
            }
            if (key.equals("ZDIM")) {
                m.sizeZ = Integer.parseInt(value);
                continue;
            }
            if (key.equals("VDIM")) {
                m.sizeT = Integer.parseInt(value);
                continue;
            }
            if (key.equals("TYPE")) {
                isSigned = value.toLowerCase().startsWith("signed");
                continue;
            }
            if (key.equals("PIXSIZE")) {
                String bits = value.substring(0, value.indexOf(" "));
                nBits = Integer.parseInt(bits);
                continue;
            }
            if (key.equals("VX")) {
                physicalSizeX = new Double(value);
                continue;
            }
            if (key.equals("VY")) {
                physicalSizeY = new Double(value);
                continue;
            }
            if (!key.equals("VZ")) continue;
            physicalSizeZ = new Double(value);
        }
        LOGGER.info("Populating metadata");
        if (this.getSizeZ() == 0) {
            m.sizeZ = 1;
        }
        if (this.getSizeT() == 0) {
            m.sizeT = 1;
        }
        m.sizeC = 1;
        m.imageCount = this.getSizeZ() * this.getSizeT() * this.getSizeC();
        m.pixelType = FormatTools.pixelTypeFromBytes(nBits / 8, isSigned, false);
        m.dimensionOrder = "XYZTC";
        LOGGER.info("Populating OME metadata");
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            PositiveFloat sizeX = FormatTools.getPhysicalSizeX(physicalSizeX);
            PositiveFloat sizeY = FormatTools.getPhysicalSizeY(physicalSizeY);
            PositiveFloat sizeZ = FormatTools.getPhysicalSizeZ(physicalSizeZ);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
            if (sizeZ != null) {
                store.setPixelsPhysicalSizeZ(sizeZ, 0);
            }
        }
    }
}

