/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.common.xml.BaseHandler;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.Timestamp;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class IvisionReader
extends FormatReader {
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private boolean color16;
    private boolean squareRoot;
    private byte[] lut;
    private long imageOffset;
    private String binX;
    private String binY;
    private String creationDate;
    private String exposureTime;
    private String gain;
    private String offset;
    private String deltaT;
    private Double magnification;
    private Double lensNA;
    private Double refractiveIndex;
    private String wavelength;
    private boolean hasPaddingByte = false;

    public IvisionReader() {
        super("IVision", "ipm");
        this.suffixSufficient = false;
        this.suffixNecessary = false;
        this.domains = new String[]{"Unknown"};
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockCheckLen = 4096;
        if (!FormatTools.validStream(stream, 4096, true)) {
            return false;
        }
        String version = stream.readString(3);
        try {
            Double.parseDouble(version);
            return version.indexOf(".") != -1 && version.indexOf("-") == -1;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int planeSize = this.getSizeX() * this.getSizeY() * this.getSizeC();
        planeSize = this.color16 ? 2 * (planeSize / 3) : (this.squareRoot ? (planeSize *= 2) : (this.hasPaddingByte ? (planeSize += this.getSizeX() * this.getSizeY()) : (planeSize *= FormatTools.getBytesPerPixel(this.getPixelType()))));
        this.in.seek(this.imageOffset + (long)(planeSize * no));
        if (this.color16) {
            throw new FormatException("16-bit color iVision files are not supported");
        }
        if (this.squareRoot) {
            throw new FormatException("Square-root iVision files are not supported");
        }
        if (this.hasPaddingByte) {
            int next = 0;
            this.in.skipBytes(y * this.getSizeX() * this.getSizeC());
            for (int row = 0; row < h; ++row) {
                this.in.skipBytes(x * this.getSizeC());
                for (int col = 0; col < w; ++col) {
                    this.in.skipBytes(1);
                    this.in.read(buf, next, this.getSizeC());
                    next += this.getSizeC();
                }
                this.in.skipBytes(this.getSizeC() * (this.getSizeX() - w - x));
            }
        } else {
            this.readPlane(this.in, x, y, w, h, buf);
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.color16 = false;
            this.squareRoot = false;
            this.lut = null;
            this.imageOffset = 0L;
            this.binY = null;
            this.binX = null;
            this.creationDate = null;
            this.exposureTime = null;
            this.offset = null;
            this.gain = null;
            this.deltaT = null;
            this.magnification = null;
            this.refractiveIndex = null;
            this.lensNA = null;
            this.wavelength = null;
            this.hasPaddingByte = false;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        String date;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        LOGGER.info("Populating metadata");
        String version = this.in.readString(4);
        this.addGlobalMeta("Version", version);
        int fileFormat = this.in.read();
        int dataType = this.in.read();
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        m.sizeC = 1;
        switch (dataType) {
            case 0: {
                m.pixelType = 1;
                break;
            }
            case 1: {
                m.pixelType = 2;
                break;
            }
            case 2: {
                m.pixelType = 4;
                break;
            }
            case 3: {
                m.pixelType = 6;
                break;
            }
            case 4: {
                m.pixelType = 1;
                m.sizeC = 3;
                this.color16 = true;
                break;
            }
            case 5: {
                m.pixelType = 1;
                m.sizeC = 3;
                this.hasPaddingByte = true;
                break;
            }
            case 6: {
                m.pixelType = 3;
                break;
            }
            case 7: {
                m.pixelType = 6;
                this.squareRoot = true;
                break;
            }
            case 8: {
                m.pixelType = 3;
                m.sizeC = 3;
            }
        }
        m.sizeX = this.in.readInt();
        m.sizeY = this.in.readInt();
        this.in.skipBytes(6);
        m.sizeZ = this.in.readShort();
        this.in.skipBytes(50);
        m.sizeT = 1;
        if (this.getSizeX() > 1 && this.getSizeY() > 1) {
            this.lut = new byte[2048];
            this.in.read(this.lut);
        }
        this.imageOffset = this.in.getFilePointer();
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            this.in.skipBytes(this.getSizeZ() * this.getSizeC() * this.getSizeT() * this.getSizeX() * this.getSizeY() * FormatTools.getBytesPerPixel(this.getPixelType()));
            LOGGER.info("Looking for XML metadata");
            this.in.findString(false, "<?xml");
            if (this.in.getFilePointer() < this.in.length()) {
                this.in.seek(this.in.getFilePointer() - 5L);
                String xml = this.in.readString((int)(this.in.length() - this.in.getFilePointer()));
                xml = xml.substring(xml.indexOf("<"), xml.lastIndexOf("plist>") + 6);
                IvisionHandler handler = new IvisionHandler();
                try {
                    XMLTools.parseXML(xml, (DefaultHandler)handler);
                }
                catch (IOException e) {
                    LOGGER.debug("", e);
                }
            } else {
                LOGGER.debug("XML metadata not found");
            }
        }
        LOGGER.info("Populating core metadata");
        m.rgb = this.getSizeC() > 1;
        m.dimensionOrder = "XYCZT";
        m.littleEndian = false;
        m.interleaved = true;
        m.indexed = false;
        m.imageCount = this.getSizeZ() * this.getSizeT();
        LOGGER.info("Populating MetadataStore");
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        if (this.creationDate != null && (date = DateTools.formatDate(this.creationDate, DATE_FORMAT)) != null) {
            store.setImageAcquisitionDate(new Timestamp(date), 0);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            String instrumentID = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrumentID, 0);
            store.setImageInstrumentRef(instrumentID, 0);
            if (this.deltaT != null) {
                Double increment = 0.0;
                try {
                    increment = new Double(this.deltaT);
                }
                catch (NumberFormatException e) {
                    LOGGER.debug("Failed to parse time increment", e);
                }
                store.setPixelsTimeIncrement(increment, 0);
            }
            String objectiveID = MetadataTools.createLSID("Objective", 0, 0);
            store.setObjectiveID(objectiveID, 0, 0);
            store.setObjectiveSettingsID(objectiveID, 0);
            store.setObjectiveCorrection(this.getCorrection("Other"), 0, 0);
            store.setObjectiveImmersion(this.getImmersion("Other"), 0, 0);
            if (this.lensNA != null) {
                store.setObjectiveLensNA(this.lensNA, 0, 0);
            }
            if (this.magnification != null) {
                store.setObjectiveNominalMagnification(this.magnification, 0, 0);
            }
            if (this.refractiveIndex != null) {
                store.setObjectiveSettingsRefractiveIndex(this.refractiveIndex, 0);
            }
            String detectorID = MetadataTools.createLSID("Detector", 0, 0);
            store.setDetectorID(detectorID, 0, 0);
            store.setDetectorSettingsID(detectorID, 0, 0);
            store.setDetectorType(this.getDetectorType("Other"), 0, 0);
            store.setDetectorSettingsBinning(this.getBinning(this.binX + "x" + this.binY), 0, 0);
            if (this.gain != null) {
                try {
                    store.setDetectorSettingsGain(new Double(this.gain), 0, 0);
                }
                catch (NumberFormatException e) {
                    LOGGER.debug("Failed to parse detector gain", e);
                }
            }
        }
    }

    class IvisionHandler
    extends BaseHandler {
        private String key;
        private String value;
        private String currentElement;

        IvisionHandler() {
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            IvisionReader.this.addGlobalMeta(this.key, this.value);
            if ("iplab:Bin_X".equals(this.key)) {
                IvisionReader.this.binX = this.value;
            } else if ("iplab:Bin_Y".equals(this.key)) {
                IvisionReader.this.binY = this.value;
            } else if ("iplab:Capture_Date".equals(this.key)) {
                IvisionReader.this.creationDate = this.value;
            } else if ("iplab:Exposure".equals(this.key)) {
                IvisionReader.this.exposureTime = this.value;
            } else if ("iplab:Gain".equals(this.key)) {
                IvisionReader.this.gain = this.value;
            } else if ("iplab:Offset".equals(this.key)) {
                IvisionReader.this.offset = this.value;
            } else if ("iplab:Interval_T".equals(this.key)) {
                IvisionReader.this.deltaT = this.value;
            } else if ("iplab:Objective_Mag".equals(this.key)) {
                try {
                    IvisionReader.this.magnification = new Double(this.value);
                }
                catch (NumberFormatException e) {}
            } else if ("iplab:Objective_NA".equals(this.key)) {
                try {
                    IvisionReader.this.lensNA = new Double(this.value);
                }
                catch (NumberFormatException e) {}
            } else if ("iplab:Objective_RI".equals(this.key)) {
                try {
                    IvisionReader.this.refractiveIndex = new Double(this.value);
                }
                catch (NumberFormatException e) {}
            } else if ("iplab:Wavelength".equals(this.key)) {
                IvisionReader.this.wavelength = this.value;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            String v = new String(ch, start, length).trim();
            if (v.length() > 0) {
                if ("key".equals(this.currentElement)) {
                    this.key = v;
                } else {
                    this.value = v;
                }
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.currentElement = qName;
        }
    }
}

