/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

public class JEOLReader
extends FormatReader {
    private long pixelOffset;
    private String parameterFile;

    public JEOLReader() {
        super("JEOL", new String[]{"dat", "img", "par"});
        this.domains = new String[]{"Scanning Electron Microscopy (SEM)"};
        this.hasCompanionFiles = true;
        this.suffixSufficient = false;
        this.datasetDescription = "A single .dat file or an .img file with a similarly-named .par file";
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        if (JEOLReader.checkSuffix(name, "par") && open) {
            String base = new Location(name).getAbsoluteFile().getAbsolutePath();
            String id = (base = base.substring(0, base.lastIndexOf("."))) + ".IMG";
            if (!new Location(id).exists()) {
                id = base + ".DAT";
            }
            return new Location(id).exists();
        }
        if (JEOLReader.checkSuffix(name, "dat") && open) {
            try {
                RandomAccessInputStream stream = new RandomAccessInputStream(name);
                if (stream.length() == 0x100000L) {
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        return super.isThisType(name, open);
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 2;
        if (!FormatTools.validStream(stream, 2, false)) {
            return false;
        }
        String magic = stream.readString(2);
        return magic.equals("MG") || magic.equals("IM");
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        String[] stringArray;
        if (noPixels) {
            String[] stringArray2;
            if (this.parameterFile == null) {
                stringArray2 = null;
            } else {
                String[] stringArray3 = new String[1];
                stringArray2 = stringArray3;
                stringArray3[0] = this.parameterFile;
            }
            return stringArray2;
        }
        String id = new Location(this.currentId).getAbsolutePath();
        if (this.parameterFile == null) {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = id;
        } else {
            String[] stringArray5 = new String[2];
            stringArray5[0] = id;
            stringArray = stringArray5;
            stringArray5[1] = this.parameterFile;
        }
        return stringArray;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(this.pixelOffset);
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelOffset = 0L;
            this.parameterFile = null;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        String magic;
        if (JEOLReader.checkSuffix(id, "par")) {
            String base = new Location(id).getAbsoluteFile().getAbsolutePath();
            id = (base = base.substring(0, base.lastIndexOf("."))) + ".IMG";
            if (!new Location(id).exists()) {
                id = base + ".DAT";
            }
            if (!new Location(id).exists()) {
                throw new FormatException("Could not find image file.");
            }
        }
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        m.littleEndian = true;
        this.in.order(this.isLittleEndian());
        this.parameterFile = id.substring(0, id.lastIndexOf(".")) + ".PAR";
        this.parameterFile = new Location(this.parameterFile).getAbsolutePath();
        if (!new Location(this.parameterFile).exists()) {
            this.parameterFile = null;
        }
        if ((magic = this.in.readString(2)).equals("MG")) {
            this.in.seek(1596L);
            m.sizeX = this.in.readInt();
            m.sizeY = this.in.readInt();
            this.pixelOffset = this.in.getFilePointer() + 540L;
        } else if (magic.equals("IM")) {
            short commentLength = this.in.readShort();
            m.sizeX = 1024;
            this.pixelOffset = this.in.getFilePointer() + (long)commentLength + 56L;
            m.sizeY = (int)((this.in.length() - this.pixelOffset) / (long)this.getSizeX());
        } else {
            m.sizeX = 1024;
            m.sizeY = 1024;
            this.pixelOffset = 0L;
        }
        this.addGlobalMeta("Pixel data offset", this.pixelOffset);
        m.pixelType = 1;
        m.sizeZ = 1;
        m.sizeC = 1;
        m.sizeT = 1;
        m.imageCount = 1;
        m.dimensionOrder = "XYZCT";
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }
}

