/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.util.ArrayList;
import java.util.Stack;
import loci.formats.in.LeicaSCNReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class LeicaSCNHandler
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeicaSCNReader.class);
    boolean valid = false;
    public ArrayList<ImageCollection> collections;
    public ImageCollection currentCollection;
    public Image currentImage;
    public Dimension currentDimension;
    public int seriesIndex;
    public ArrayList<Integer> IFDMap = new ArrayList();
    public ArrayList<ImageCollection> collectionMap = new ArrayList();
    public ArrayList<Image> imageMap = new ArrayList();
    public Stack<String> nameStack = new Stack();
    public String cdata = new String();

    LeicaSCNHandler() {
    }

    public String toString() {
        String s = new String("TIFF-XML parsing\n");
        return s;
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (!this.nameStack.empty() && this.nameStack.peek().equals(qName)) {
            this.nameStack.pop();
        }
        if (!qName.equals("scn")) {
            if (qName.equals("collection")) {
                this.currentCollection = null;
            } else if (qName.equals("image")) {
                this.currentImage.imageNumStart = this.seriesIndex;
                this.seriesIndex += this.currentImage.pixels.sizeR;
                this.currentImage.imageNumEnd = this.seriesIndex - 1;
                this.currentImage = null;
            } else if (qName.equals("creationDate")) {
                this.currentImage.creationDate = this.cdata;
            } else if (!qName.equals("device")) {
                if (qName.equals("pixels")) {
                    Pixels p = this.currentImage.pixels;
                    int sizeC = 0;
                    int sizeR = 0;
                    int sizeZ = 0;
                    for (Dimension d : p.dims) {
                        if (d.c > sizeC) {
                            sizeC = d.c;
                        }
                        if (d.r > sizeR) {
                            sizeR = d.r;
                        }
                        if (d.z <= sizeZ) continue;
                        sizeZ = d.z;
                    }
                    p.sizeC = ++sizeC;
                    p.sizeR = ++sizeR;
                    p.sizeZ = ++sizeZ;
                    p.dimSizeX = new long[sizeZ][sizeC][sizeR];
                    p.dimSizeY = new long[sizeZ][sizeC][sizeR];
                    p.dimIFD = new int[sizeZ][sizeC][sizeR];
                    for (Dimension d : p.dims) {
                        p.dimSizeX[d.z][d.c][d.r] = d.sizeX;
                        p.dimSizeY[d.z][d.c][d.r] = d.sizeY;
                        p.dimIFD[d.z][d.c][d.r] = d.ifd;
                        if (d.r != 0 && this.currentImage.thumbSizeX <= d.sizeX) continue;
                        this.currentImage.thumbSizeX = d.sizeX;
                        this.currentImage.imageThumbnail = d.r;
                    }
                    for (int cr = 0; cr < sizeR; ++cr) {
                        for (int cc = 0; cc < sizeC; ++cc) {
                            for (int cz = 0; cz < sizeZ; ++cz) {
                                this.IFDMap.add(p.dimIFD[cz][cc][cr]);
                                this.collectionMap.add(this.currentCollection);
                                this.imageMap.add(this.currentImage);
                            }
                        }
                    }
                } else if (qName.equals("dimension")) {
                    this.currentDimension = null;
                } else if (!(qName.equals("view") || qName.equals("scanSettings") || qName.equals("objectiveSettings"))) {
                    if (qName.equals("objective")) {
                        this.currentImage.objMag = this.cdata;
                    } else if (!qName.equals("illuminationSettings")) {
                        if (qName.equals("numericalAperture")) {
                            this.currentImage.illumNA = this.cdata;
                        } else if (qName.equals("illuminationSource")) {
                            this.currentImage.illumSource = this.cdata;
                        } else {
                            LOGGER.info("Unknown tag: " + qName);
                        }
                    }
                }
            }
        }
        this.cdata = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        String s = new String(ch, start, length);
        this.cdata = this.cdata == null ? s : this.cdata + s;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.cdata = null;
        if (qName.equals("scn")) {
            String ns = attributes.getValue("xmlns");
            if (ns == null) {
                throw new SAXException("Invalid Leica SCN XML");
            }
            if (!ns.equals("http://www.leica-microsystems.com/scn/2010/03/10") && !ns.equals("http://www.leica-microsystems.com/scn/2010/10/01")) {
                LOGGER.warn("Unknown Leica SCN XML schema: " + ns + "; this file may not be read correctly: please report this");
            }
            this.valid = true;
            this.collections = new ArrayList();
            this.seriesIndex = 0;
        }
        if (!this.valid) {
            throw new SAXException("Invalid Leica SCN XML");
        }
        if (qName.equals("collection")) {
            ImageCollection c = new ImageCollection(attributes);
            this.collections.add(c);
            this.currentCollection = c;
            if (this.collections.size() != 1) {
                throw new SAXException("Invalid Leica SCN XML: Only a single collection is permitted");
            }
        } else if (qName.equals("image")) {
            Image i = new Image(attributes);
            this.currentCollection.images.add(i);
            this.currentImage = i;
        } else if (!qName.equals("creationDate")) {
            if (qName.equals("device")) {
                this.currentImage.devModel = attributes.getValue("model");
                this.currentImage.devVersion = attributes.getValue("version");
            } else if (qName.equals("pixels")) {
                if (this.currentImage.pixels != null) throw new SAXException("Invalid Leica SCN XML: Multiple pixels elements for single image");
                this.currentImage.pixels = new Pixels(attributes);
            } else if (qName.equals("dimension")) {
                Dimension d = new Dimension(attributes);
                this.currentImage.pixels.dims.add(d);
                this.currentDimension = d;
            } else if (qName.equals("view")) {
                this.currentImage.setView(attributes);
            } else if (qName.equals("scanSettings") || qName.equals("objectiveSettings") || qName.equals("objective") || qName.equals("illuminationSettings") || qName.equals("numericalAperture") || qName.equals("illuminationSource")) {
                // empty if block
            }
        }
        this.nameStack.push(qName);
    }

    int count() {
        return this.seriesIndex;
    }

    public class Dimension {
        long sizeX = 0L;
        long sizeY = 0L;
        int z = 0;
        int c = 0;
        int r = 0;
        int ifd = 0;

        Dimension(Attributes attrs) {
            String s = attrs.getValue("r");
            if (s != null) {
                this.r = Integer.parseInt(s);
            }
            if ((s = attrs.getValue("z")) != null) {
                this.z = Integer.parseInt(s);
            }
            if ((s = attrs.getValue("c")) != null) {
                this.c = Integer.parseInt(s);
            }
            if ((s = attrs.getValue("sizeX")) != null) {
                this.sizeX = Long.parseLong(s);
            }
            if ((s = attrs.getValue("sizeY")) != null) {
                this.sizeY = Long.parseLong(s);
            }
            if ((s = attrs.getValue("ifd")) != null) {
                this.ifd = Integer.parseInt(s);
            }
        }
    }

    public class Pixels {
        ArrayList<Dimension> dims = new ArrayList();
        String dataOrder = "XYCZT";
        long sizeX;
        long sizeY;
        int sizeZ;
        int sizeC;
        int sizeR;
        int lastIFD;
        long[][][] dimSizeX;
        long[][][] dimSizeY;
        int[][][] dimIFD;

        Pixels(Attributes attrs) {
            String s = attrs.getValue("sizeX");
            if (s != null) {
                this.sizeX = Long.parseLong(s);
            }
            if ((s = attrs.getValue("sizeY")) != null) {
                this.sizeY = Long.parseLong(s);
            }
        }
    }

    public class Image {
        int imageNumStart;
        int imageNumEnd;
        int imageThumbnail;
        long thumbSizeX;
        String name;
        String uuid;
        String creationDate;
        String devModel;
        String devVersion;
        Pixels pixels;
        long vSizeX;
        long vSizeY;
        long vOffsetX;
        long vOffsetY;
        long vSpacingZ;
        String objMag;
        String illumNA;
        String illumSource;

        Image(Attributes attrs) {
            this.name = attrs.getValue("name");
            this.uuid = attrs.getValue("uuid");
        }

        void setView(Attributes attrs) {
            String s = attrs.getValue("sizeX");
            if (s != null) {
                this.vSizeX = Long.parseLong(s);
            }
            if ((s = attrs.getValue("sizeY")) != null) {
                this.vSizeY = Long.parseLong(s);
            }
            if ((s = attrs.getValue("offsetX")) != null) {
                this.vOffsetX = Long.parseLong(s);
            }
            if ((s = attrs.getValue("offsetY")) != null) {
                this.vOffsetY = Long.parseLong(s);
            }
            if ((s = attrs.getValue("spacingZ")) != null) {
                this.vSpacingZ = Long.parseLong(s);
            }
        }
    }

    public class ImageCollection {
        String name;
        String uuid;
        long sizeX;
        long sizeY;
        String barcode;
        String ocr;
        ArrayList<Image> images;

        ImageCollection(Attributes attrs) {
            this.name = attrs.getValue("name");
            this.uuid = attrs.getValue("uuid");
            String s = attrs.getValue("sizeX");
            if (s != null) {
                this.sizeX = Long.parseLong(s);
            }
            if ((s = attrs.getValue("sizeY")) != null) {
                this.sizeY = Long.parseLong(s);
            }
            this.barcode = attrs.getValue("barcode");
            this.ocr = attrs.getValue("ocr");
            this.images = new ArrayList();
        }
    }
}

