/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.HashMap;
import loci.common.RandomAccessInputStream;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.LeicaSCNHandler;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffParser;
import ome.xml.model.enums.IlluminationType;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.helpers.DefaultHandler;

public class LeicaSCNReader
extends BaseTiffReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeicaSCNReader.class);
    LeicaSCNHandler handler;

    public LeicaSCNReader() {
        super("Leica SCN", new String[]{"scn"});
        this.domains = new String[]{"Histology"};
        this.suffixNecessary = false;
        this.suffixSufficient = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isThisType(String name, boolean open) {
        boolean isThisType = super.isThisType(name, open);
        if (!isThisType) return false;
        if (!open) return false;
        isThisType = false;
        RandomAccessInputStream stream = null;
        try {
            stream = new RandomAccessInputStream(name);
            TiffParser tiffParser = new TiffParser(stream);
            if (!tiffParser.isValidHeader()) {
                isThisType = false;
                return isThisType;
            } else {
                String imageDescription = tiffParser.getComment();
                if (imageDescription == null) return isThisType;
                try {
                    LeicaSCNHandler handler = new LeicaSCNHandler();
                    XMLTools.parseXML(imageDescription, (DefaultHandler)handler);
                    isThisType = true;
                    return isThisType;
                }
                catch (Exception se) {
                    isThisType = false;
                }
            }
            return isThisType;
        }
        catch (IOException e) {
            LOGGER.debug("I/O exception during isThisType() evaluation.", e);
            isThisType = false;
            return isThisType;
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                LOGGER.debug("I/O exception during stream closure.", e);
            }
        }
    }

    private int imageIFD(int no) {
        int s = this.getCoreIndex();
        LeicaSCNHandler.Image i = this.handler.imageMap.get(s);
        CoreMetadata ms = (CoreMetadata)this.core.get(s);
        int[] dims = FormatTools.getZCTCoords(ms.dimensionOrder, ms.sizeZ, ms.imageCount / (ms.sizeZ * ms.sizeT), ms.sizeT, ms.imageCount, no);
        int dz = dims[0];
        int dc = dims[1];
        int dr = this.getCoreIndex() - i.imageNumStart;
        return i.pixels.dimIFD[dz][dc][dr];
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        int ifd = this.imageIFD(no);
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.tiffParser.getSamples((IFD)this.ifds.get(ifd), buf, x, y, w, h);
        return buf;
    }

    @Override
    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        int originalIndex = this.getCoreIndex();
        LeicaSCNHandler.Image i = this.handler.imageMap.get(this.getCoreIndex());
        int thumbseries = i.imageNumStart + i.imageThumbnail;
        this.setCoreIndex(thumbseries);
        byte[] thumb = FormatTools.openThumbBytes(this, no);
        this.setCoreIndex(originalIndex);
        return thumb;
    }

    @Override
    public int getThumbSizeX() {
        int originalIndex = this.getCoreIndex();
        LeicaSCNHandler.Image i = this.handler.imageMap.get(this.getCoreIndex());
        int thumbseries = i.imageNumStart + i.imageThumbnail;
        this.setCoreIndex(thumbseries);
        int size = super.getThumbSizeX();
        this.setCoreIndex(originalIndex);
        return size;
    }

    @Override
    public int getThumbSizeY() {
        int originalIndex = this.getCoreIndex();
        LeicaSCNHandler.Image i = this.handler.imageMap.get(this.getCoreIndex());
        int thumbseries = i.imageNumStart + i.imageThumbnail;
        this.setCoreIndex(thumbseries);
        int size = super.getThumbSizeY();
        this.setCoreIndex(originalIndex);
        return size;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        this.handler = null;
        if (!fileOnly) {
            // empty if block
        }
    }

    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            return (int)((IFD)this.ifds.get(this.imageIFD(0))).getTileWidth();
        }
        catch (FormatException e) {
            LOGGER.debug("", e);
            return super.getOptimalTileWidth();
        }
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            return (int)((IFD)this.ifds.get(this.imageIFD(0))).getTileLength();
        }
        catch (FormatException e) {
            LOGGER.debug("", e);
            return super.getOptimalTileHeight();
        }
    }

    protected void initCoreMetadata(int s) throws FormatException, IOException {
        LeicaSCNHandler.ImageCollection c = this.handler.collectionMap.get(s);
        LeicaSCNHandler.Image i = this.handler.imageMap.get(s);
        if (c == null || i == null || i.imageNumStart > s || i.imageNumEnd < s) {
            throw new FormatException("Error setting core metadata for image number " + s);
        }
        int r = s - i.imageNumStart;
        IFD ifd = (IFD)this.ifds.get(i.pixels.dimIFD[0][0][r]);
        PhotoInterp pi = ifd.getPhotometricInterpretation();
        int samples = ifd.getSamplesPerPixel();
        CoreMetadata ms = (CoreMetadata)this.core.get(s);
        if (s == i.imageNumStart) {
            ms.resolutionCount = i.pixels.sizeR;
        }
        ms.rgb = samples > 1 || pi == PhotoInterp.RGB;
        ms.sizeX = (int)i.pixels.dimSizeX[0][0][r];
        ms.sizeY = (int)i.pixels.dimSizeY[0][0][r];
        ms.sizeZ = i.pixels.sizeZ;
        ms.sizeT = 1;
        int n = ms.sizeC = ms.rgb ? samples : i.pixels.sizeC;
        if (ifd.getImageWidth() != (long)ms.sizeX || ifd.getImageLength() != (long)ms.sizeY) {
            throw new FormatException("IFD dimensions do not match XML dimensions for image number " + s + ": x=" + ifd.getImageWidth() + ", " + ms.sizeX + ", y=" + ifd.getImageLength() + ", " + ms.sizeY);
        }
        ms.orderCertain = true;
        ms.littleEndian = ifd.isLittleEndian();
        ms.indexed = pi == PhotoInterp.RGB_PALETTE && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
        ms.imageCount = i.pixels.sizeZ * i.pixels.sizeC;
        ms.pixelType = ifd.getPixelType();
        ms.metadataComplete = true;
        ms.interleaved = false;
        ms.falseColor = false;
        ms.dimensionOrder = i.pixels.dataOrder;
        ms.thumbnail = i.imageThumbnail == r;
    }

    @Override
    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        this.tiffParser.setDoCaching(true);
        String imageDescription = this.tiffParser.getComment();
        this.handler = new LeicaSCNHandler();
        if (imageDescription != null) {
            try {
                XMLTools.parseXML(imageDescription, (DefaultHandler)this.handler);
            }
            catch (Exception se) {
                throw new FormatException("Failed to parse XML", se);
            }
        }
        int count = this.handler.count();
        this.ifds = this.tiffParser.getIFDs();
        this.core.clear();
        for (int i = 0; i < count; ++i) {
            CoreMetadata ms = new CoreMetadata();
            this.core.add(ms);
            this.tiffParser.fillInIFD((IFD)this.ifds.get(this.handler.IFDMap.get(i)));
            this.initCoreMetadata(i);
        }
        this.setSeries(0);
    }

    @Override
    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        HashMap<String, String> instruments = new HashMap<String, String>();
        HashMap<String, Integer> instrumentIDs = new HashMap<String, Integer>();
        int instrumentidno = 0;
        HashMap<String, String> objectives = new HashMap<String, String>();
        HashMap<String, Integer> objectiveIDs = new HashMap<String, Integer>();
        int objectiveidno = 0;
        for (int s = 0; s < this.getSeriesCount(); ++s) {
            LeicaSCNHandler.ImageCollection c = this.handler.collectionMap.get(s);
            LeicaSCNHandler.Image i = this.handler.imageMap.get(s);
            int r = s - i.imageNumStart;
            double sizeX = (double)i.vSizeX / 1000.0;
            double sizeY = (double)i.vSizeY / 1000.0;
            double offsetX = (double)i.vOffsetX / 1000.0;
            double offsetY = (double)i.vOffsetY / 1000.0;
            double sizeZ = (double)i.vSpacingZ / 1000.0;
            store.setPixelsPhysicalSizeX(new PositiveFloat(sizeX / (double)i.pixels.dimSizeX[0][0][r]), s);
            store.setPixelsPhysicalSizeY(new PositiveFloat(sizeY / (double)i.pixels.dimSizeY[0][0][r]), s);
            if (sizeZ > 0.0) {
                store.setPixelsPhysicalSizeZ(new PositiveFloat(sizeZ), s);
            }
            if (instruments.get(i.devModel) == null) {
                String instrumentID = MetadataTools.createLSID("Instrument", instrumentidno);
                instruments.put(i.devModel, instrumentID);
                instrumentIDs.put(i.devModel, new Integer(instrumentidno));
                store.setInstrumentID(instrumentID, instrumentidno);
                ++instrumentidno;
            }
            if (objectives.get(i.devModel + ":" + i.objMag) == null) {
                int inst = (Integer)instrumentIDs.get(i.devModel);
                String objectiveID = MetadataTools.createLSID("Objective", inst, objectiveidno);
                objectives.put(i.devModel + ":" + i.objMag, objectiveID);
                objectiveIDs.put(i.devModel + ":" + i.objMag, new Integer(objectiveidno));
                store.setObjectiveID(objectiveID, inst, objectiveidno);
                Double mag = Double.parseDouble(i.objMag);
                store.setObjectiveNominalMagnification(mag, inst, objectiveidno);
                store.setObjectiveCalibratedMagnification(mag, inst, objectiveidno);
                store.setObjectiveLensNA(new Double(i.illumNA), inst, objectiveidno);
                ++objectiveidno;
            }
            store.setImageInstrumentRef((String)instruments.get(i.devModel), s);
            store.setObjectiveSettingsID((String)objectives.get(i.devModel + ":" + i.objMag), s);
            String channelID = MetadataTools.createLSID("Channel", s);
            store.setChannelID(channelID, s, 0);
            if (i.illumSource.equals("brightfield")) {
                store.setChannelIlluminationType(IlluminationType.TRANSMITTED, s, 0);
            } else {
                store.setChannelIlluminationType(IlluminationType.OTHER, s, 0);
                LOGGER.debug("Unknown illumination source {}; please report this", (Object)i.illumSource);
            }
            CoreMetadata ms = (CoreMetadata)this.core.get(s);
            for (int q = 0; q < ms.imageCount; ++q) {
                int[] dims = FormatTools.getZCTCoords(ms.dimensionOrder, ms.sizeZ, ms.imageCount / (ms.sizeZ * ms.sizeT), ms.sizeT, ms.imageCount, q);
                store.setPlaneTheZ(new NonNegativeInteger(dims[0]), s, q);
                store.setPlaneTheC(new NonNegativeInteger(dims[1]), s, q);
                store.setPlaneTheT(new NonNegativeInteger(dims[2]), s, q);
                store.setPlanePositionX(offsetX, s, q);
                store.setPlanePositionY(offsetY, s, q);
            }
            store.setImageName(i.name + " (R" + (s - i.imageNumStart) + ")", s);
            store.setImageDescription("Collection " + c.name, s);
            store.setImageAcquisitionDate(new Timestamp(i.creationDate), s);
            this.addGlobalMeta("collection.name", c.name);
            this.addGlobalMeta("collection.uuid", c.uuid);
            this.addGlobalMeta("collection.barcode", c.barcode);
            this.addGlobalMeta("collection.ocr", c.ocr);
            this.addGlobalMeta("creationDate", i.creationDate);
            this.addGlobalMetaList("device.model for image", i.devModel);
            this.addGlobalMetaList("device.version for image", i.devVersion);
            this.addGlobalMetaList("view.sizeX for image", i.vSizeX);
            this.addGlobalMetaList("view.sizeY for image", i.vSizeY);
            this.addGlobalMetaList("view.offsetX for image", i.vOffsetX);
            this.addGlobalMetaList("view.offsetY for image", i.vOffsetY);
            this.addGlobalMetaList("view.spacingZ for image", i.vSpacingZ);
            this.addGlobalMetaList("scanSettings.objectiveSettings.objective for image", i.objMag);
            this.addGlobalMetaList("scanSettings.illuminationSettings.numericalAperture for image", i.illumNA);
            this.addGlobalMetaList("scanSettings.illuminationSettings.illuminationSource for image", i.illumSource);
        }
    }
}

