/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.common.services.ServiceException;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.services.JPEGTurboService;
import loci.formats.services.JPEGTurboServiceImpl;
import loci.formats.tiff.IFD;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffIFDEntry;
import loci.formats.tiff.TiffParser;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.Timestamp;

public class NDPIReader
extends BaseTiffReader {
    private static final int MAX_SIZE = 2048;
    private static final int MARKER_TAG = 65426;
    private static final int THUMB_TAG_2 = 65439;
    private static final int METADATA_TAG = 65449;
    private int initializedSeries = -1;
    private int initializedPlane = -1;
    private int sizeZ = 1;
    private int pyramidHeight = 1;
    private JPEGTurboService service = new JPEGTurboServiceImpl();

    public NDPIReader() {
        super("Hamamatsu NDPI", new String[]{"ndpi"});
        this.domains = new String[]{"Histology"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isThisType(String name, boolean open) {
        boolean isThisType = super.isThisType(name, open);
        if (isThisType && open) {
            RandomAccessInputStream stream = null;
            TiffParser parser = null;
            try {
                stream = new RandomAccessInputStream(name);
                parser = new TiffParser(stream);
                parser.setDoCaching(false);
                parser.setUse64BitOffsets((double)stream.length() >= Math.pow(2.0, 32.0));
                if (!parser.isValidHeader()) {
                    boolean bl = false;
                    return bl;
                }
                IFD ifd = parser.getFirstIFD();
                if (ifd == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = ifd.containsKey(65426);
                return bl;
            }
            catch (IOException e) {
                LOGGER.debug("I/O exception during isThisType() evaluation.", e);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                    if (parser != null) {
                        parser.getStream().close();
                    }
                }
                catch (IOException e) {
                    LOGGER.debug("I/O exception during stream closure.", e);
                }
            }
        }
        return isThisType;
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (x == 0 && y == 0 && w == 1 && h == 1) {
            return buf;
        }
        if (this.getSizeX() <= 2048 || this.getSizeY() <= 2048) {
            int ifdIndex = this.getIFDIndex(this.getCoreIndex(), no);
            this.in = new RandomAccessInputStream(this.currentId);
            this.tiffParser = new TiffParser(this.in);
            this.tiffParser.setUse64BitOffsets(true);
            this.tiffParser.setYCbCrCorrection(false);
            byte[] b = this.tiffParser.getSamples((IFD)this.ifds.get(ifdIndex), buf, x, y, w, h);
            this.in.close();
            this.tiffParser.getStream().close();
            return b;
        }
        if (this.initializedSeries != this.getCoreIndex() || this.initializedPlane != no) {
            IFD ifd = (IFD)this.ifds.get(this.getIFDIndex(this.getCoreIndex(), no));
            long offset = ifd.getStripOffsets()[0];
            long byteCount = ifd.getStripByteCounts()[0];
            if (this.in != null) {
                this.in.close();
            }
            this.in = new RandomAccessInputStream(this.currentId);
            this.in.seek(offset);
            this.in.setLength(offset + byteCount);
            try {
                this.service.close();
                long[] markers = ifd.getIFDLongArray(65426);
                if (markers != null) {
                    this.service.setRestartMarkers(markers);
                }
                this.service.initialize(this.in, this.getSizeX(), this.getSizeY());
            }
            catch (ServiceException e) {
                throw new FormatException(e);
            }
            this.initializedSeries = this.getCoreIndex();
            this.initializedPlane = no;
        }
        this.service.getTile(buf, x, y, w, h);
        return buf;
    }

    @Override
    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        int currentSeries = this.getSeries();
        if (this.getCoreIndex() >= this.pyramidHeight) {
            return super.openThumbBytes(no);
        }
        int thumbX = this.getThumbSizeX();
        int thumbY = this.getThumbSizeY();
        int rgbCount = this.getRGBChannelCount();
        if (this.hasFlattenedResolutions()) {
            this.setSeries(this.pyramidHeight - 1);
        } else {
            this.setResolution(this.pyramidHeight - 1);
        }
        byte[] thumb = null;
        if (thumbX == this.getThumbSizeX() && thumbY == this.getThumbSizeY() && rgbCount == this.getRGBChannelCount()) {
            thumb = FormatTools.openThumbBytes(this, no);
            this.setSeries(currentSeries);
            this.setResolution(0);
        } else {
            for (int s = this.getSeriesCount() - 1; s >= 0; --s) {
                this.setSeries(s);
                if (thumbX != this.getThumbSizeX() || thumbY != this.getThumbSizeY() || s == currentSeries || rgbCount != this.getRGBChannelCount()) continue;
                thumb = FormatTools.openThumbBytes(this, no);
                break;
            }
            this.setSeries(currentSeries);
            if (thumb == null) {
                thumb = FormatTools.openThumbBytes(this, no);
            }
        }
        return thumb;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        if (!fileOnly) {
            this.service.close();
            this.initializedSeries = -1;
            this.initializedPlane = -1;
            this.sizeZ = 1;
            this.pyramidHeight = 1;
            if (this.tiffParser != null) {
                this.tiffParser.getStream().close();
            }
        }
        super.close(fileOnly);
    }

    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        return 1024;
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        return 1024;
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        RandomAccessInputStream s = new RandomAccessInputStream(id);
        this.use64Bit = (double)s.length() >= Math.pow(2.0, 32.0);
        s.close();
        super.initFile(id);
    }

    @Override
    protected void initStandardMetadata() throws FormatException, IOException {
        int s;
        int i;
        super.initStandardMetadata();
        this.ifds = this.tiffParser.getIFDs();
        RandomAccessInputStream stream = new RandomAccessInputStream(this.currentId);
        for (i = 0; i < this.ifds.size(); ++i) {
            long[] stripOffsets = ((IFD)this.ifds.get(i)).getStripOffsets();
            boolean neededAdjustment = false;
            for (int j = 0; j < stripOffsets.length; ++j) {
                long prevOffset = i == 0 ? 0L : ((IFD)this.ifds.get(i - 1)).getStripOffsets()[0];
                long prevByteCount = i == 0 ? 0L : ((IFD)this.ifds.get(i - 1)).getStripByteCounts()[0];
                long newOffset = stripOffsets[j] + 0x100000000L;
                if (newOffset >= stream.length() || (j <= 0 || stripOffsets[j] >= stripOffsets[j - 1]) && (i <= 0 || stripOffsets[j] >= prevOffset + prevByteCount)) continue;
                stripOffsets[j] = newOffset;
                neededAdjustment = true;
            }
            if (neededAdjustment) {
                ((IFD)this.ifds.get(i)).putIFDValue(273, stripOffsets);
            }
            neededAdjustment = false;
            long[] stripByteCounts = ((IFD)this.ifds.get(i)).getStripByteCounts();
            for (int j = 0; j < stripByteCounts.length; ++j) {
                long newByteCount = stripByteCounts[j] + 0x100000000L;
                if (stripByteCounts[j] >= 0L && !neededAdjustment && newByteCount + ((IFD)this.ifds.get(i)).getStripOffsets()[0] >= this.in.length()) continue;
                stripByteCounts[j] = newByteCount;
                neededAdjustment = true;
            }
            if (!neededAdjustment) continue;
            ((IFD)this.ifds.get(i)).putIFDValue(279, stripByteCounts);
        }
        stream.close();
        for (i = 1; i < this.ifds.size(); ++i) {
            IFD ifd = (IFD)this.ifds.get(i);
            if (ifd.getImageWidth() == ((IFD)this.ifds.get(0)).getImageWidth() && ifd.getImageLength() == ((IFD)this.ifds.get(0)).getImageLength()) {
                ++this.sizeZ;
                continue;
            }
            if (this.sizeZ != 1 || i >= this.ifds.size() - 1) continue;
            ++this.pyramidHeight;
        }
        int seriesCount = this.pyramidHeight + (this.ifds.size() - this.pyramidHeight * this.sizeZ);
        long prevMarkerOffset = 0L;
        for (int i2 = 0; i2 < this.ifds.size(); ++i2) {
            IFD ifd = (IFD)this.ifds.get(i2);
            ifd.remove(65439);
            this.ifds.set(i2, ifd);
            TiffIFDEntry markerTag = (TiffIFDEntry)ifd.get(65426);
            if (markerTag != null) {
                if (markerTag.getValueOffset() > this.in.length()) {
                    long markerOffset = markerTag.getValueOffset() & 0xFFFFFFFFL;
                    if (markerOffset < prevMarkerOffset || this.use64Bit && i2 == 0 && markerOffset < this.in.length() / 2L) {
                        markerOffset += 0x100000000L;
                    }
                    markerTag = new TiffIFDEntry(markerTag.getTag(), markerTag.getType(), markerTag.getValueCount(), markerOffset);
                    prevMarkerOffset = markerOffset;
                }
                Object value = this.tiffParser.getIFDValue(markerTag);
                ((IFD)this.ifds.get(i2)).putIFDValue(65426, value);
            }
            this.tiffParser.fillInIFD((IFD)this.ifds.get(i2));
            int[] bpp = ((IFD)this.ifds.get(i2)).getBitsPerSample();
            for (int q = 0; q < bpp.length; ++q) {
                if (bpp[q] >= 8) continue;
                bpp[q] = 8;
            }
            ((IFD)this.ifds.get(i2)).putIFDValue(258, bpp);
        }
        this.core.clear();
        for (s = 0; s < seriesCount; ++s) {
            CoreMetadata ms = new CoreMetadata();
            this.core.add(ms);
            if (s != 0) continue;
            ms.resolutionCount = this.pyramidHeight;
        }
        for (s = 0; s < this.core.size(); ++s) {
            IFD ifd = (IFD)this.ifds.get(this.getIFDIndex(s, 0));
            PhotoInterp p = ifd.getPhotometricInterpretation();
            int samples = ifd.getSamplesPerPixel();
            CoreMetadata ms = (CoreMetadata)this.core.get(s);
            ms.rgb = samples > 1 || p == PhotoInterp.RGB;
            ms.sizeX = (int)ifd.getImageWidth();
            ms.sizeY = (int)ifd.getImageLength();
            ms.sizeZ = s < this.pyramidHeight ? this.sizeZ : 1;
            ms.sizeT = 1;
            ms.sizeC = ms.rgb ? samples : 1;
            ms.littleEndian = ifd.isLittleEndian();
            ms.indexed = p == PhotoInterp.RGB_PALETTE && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
            ms.imageCount = ms.sizeZ * ms.sizeT;
            ms.pixelType = ifd.getPixelType();
            ms.metadataComplete = true;
            ms.interleaved = ms.sizeX > 2048 && ms.sizeY > 2048;
            ms.falseColor = false;
            ms.dimensionOrder = "XYCZT";
            ms.thumbnail = s != 0;
        }
    }

    @Override
    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            store.setImageName("Series " + (i + 1), i);
            if (i <= 0) continue;
            int ifdIndex = this.getIFDIndex(i, 0);
            String creationDate = ((IFD)this.ifds.get(ifdIndex)).getIFDTextValue(306);
            if ((creationDate = DateTools.formatDate(creationDate, DATE_FORMATS)) != null) {
                store.setImageAcquisitionDate(new Timestamp(creationDate), i);
            }
            double xResolution = ((IFD)this.ifds.get(ifdIndex)).getXResolution();
            double yResolution = ((IFD)this.ifds.get(ifdIndex)).getYResolution();
            PositiveFloat sizeX = FormatTools.getPhysicalSizeX(xResolution);
            PositiveFloat sizeY = FormatTools.getPhysicalSizeY(yResolution);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, i);
            }
            if (sizeY == null) continue;
            store.setPixelsPhysicalSizeY(sizeY, i);
        }
    }

    private int getIFDIndex(int seriesIndex, int zIndex) {
        if (seriesIndex < this.pyramidHeight) {
            return zIndex * this.pyramidHeight + seriesIndex;
        }
        return this.sizeZ * this.pyramidHeight + (seriesIndex - this.pyramidHeight);
    }
}

