/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import loci.common.ByteArrayHandle;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.MetadataTools;
import loci.formats.codec.Codec;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEG2000Codec;
import loci.formats.codec.ZlibCodec;
import loci.formats.in.MetadataLevel;
import loci.formats.in.ND2Handler;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import org.xml.sax.helpers.DefaultHandler;

public class NativeND2Reader
extends FormatReader {
    public static final long ND2_MAGIC_BYTES_1 = 3670982154L;
    public static final long ND2_MAGIC_BYTES_2 = 1783636000L;
    private static final int BUFFER_SIZE = 32768;
    private long[][] offsets;
    private boolean isJPEG;
    private Codec codec;
    private boolean isLossless;
    private ArrayList<Double> tsT = new ArrayList();
    private int fieldIndex;
    private long xOffset;
    private long yOffset;
    private long zOffset;
    private ArrayList<Double> posX;
    private ArrayList<Double> posY;
    private ArrayList<Double> posZ;
    private ArrayList<Double> exposureTime = new ArrayList();
    private Hashtable<String, Integer> channelColors;
    private boolean split = false;
    private int lastChannel = 0;
    private int[] colors;
    private Boolean useZ = null;
    private int nXFields;
    private ND2Handler backupHandler;
    private double trueSizeX = 0.0;
    private double trueSizeY = 0.0;
    private double trueSizeZ = 0.0;
    private ArrayList<String> textChannelNames = new ArrayList();
    private ArrayList<Integer> textEmissionWavelengths = new ArrayList();
    private boolean textData = false;
    private Double refractiveIndex = null;

    public NativeND2Reader() {
        super("Nikon ND2", new String[]{"nd2", "jp2"});
        this.suffixSufficient = false;
        this.domains = new String[]{"Light Microscopy"};
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 8;
        if (!FormatTools.validStream(stream, 8, false)) {
            return false;
        }
        long magic1 = (long)stream.readInt() & 0xFFFFFFFFL;
        long magic2 = (long)stream.readInt() & 0xFFFFFFFFL;
        return magic1 == 3670982154L || magic2 == 1783636000L;
    }

    @Override
    public byte[][] get8BitLookupTable() {
        if (FormatTools.getBytesPerPixel(this.getPixelType()) != 1 || !this.isIndexed() || this.lastChannel < 0 || this.lastChannel >= this.colors.length) {
            return null;
        }
        int color = this.colors[this.lastChannel];
        if (color == 0) {
            return null;
        }
        byte[][] lut = new byte[3][256];
        int index = -1;
        if (color > 0 && color < 256) {
            index = 0;
        } else if (color >= 256 && color < 65280) {
            index = 1;
        } else if (color > 65280 && color <= 0xFF0000) {
            index = 2;
        }
        for (int i = 0; i < 256; ++i) {
            if (index == -1) {
                lut[0][i] = (byte)i;
                lut[1][i] = (byte)i;
                lut[2][i] = (byte)i;
                continue;
            }
            lut[index][i] = (byte)i;
        }
        return lut;
    }

    @Override
    public short[][] get16BitLookupTable() {
        if (FormatTools.getBytesPerPixel(this.getPixelType()) != 2 || !this.isIndexed() || this.lastChannel < 0 || this.lastChannel >= this.colors.length) {
            return null;
        }
        int color = this.colors[this.lastChannel];
        if (color == 0) {
            return null;
        }
        short[][] lut = new short[3][65536];
        int index = -1;
        if (color > 0 && color < 256) {
            index = 0;
        } else if (color >= 256 && color <= 65280) {
            index = 1;
        } else if (color > 65280 && color <= 0xFF0000) {
            index = 2;
        }
        for (int i = 0; i < 65536; ++i) {
            if (index == -1) {
                lut[0][i] = (short)i;
                lut[1][i] = (short)i;
                lut[2][i] = (short)i;
                continue;
            }
            lut[index][i] = (short)i;
        }
        return lut;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.lastChannel = this.split ? no % this.getSizeC() : 0;
        int planeIndex = this.split ? no / this.getSizeC() : no;
        this.in.seek(this.offsets[this.getSeries()][planeIndex]);
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int pixel = bpp * this.getRGBChannelCount();
        if (this.split) {
            pixel *= this.getSizeC();
        }
        int totalPlanes = this.split ? this.getImageCount() / this.getSizeC() : this.getImageCount();
        long maxFP = planeIndex == totalPlanes - 1 ? this.in.length() : this.offsets[this.getSeries()][planeIndex + 1];
        CodecOptions options = new CodecOptions();
        options.littleEndian = this.isLittleEndian();
        options.interleaved = this.isInterleaved();
        options.maxBytes = (int)maxFP;
        int scanlinePad = this.getScanlinePad();
        if (this.isJPEG || this.isLossless) {
            if (this.codec == null) {
                this.codec = this.createCodec(this.isJPEG);
            }
            byte[] t = null;
            try {
                t = this.codec.decompress(this.in, options);
            }
            catch (IOException e) {
                LOGGER.debug("Failed to decompress; plane may be corrupt", e);
                return buf;
            }
            if ((this.getSizeX() + scanlinePad) * this.getSizeY() * pixel > t.length) {
                int rowLength = this.getSizeX() * pixel + scanlinePad * bpp;
                int destLength = w * pixel;
                int p = rowLength * y + x * pixel;
                byte[] pix = new byte[destLength * h];
                for (int row = 0; row < h && p + destLength <= t.length; ++row) {
                    System.arraycopy(t, p, pix, row * destLength, destLength);
                    int skip = pixel * (this.getSizeX() - w - x) + scanlinePad * bpp;
                    p += destLength + skip;
                }
                if (this.split) {
                    pix = ImageTools.splitChannels(pix, this.lastChannel, this.getEffectiveSizeC(), bpp, false, true);
                }
                System.arraycopy(pix, 0, buf, 0, pix.length);
            } else {
                this.copyPixels(x, y, w, h, bpp, scanlinePad, t, buf, this.split);
            }
            t = null;
        } else if (this.split && (this.getSizeC() <= 4 || scanlinePad == 0) && this.nXFields == 1) {
            byte[] pix = new byte[(this.getSizeX() + scanlinePad) * this.getSizeY() * pixel];
            this.in.read(pix);
            this.copyPixels(x, y, w, h, bpp, scanlinePad, pix, buf, this.split);
            pix = null;
        } else if (this.split) {
            int rowLength = this.getSizeX() * pixel + scanlinePad * bpp;
            int destLength = w * pixel;
            this.in.skipBytes(rowLength * y);
            byte[] pix = new byte[destLength * h];
            for (int row = 0; row < h; ++row) {
                this.in.skipBytes(x * pixel);
                this.in.read(pix, row * destLength, destLength);
                this.in.skipBytes(pixel * (this.getSizeX() - w - x) + scanlinePad * bpp);
            }
            pix = ImageTools.splitChannels(pix, this.lastChannel, this.getEffectiveSizeC(), bpp, false, true);
            System.arraycopy(pix, 0, buf, 0, pix.length);
        } else {
            this.readPlane(this.in, x, y, w, h, scanlinePad, buf);
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.offsets = null;
            this.isLossless = false;
            this.isJPEG = false;
            this.codec = null;
            this.tsT.clear();
            this.fieldIndex = 0;
            this.zOffset = 0L;
            this.yOffset = 0L;
            this.xOffset = 0L;
            this.posZ = null;
            this.posY = null;
            this.posX = null;
            this.channelColors = null;
            this.split = false;
            this.nXFields = 0;
            this.backupHandler = null;
            this.trueSizeX = 0.0;
            this.trueSizeY = 0.0;
            this.trueSizeZ = 0.0;
            this.textChannelNames.clear();
            this.textEmissionWavelengths.clear();
            this.useZ = null;
            this.textData = false;
            this.refractiveIndex = null;
            this.exposureTime.clear();
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        int i;
        int numBands;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id, 32768);
        this.channelColors = new Hashtable();
        if (this.in.read() == -38 && this.in.read() == -50) {
            int i2;
            int i3;
            int rowSize;
            long sizeY;
            int numSeries;
            LOGGER.info("Searching for blocks");
            this.isJPEG = false;
            this.in.seek(0L);
            this.in.order(true);
            ArrayList<String> imageNames = new ArrayList<String>();
            ArrayList<Long> imageOffsets = new ArrayList<Long>();
            ArrayList<int[]> imageLengths = new ArrayList<int[]>();
            ArrayList<Long> customDataOffsets = new ArrayList<Long>();
            ArrayList<int[]> customDataLengths = new ArrayList<int[]>();
            ArrayList<String> textStrings = new ArrayList<String>();
            ArrayList<Boolean> validDimensions = new ArrayList<Boolean>();
            ByteArrayHandle xml = new ByteArrayHandle();
            StringBuffer name = new StringBuffer();
            int extraZDataCount = 0;
            boolean foundMetadata = false;
            boolean useLastText = false;
            int blockCount = 0;
            byte[] sigBytes = new byte[]{-38, -50, -66, 10};
            byte[] buf = new byte[32768];
            while (this.in.getFilePointer() < this.in.length() - 1L && this.in.getFilePointer() >= 0L) {
                int foundIndex = -1;
                this.in.read(buf, 0, sigBytes.length);
                while (foundIndex == -1 && this.in.getFilePointer() < this.in.length()) {
                    int n = this.in.read(buf, sigBytes.length, buf.length - sigBytes.length);
                    for (int i4 = 0; i4 < buf.length - sigBytes.length; ++i4) {
                        for (int j = 0; j < sigBytes.length && buf[i4 + j] == sigBytes[j]; ++j) {
                            if (j != sigBytes.length - 1) continue;
                            foundIndex = i4;
                        }
                        if (foundIndex != -1) break;
                    }
                    if (foundIndex == -1) {
                        buf[0] = buf[buf.length - 4];
                        buf[1] = buf[buf.length - 3];
                        buf[2] = buf[buf.length - 2];
                        buf[3] = buf[buf.length - 1];
                        continue;
                    }
                    if (this.in.getFilePointer() - (long)n + (long)foundIndex >= this.in.length()) continue;
                    this.in.seek(this.in.getFilePointer() - (long)n + (long)foundIndex);
                }
                if (this.in.getFilePointer() > this.in.length() - 24L || foundIndex == -1) break;
                Long helper = this.in.getFilePointer();
                int nameLength = this.in.readInt();
                long dataLength = this.in.readLong();
                String nameAttri = this.in.readString(nameLength).trim();
                Long stop = helper + (dataLength + (long)nameLength);
                boolean seq = false;
                if (nameAttri.contains("MetadataLV") || nameAttri.contains("CalibrationLV") || nameAttri.contains("MetadataSeqLV") && !seq) {
                    this.iterateIn(this.in, stop);
                }
                if (nameAttri.contains("MetadataSeqLV")) {
                    seq = true;
                }
                this.in.seek(helper + 12L);
                int len = (int)((long)nameLength + dataLength);
                long fp = this.in.getFilePointer();
                String blockType = this.in.readString(12);
                int percent = (int)(100L * fp / this.in.length());
                LOGGER.info("Parsing block '{}' {}%", (Object)blockType, (Object)percent);
                ++blockCount;
                int skip = len - 12 - nameLength * 2;
                if (skip <= 0) {
                    skip += nameLength * 2;
                }
                if (blockType.endsWith("Calibra")) {
                    long veryStart = this.in.getFilePointer();
                    this.in.skipBytes(12);
                    long endFP = this.in.getFilePointer() + (long)len - 24L;
                    while (this.in.read() == 0) {
                    }
                    while (this.in.getFilePointer() < endFP) {
                        int nameLen = this.in.read();
                        if (nameLen == 0) {
                            this.in.seek(this.in.getFilePointer() - 3L);
                            nameLen = this.in.read();
                        }
                        if (nameLen < 0) break;
                        String attributeName = DataTools.stripString(this.in.readString(nameLen * 2));
                        double valueOrLength = this.in.readDouble();
                        if (!attributeName.equals("dCalibration")) continue;
                        if (!(valueOrLength > 0.0)) break;
                        this.addGlobalMeta(attributeName, valueOrLength);
                        if (this.trueSizeX == 0.0) {
                            this.trueSizeX = valueOrLength;
                            break;
                        }
                        if (this.trueSizeY != 0.0) break;
                        this.trueSizeY = valueOrLength;
                        break;
                    }
                    this.in.seek(veryStart);
                }
                if (blockType.startsWith("ImageDataSeq")) {
                    if (foundMetadata) {
                        imageOffsets.clear();
                        imageNames.clear();
                        imageLengths.clear();
                        customDataOffsets.clear();
                        customDataLengths.clear();
                        foundMetadata = false;
                        extraZDataCount = 0;
                        useLastText = true;
                    }
                    imageOffsets.add(new Long(fp));
                    imageLengths.add(new int[]{nameLength, (int)dataLength, this.getSizeX() * this.getSizeY()});
                    char b = (char)this.in.readByte();
                    while (b != '!') {
                        name.append(b);
                        b = (char)this.in.readByte();
                    }
                    imageNames.add(name.toString());
                    name = name.delete(0, name.length());
                } else if (blockType.startsWith("ImageText")) {
                    foundMetadata = true;
                    this.in.skipBytes(6);
                    while (this.in.read() == 0) {
                    }
                    long startFP = this.in.getFilePointer();
                    this.in.seek(startFP - 1L);
                    String textString = DataTools.stripString(this.in.readString((int)dataLength));
                    textStrings.add(textString);
                    validDimensions.add(blockCount > 2);
                    if (!textString.startsWith("<")) {
                        skip = 0;
                    }
                } else if (blockType.startsWith("Image") || blockType.startsWith("CustomDataVa")) {
                    foundMetadata = true;
                    if (blockType.equals("ImageAttribu")) {
                        this.in.skipBytes(6);
                        long endFP = this.in.getFilePointer() + (long)len - 18L;
                        while (this.in.read() == 0) {
                        }
                        boolean canBeLossless = true;
                        while (this.in.getFilePointer() < endFP) {
                            int nameLen = this.in.read();
                            if (nameLen == 0) {
                                this.in.seek(this.in.getFilePointer() - 3L);
                                nameLen = this.in.read();
                            }
                            if (nameLen < 0) break;
                            long start = this.in.getFilePointer();
                            String attributeName = DataTools.stripString(this.in.readString(nameLen * 2));
                            if (attributeName.startsWith("xml ") || attributeName.startsWith("ml version") || attributeName.startsWith("l version") || attributeName.startsWith("version")) {
                                if (attributeName.startsWith("xml ")) {
                                    this.in.seek(start - 2L);
                                } else if (attributeName.startsWith("ml version")) {
                                    this.in.seek(start - 3L);
                                } else if (attributeName.startsWith("l version")) {
                                    this.in.seek(start - 4L);
                                } else {
                                    this.in.seek(start - 6L);
                                }
                                attributeName = this.in.readCString();
                                String xmlString = XMLTools.sanitizeXML(attributeName.trim());
                                xmlString = xmlString.substring(0, xmlString.lastIndexOf(">") + 1);
                                if (xmlString.startsWith("<?xml")) {
                                    xmlString = xmlString.substring(xmlString.indexOf(">") + 1);
                                }
                                if (!xmlString.endsWith("</variant>")) {
                                    xmlString = xmlString + "</variant>";
                                }
                                if (this.getDimensionOrder() == null) {
                                    ((CoreMetadata)this.core.get((int)0)).dimensionOrder = "";
                                }
                                try {
                                    ND2Handler handler = new ND2Handler(this.core, imageOffsets.size());
                                    XMLTools.parseXML(xmlString, (DefaultHandler)handler);
                                    xmlString = null;
                                    this.core = handler.getCoreMetadataList();
                                    if (this.backupHandler == null) {
                                        this.backupHandler = handler;
                                    }
                                }
                                catch (IOException e) {
                                    LOGGER.debug("Could not parse XML", e);
                                }
                                this.in.seek(this.in.getFilePointer() - 8L);
                                break;
                            }
                            int valueOrLength = this.in.readInt();
                            this.addGlobalMeta(attributeName, valueOrLength);
                            if (attributeName.equals("uiWidth")) {
                                ((CoreMetadata)this.core.get((int)0)).sizeX = valueOrLength;
                            } else if (attributeName.equals("uiHeight")) {
                                ((CoreMetadata)this.core.get((int)0)).sizeY = valueOrLength;
                            } else if (attributeName.equals("uiComp")) {
                                ((CoreMetadata)this.core.get((int)0)).sizeC = valueOrLength;
                            } else if (attributeName.equals("uiBpcInMemory")) {
                                ((CoreMetadata)this.core.get((int)0)).pixelType = FormatTools.pixelTypeFromBytes(valueOrLength / 8, false, false);
                            } else if (attributeName.equals("uiBpcSignificant")) {
                                ((CoreMetadata)this.core.get((int)0)).bitsPerPixel = valueOrLength;
                            } else if (attributeName.equals("dCompressionParam")) {
                                this.isLossless = valueOrLength >= 0;
                            } else if (attributeName.equals("eCompression")) {
                                canBeLossless = valueOrLength <= 0;
                            } else if (attributeName.equals("SLxImageAttributes")) {
                                int toSkip = valueOrLength - 5;
                                if (toSkip % 2 == 1) {
                                    ++toSkip;
                                }
                                this.in.skipBytes(toSkip);
                            } else if (attributeName.endsWith("Desc")) {
                                this.in.seek(this.in.getFilePointer() - 2L);
                            } else if (attributeName.equals("SLxExperiment")) {
                                this.in.skipBytes(8);
                            } else if (attributeName.equals("wsCameraName")) {
                                this.in.seek(this.in.getFilePointer() - 4L);
                                byte[] b = new byte[2];
                                this.in.read(b);
                                StringBuilder value = new StringBuilder();
                                while (b[0] != 0) {
                                    value.append(b[0]);
                                    this.in.read(b);
                                }
                                this.addGlobalMeta(attributeName, value.toString());
                            } else if (attributeName.equals("uLoopPars")) {
                                int v2 = this.in.readInt();
                                int v3 = this.in.readInt();
                                this.addGlobalMeta(attributeName, valueOrLength + ", " + v2 + ", " + v3);
                            } else if (attributeName.equals("pPeriod")) {
                                this.in.skipBytes(22);
                            } else if (attributeName.equals("dPeriod") || attributeName.equals("dDuration")) {
                                this.in.skipBytes(4);
                            } else if (attributeName.equals("bDurationPref")) {
                                this.in.seek(this.in.getFilePointer() - 3L);
                            }
                            this.in.skipBytes(1);
                        }
                        if (this.in.getFilePointer() > endFP) {
                            this.in.seek(endFP);
                        }
                        this.isLossless = this.isLossless && canBeLossless;
                    } else {
                        int length = len - 12;
                        byte[] b = new byte[length];
                        this.in.read(b);
                        int off = 0;
                        for (int j = 0; j < length; ++j) {
                            char c = (char)b[j];
                            if (off == 0 && c == '!' || c == '\u0000') {
                                off = j + 1;
                            }
                            if (!Character.isISOControl(c) && Character.isDefined(c)) continue;
                            b[j] = 32;
                        }
                        if (length - off >= 5 && b[off] == 60 && b[off + 1] == 63 && b[off + 2] == 120 && b[off + 3] == 109 && b[off + 4] == 108) {
                            boolean endBracketFound = false;
                            while (!endBracketFound) {
                                if (b[off++] != 62) continue;
                                endBracketFound = true;
                            }
                            xml.write(b, off, b.length - off);
                        }
                    }
                    skip = 0;
                } else if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
                    if (blockType.startsWith("CustomData|A")) {
                        customDataOffsets.add(new Long(fp));
                        customDataLengths.add(new int[]{nameLength, (int)dataLength});
                    } else if (blockType.startsWith("CustomData|Z")) {
                        int nDoubles = len / 8;
                        this.zOffset = fp + (long)(8 * (nDoubles - imageOffsets.size()));
                        ++extraZDataCount;
                    } else if (blockType.startsWith("CustomData|X")) {
                        int nDoubles = len / 8;
                        this.xOffset = fp + (long)(8 * (nDoubles - imageOffsets.size()));
                    } else if (blockType.startsWith("CustomData|Y")) {
                        int nDoubles = len / 8;
                        this.yOffset = fp + (long)(8 * (nDoubles - imageOffsets.size()));
                    }
                }
                if (skip <= 0 || (long)skip + this.in.getFilePointer() > this.in.length()) continue;
                this.in.skipBytes(skip);
            }
            for (int i5 = 0; i5 < textStrings.size(); ++i5) {
                this.parseText((String)textStrings.get(i5), imageOffsets.size(), (Boolean)validDimensions.get(i5));
            }
            String xmlString = new String(xml.getBytes(), 0, (int)xml.length(), "UTF-8");
            xml = null;
            xmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><ND2>" + xmlString + "</ND2>";
            xmlString = XMLTools.sanitizeXML(xmlString);
            ((CoreMetadata)this.core.get((int)0)).dimensionOrder = "";
            ND2Handler handler = new ND2Handler(this.core, this.getSizeX() == 0, imageOffsets.size());
            XMLTools.parseXML(xmlString, (DefaultHandler)handler);
            xmlString = null;
            if (handler.getChannelColors().size() > 0) {
                this.channelColors = handler.getChannelColors();
            }
            if (!this.isLossless) {
                this.isLossless = handler.isLossless();
            }
            this.fieldIndex = handler.getFieldIndex();
            this.core = handler.getCoreMetadataList();
            Hashtable<String, Object> globalMetadata = handler.getMetadata();
            this.nXFields = handler.getXFields();
            if (this.nXFields > 6) {
                this.nXFields = 0;
            }
            for (String key : globalMetadata.keySet()) {
                this.addGlobalMeta(key, globalMetadata.get(key));
                if (key.equals("ChannelCount")) {
                    for (int i6 = 0; i6 < this.getSeriesCount(); ++i6) {
                        CoreMetadata ms = (CoreMetadata)this.core.get(i6);
                        if (ms.sizeC != 0) continue;
                        ms.sizeC = Integer.parseInt(globalMetadata.get(key).toString());
                        if (ms.sizeC <= 1) continue;
                        ms.rgb = true;
                    }
                    continue;
                }
                if (!key.equals("uiBpcInMemory")) continue;
                int bpc = Integer.parseInt(globalMetadata.get(key).toString());
                ((CoreMetadata)this.core.get((int)0)).pixelType = FormatTools.pixelTypeFromBytes(bpc / 8, false, false);
            }
            int planeCount = this.core.size() * this.getSizeZ() * this.getSizeT();
            if (!this.textData && planeCount < imageOffsets.size() && planeCount > 0 && imageOffsets.size() % (planeCount / this.core.size()) == 0) {
                int seriesCount = imageOffsets.size() / (planeCount / this.core.size());
                this.core = new ArrayList();
                for (int i7 = 0; i7 < seriesCount; ++i7) {
                    this.core.add(handler.getCoreMetadataList().get(0));
                }
            }
            if ((numSeries = this.core.size()) == 0) {
                numSeries = 1;
            }
            if (this.getSizeZ() == 0) {
                int i8;
                for (i8 = 0; i8 < this.getSeriesCount(); ++i8) {
                    ((CoreMetadata)this.core.get((int)i8)).sizeZ = 1;
                }
                if (this.getSizeT() == 0) {
                    for (i8 = 0; i8 < this.getSeriesCount(); ++i8) {
                        ((CoreMetadata)this.core.get((int)i8)).sizeT = imageOffsets.size() / this.getSeriesCount();
                    }
                }
            }
            if (this.getSizeT() == 0) {
                for (int i9 = 0; i9 < this.getSeriesCount(); ++i9) {
                    ((CoreMetadata)this.core.get((int)i9)).sizeT = 1;
                }
            }
            if (this.getSizeC() == 0) {
                for (int i10 = 0; i10 < this.getSeriesCount(); ++i10) {
                    ((CoreMetadata)this.core.get((int)i10)).sizeC = 1;
                }
            }
            if (this.getSizeZ() * this.getSizeT() == imageOffsets.size() && this.core.size() > 1) {
                CoreMetadata ms0 = (CoreMetadata)this.core.get(0);
                this.core = new ArrayList();
                this.core.add(ms0);
            }
            if ((this.getSizeZ() == imageOffsets.size() || extraZDataCount > 1 && this.getSizeZ() == 1 || handler.getXPositions().size() == 0 && this.xOffset == 0L && this.getSizeZ() != this.getSeriesCount()) && this.getSeriesCount() > 1) {
                CoreMetadata ms0 = (CoreMetadata)this.core.get(0);
                if (this.getSeriesCount() > ms0.sizeZ) {
                    ms0.sizeZ = this.getSeriesCount();
                }
                this.core = new ArrayList();
                this.core.add(ms0);
            }
            long firstOffset = (Long)imageOffsets.get(0);
            long secondOffset = imageOffsets.size() > 1 ? ((Long)imageOffsets.get(1)).longValue() : this.in.length();
            long availableBytes = secondOffset - firstOffset;
            this.isLossless = true;
            long fp = this.in.getFilePointer();
            int[] firstLengths = (int[])imageLengths.get(0);
            this.in.seek(firstOffset + (long)firstLengths[0] + 8L);
            if (this.codec == null) {
                this.codec = this.createCodec(false);
            }
            try {
                CodecOptions options = new CodecOptions();
                options.littleEndian = this.isLittleEndian();
                options.interleaved = true;
                options.maxBytes = (int)secondOffset;
                byte[] t = this.codec.decompress(this.in, options);
                if (t.length == 2 * this.getSizeX() * this.getSizeY() && this.getPixelType() == 0) {
                    ((CoreMetadata)this.core.get((int)0)).pixelType = 3;
                }
                availableBytes = t.length;
            }
            catch (IOException e) {
                this.isLossless = false;
            }
            boolean allEqual = true;
            for (int i11 = 1; i11 < imageOffsets.size(); ++i11) {
                if (((int[])imageLengths.get(i11))[1] == ((int[])imageLengths.get(0))[1]) continue;
                allEqual = false;
                break;
            }
            if (!allEqual && !this.isLossless && imageOffsets.size() > 1) {
                int plane = (this.getSizeX() + this.getScanlinePad()) * this.getSizeY();
                boolean fixByteCounts = false;
                if (plane > 0) {
                    for (int i12 = 0; i12 < imageOffsets.size(); ++i12) {
                        int check = ((int[])imageLengths.get(i12))[2];
                        int length = ((int[])imageLengths.get(i12))[1] - 8;
                        if ((length % plane == 0 || length % (this.getSizeX() * this.getSizeY()) == 0) && (check <= 0 || plane == check)) continue;
                        if (i12 == 0) {
                            fixByteCounts = true;
                        }
                        imageOffsets.remove(i12);
                        imageLengths.remove(i12);
                        --i12;
                    }
                }
                if (fixByteCounts) {
                    firstOffset = (Long)imageOffsets.get(0);
                    secondOffset = imageOffsets.size() > 1 ? ((Long)imageOffsets.get(1)).longValue() : this.in.length();
                    availableBytes = secondOffset - firstOffset;
                    if (this.isLossless) {
                        firstLengths = (int[])imageLengths.get(0);
                        this.in.seek(firstOffset + (long)firstLengths[0] + 8L);
                        CodecOptions options = new CodecOptions();
                        options.littleEndian = this.isLittleEndian();
                        options.interleaved = true;
                        options.maxBytes = (int)secondOffset;
                        byte[] t = this.codec.decompress(this.in, options);
                        availableBytes = t.length;
                    }
                }
            }
            this.in.seek(fp);
            int planeSize = this.getSizeX() * this.getSizeY() * this.getSizeC() * FormatTools.getBytesPerPixel(this.getPixelType());
            if (availableBytes < (long)planeSize) {
                LOGGER.debug("Correcting SizeC: was {}", (Object)this.getSizeC());
                LOGGER.debug("plane size = {}", (Object)planeSize);
                LOGGER.debug("available bytes = {}", (Object)availableBytes);
                ((CoreMetadata)this.core.get((int)0)).sizeC = (int)(availableBytes / (long)(planeSize / this.getSizeC()));
                if (this.getSizeC() == 0) {
                    ((CoreMetadata)this.core.get((int)0)).sizeC = 1;
                }
            } else if (planeSize > 0 && availableBytes > DataTools.safeMultiply64(planeSize, 3L)) {
                if (availableBytes < DataTools.safeMultiply64(planeSize, 6L)) {
                    ((CoreMetadata)this.core.get((int)0)).sizeC = 3;
                    ((CoreMetadata)this.core.get((int)0)).rgb = true;
                    if (this.getPixelType() == 0) {
                        ((CoreMetadata)this.core.get((int)0)).pixelType = availableBytes > (long)(planeSize * 5) ? 3 : 1;
                    }
                }
            } else if ((planeSize > 0 && availableBytes >= DataTools.safeMultiply64(planeSize, 2L) || this.getSizeC() > 3) && this.getPixelType() == 0) {
                ((CoreMetadata)this.core.get((int)0)).pixelType = 3;
                if (this.getSizeC() > 3) {
                    ((CoreMetadata)this.core.get((int)0)).sizeC = 3;
                    ((CoreMetadata)this.core.get((int)0)).rgb = true;
                }
            } else if (this.getSizeC() == 2 && this.getPixelType() == 0 && availableBytes >= (long)(planeSize * 2)) {
                ((CoreMetadata)this.core.get((int)0)).pixelType = 3;
            } else if (this.getPixelType() == 0) {
                ((CoreMetadata)this.core.get((int)0)).pixelType = 1;
            }
            if (this.getSizeX() == 0) {
                ((CoreMetadata)this.core.get((int)0)).sizeX = (int)Math.sqrt(availableBytes / (long)(this.getSizeC() * FormatTools.getBytesPerPixel(this.getPixelType())));
                ((CoreMetadata)this.core.get((int)0)).sizeY = this.getSizeX();
            }
            if ((sizeY = availableBytes / (long)(rowSize = this.getSizeX() * FormatTools.getBytesPerPixel(this.getPixelType()) * this.getSizeC())) < (long)this.getSizeY()) {
                ((CoreMetadata)this.core.get((int)0)).sizeY = (int)sizeY;
            }
            if (this.getSizeT() == imageOffsets.size() && this.getSeriesCount() > 1) {
                CoreMetadata firstCore = (CoreMetadata)this.core.get(0);
                this.core = new ArrayList();
                this.core.add(firstCore);
            }
            for (i3 = 0; i3 < this.getSeriesCount(); ++i3) {
                CoreMetadata ms = (CoreMetadata)this.core.get(i3);
                ms.imageCount = this.getSizeZ() * this.getSizeT() * this.getSizeC();
                if (imageOffsets.size() / this.getSeriesCount() < ms.imageCount) {
                    ms.imageCount /= this.getSizeC();
                }
                if (ms.imageCount <= imageOffsets.size() / this.getSeriesCount()) continue;
                if (ms.imageCount == imageOffsets.size()) {
                    CoreMetadata ms0 = (CoreMetadata)this.core.get(0);
                    this.core = new ArrayList();
                    this.core.add(ms0);
                    numSeries = 1;
                    break;
                }
                if (imageOffsets.size() % ms.sizeT == 0) {
                    ms.imageCount = imageOffsets.size() / this.getSeriesCount();
                    ms.sizeZ = ms.imageCount / ms.sizeT;
                    ms.dimensionOrder = "CZT";
                    continue;
                }
                ms.imageCount = imageOffsets.size() / this.getSeriesCount();
                ms.sizeZ = 1;
                ms.sizeT = ms.imageCount;
            }
            if (numSeries * this.getImageCount() == 1 && imageOffsets.size() > 1) {
                for (i3 = 0; i3 < this.getSeriesCount(); ++i3) {
                    ((CoreMetadata)this.core.get((int)i3)).imageCount = imageOffsets.size() / this.getSeriesCount();
                    ((CoreMetadata)this.core.get((int)i3)).sizeZ = this.getImageCount();
                    ((CoreMetadata)this.core.get((int)i3)).sizeT = 1;
                }
            }
            if (this.getSizeZ() * this.getSizeT() * (this.split ? 1 : this.getSizeC()) < imageOffsets.size() / this.getSeriesCount()) {
                int diff;
                int count = imageOffsets.size() / this.getSeriesCount();
                if (!this.split && count >= this.getSizeC()) {
                    count /= this.getSizeC();
                }
                if ((diff = count - this.getSizeZ() * this.getSizeT()) == this.getSizeZ()) {
                    ++((CoreMetadata)this.core.get((int)0)).sizeT;
                } else if (this.getSizeT() > this.getSizeZ()) {
                    ((CoreMetadata)this.core.get((int)0)).sizeZ = 1;
                    ((CoreMetadata)this.core.get((int)0)).sizeT = count;
                } else {
                    ((CoreMetadata)this.core.get((int)0)).sizeT = 1;
                    ((CoreMetadata)this.core.get((int)0)).sizeZ = count;
                }
                if (this.useZ != null && !this.useZ.booleanValue()) {
                    CoreMetadata original = (CoreMetadata)this.core.get(0);
                    int nSeries = imageOffsets.size() / (this.getSizeZ() * this.getSizeT());
                    for (int i13 = 1; i13 < nSeries; ++i13) {
                        this.core.add(original);
                    }
                    numSeries = this.core.size();
                }
                if (this.getSizeZ() * this.getSizeT() * (this.split ? 1 : this.getSizeC()) < imageOffsets.size() / this.getSeriesCount() && this.getSizeC() > 4) {
                    ((CoreMetadata)this.core.get((int)0)).sizeZ = 1;
                    ((CoreMetadata)this.core.get((int)0)).sizeT = imageOffsets.size() / this.getSeriesCount();
                }
                ((CoreMetadata)this.core.get((int)0)).imageCount = this.getSizeZ() * this.getSizeT() * this.getSizeC();
            }
            if (this.getDimensionOrder().equals("T")) {
                this.fieldIndex = 0;
            } else if (this.getDimensionOrder().equals("ZT") && this.fieldIndex == 2) {
                --this.fieldIndex;
            }
            if (this.getSizeC() > 1 && this.getDimensionOrder().indexOf("C") == -1) {
                ((CoreMetadata)this.core.get((int)0)).dimensionOrder = "C" + this.getDimensionOrder();
                ++this.fieldIndex;
            }
            ((CoreMetadata)this.core.get((int)0)).dimensionOrder = "XY" + this.getDimensionOrder();
            if (this.getDimensionOrder().indexOf("Z") == -1) {
                ((CoreMetadata)this.core.get((int)0)).dimensionOrder = ((CoreMetadata)this.core.get((int)0)).dimensionOrder + "Z";
            }
            if (this.getDimensionOrder().indexOf("C") == -1) {
                ((CoreMetadata)this.core.get((int)0)).dimensionOrder = ((CoreMetadata)this.core.get((int)0)).dimensionOrder + "C";
            }
            if (this.getDimensionOrder().indexOf("T") == -1) {
                ((CoreMetadata)this.core.get((int)0)).dimensionOrder = ((CoreMetadata)this.core.get((int)0)).dimensionOrder + "T";
            }
            if (this.getSizeZ() == 0) {
                ((CoreMetadata)this.core.get((int)0)).sizeZ = 1;
            }
            if (this.getSizeT() == 0) {
                ((CoreMetadata)this.core.get((int)0)).sizeT = 1;
            }
            if (this.getSizeC() == 0) {
                ((CoreMetadata)this.core.get((int)0)).sizeC = 1;
            }
            ((CoreMetadata)this.core.get((int)0)).imageCount = this.getSizeZ() * this.getSizeT();
            if (!this.isRGB()) {
                ((CoreMetadata)this.core.get((int)0)).imageCount *= this.getSizeC();
            }
            this.posX = handler.getXPositions();
            this.posY = handler.getYPositions();
            this.posZ = handler.getZPositions();
            int uniqueX = 0;
            int uniqueY = 0;
            int uniqueZ = 0;
            if (this.posX.size() == 0 && this.xOffset != 0L) {
                this.in.seek(this.xOffset);
                for (int i14 = 0; i14 < imageOffsets.size(); ++i14) {
                    Double x = new Double(this.in.readDouble());
                    if (!this.posX.contains(x)) {
                        ++uniqueX;
                    }
                    this.posX.add(x);
                }
            }
            if (this.posY.size() == 0 && this.yOffset != 0L) {
                this.in.seek(this.yOffset);
                for (int i15 = 0; i15 < imageOffsets.size(); ++i15) {
                    Double y = new Double(this.in.readDouble());
                    if (!this.posY.contains(y)) {
                        ++uniqueY;
                    }
                    this.posY.add(y);
                }
            }
            if (this.posZ.size() == 0 && this.zOffset != 0L) {
                this.in.seek(this.zOffset);
                for (int i16 = 0; i16 < imageOffsets.size(); ++i16) {
                    Double z = new Double(this.in.readDouble());
                    if (!this.posZ.contains(z)) {
                        boolean unique = true;
                        for (int q = 0; q < this.posZ.size(); ++q) {
                            if (!(Math.abs(z - this.posZ.get(q)) <= 0.05)) continue;
                            unique = false;
                            break;
                        }
                        if (unique) {
                            ++uniqueZ;
                        }
                    }
                    this.posZ.add(z);
                }
            }
            if (this.core.size() == 1 && (uniqueX == this.getSizeT() && uniqueY == this.getSizeT() || uniqueZ == this.getSizeT())) {
                int count = this.getSizeT();
                ((CoreMetadata)this.core.get((int)0)).imageCount /= count;
                ((CoreMetadata)this.core.get((int)0)).sizeT = 1;
                for (int i17 = 1; i17 < count; ++i17) {
                    this.core.add(this.core.get(0));
                }
                numSeries = this.core.size();
            }
            if (this.getImageCount() == imageOffsets.size() && numSeries > 1 && this.getSizeC() == 1) {
                CoreMetadata first = (CoreMetadata)this.core.get(0);
                this.core.clear();
                this.core.add(first);
                numSeries = 1;
            }
            this.offsets = new long[numSeries][this.getImageCount()];
            int[] lengths = new int[4];
            int nextChar = 2;
            for (int i18 = 0; i18 < lengths.length; ++i18) {
                if (i18 == this.fieldIndex) {
                    lengths[i18] = this.core.size();
                    continue;
                }
                char axis = this.getDimensionOrder().charAt(nextChar++);
                if (axis == 'Z') {
                    lengths[i18] = this.getSizeZ();
                    continue;
                }
                if (axis == 'C') {
                    lengths[i18] = 1;
                    continue;
                }
                if (axis != 'T') continue;
                lengths[i18] = this.getSizeT();
            }
            int[] zctLengths = new int[4];
            System.arraycopy(lengths, 0, zctLengths, 0, lengths.length);
            zctLengths[this.fieldIndex] = 1;
            boolean oneIndexed = false;
            for (int i19 = 0; i19 < imageOffsets.size(); ++i19) {
                String imageName;
                int ndx;
                long offset = (Long)imageOffsets.get(i19);
                int[] p = (int[])imageLengths.get(i19);
                int length = p[0] + p[1];
                if (this.getSizeC() == 0) {
                    int sizeC = length / (this.getSizeX() * this.getSizeY() * FormatTools.getBytesPerPixel(this.getPixelType()));
                    for (int q = 0; q < this.getSeriesCount(); ++q) {
                        ((CoreMetadata)this.core.get((int)q)).sizeC = sizeC;
                    }
                }
                if ((ndx = Integer.parseInt((imageName = (String)imageNames.get(i19)).replaceAll("\\D", ""))) == 1 && i19 == 0) {
                    oneIndexed = true;
                }
                if (oneIndexed) {
                    --ndx;
                }
                int[] pos = FormatTools.rasterToPosition(lengths, ndx);
                int seriesIndex = pos[this.fieldIndex];
                pos[this.fieldIndex] = 0;
                int plane = FormatTools.positionToRaster(zctLengths, pos);
                if (seriesIndex >= this.offsets.length || plane >= this.offsets[seriesIndex].length) continue;
                this.offsets[seriesIndex][plane] = offset + (long)p[0] + 8L;
            }
            ArrayList<long[]> tmpOffsets = new ArrayList<long[]>();
            for (i2 = 0; i2 < this.offsets.length; ++i2) {
                if (this.offsets[i2].length <= 0 || this.offsets[i2][0] <= 0L) continue;
                tmpOffsets.add(this.offsets[i2]);
            }
            this.offsets = new long[tmpOffsets.size()][];
            for (i2 = 0; i2 < tmpOffsets.size(); ++i2) {
                this.offsets[i2] = (long[])tmpOffsets.get(i2);
            }
            if (this.offsets.length != this.getSeriesCount()) {
                int x = this.getSizeX();
                int y = this.getSizeY();
                int c = this.getSizeC();
                int pixelType = this.getPixelType();
                int bitsPerPixel = this.getBitsPerPixel();
                boolean rgb = this.isRGB();
                String order = this.getDimensionOrder();
                this.core = new ArrayList();
                for (int i20 = 0; i20 < this.offsets.length; ++i20) {
                    CoreMetadata ms = new CoreMetadata();
                    this.core.add(ms);
                    ms.sizeX = x;
                    ms.sizeY = y;
                    ms.sizeC = c == 0 ? 1 : c;
                    ms.pixelType = pixelType;
                    ms.bitsPerPixel = bitsPerPixel;
                    ms.rgb = rgb;
                    ms.sizeZ = 1;
                    ms.dimensionOrder = order;
                    int invalid = 0;
                    for (int q = 0; q < this.offsets[i20].length; ++q) {
                        if (this.offsets[i20][q] != 0L) continue;
                        ++invalid;
                    }
                    ms.imageCount = this.offsets[i20].length - invalid;
                    ms.sizeT = ms.imageCount / (rgb ? 1 : ms.sizeC);
                    if (ms.sizeT != 0) continue;
                    ms.sizeT = 1;
                }
            } else {
                for (i2 = 0; i2 < this.getSeriesCount(); ++i2) {
                    CoreMetadata ms = (CoreMetadata)this.core.get(i2);
                    ms.sizeX = this.getSizeX();
                    ms.sizeY = this.getSizeY();
                    ms.sizeC = this.getSizeC() == 0 ? 1 : this.getSizeC();
                    ms.sizeZ = this.getSizeZ() == 0 ? 1 : this.getSizeZ();
                    ms.sizeT = this.getSizeT() == 0 ? 1 : this.getSizeT();
                    ms.imageCount = this.getImageCount();
                    ms.pixelType = this.getPixelType();
                    ms.bitsPerPixel = this.getBitsPerPixel();
                    ms.dimensionOrder = this.getDimensionOrder();
                }
            }
            boolean hasColor = false;
            for (String ch : this.channelColors.keySet()) {
                Integer color = this.channelColors.get(ch);
                if (color == 0xFFFFFF || color == 0) continue;
                hasColor = true;
                break;
            }
            this.split = this.getSizeC() > 1;
            for (int i21 = 0; i21 < this.getSeriesCount(); ++i21) {
                CoreMetadata ms = (CoreMetadata)this.core.get(i21);
                ms.rgb = false;
                ms.littleEndian = true;
                ms.interleaved = false;
                ms.indexed = this.channelColors.size() > 0 && hasColor;
                ms.falseColor = true;
                ms.metadataComplete = true;
                ms.imageCount = ms.sizeZ * ms.sizeT * ms.sizeC;
            }
            if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM && customDataOffsets.size() > 0) {
                this.in.seek((Long)customDataOffsets.get(0));
                int[] p = (int[])customDataLengths.get(0);
                int len = p[0] + p[1];
                int timestampBytes = imageOffsets.size() * 8;
                this.in.skipBytes(len - timestampBytes);
                for (int series = 0; series < this.getSeriesCount(); ++series) {
                    this.setSeries(series);
                    int count = this.split ? this.getImageCount() / this.getSizeC() : this.getImageCount();
                    for (int plane = 0; plane < count; ++plane) {
                        double time = this.in.readDouble() / 1000.0;
                        this.tsT.add(new Double(time));
                        this.addSeriesMetaList("timestamp", time);
                    }
                }
                this.setSeries(0);
            }
            this.populateMetadataStore(handler);
            return;
        }
        this.in.seek(0L);
        this.isJPEG = true;
        LOGGER.info("Calculating image offsets");
        ArrayList<Long> vs = new ArrayList<Long>();
        long pos = this.in.getFilePointer();
        boolean lastBoxFound = false;
        int length = 0;
        int box = 0;
        int x = 0;
        int y = 0;
        int c = 0;
        int type = 0;
        while (!lastBoxFound) {
            pos = this.in.getFilePointer();
            long nextPos = pos + (long)(length = this.in.readInt());
            if (nextPos < 0L || nextPos >= this.in.length() || length == 0) {
                lastBoxFound = true;
            }
            box = this.in.readInt();
            pos = this.in.getFilePointer();
            length -= 8;
            if (box == 1785737827) {
                vs.add(new Long(pos));
            } else if (box == 1785737832) {
                this.in.skipBytes(4);
                String s = this.in.readString(4);
                if (s.equals("ihdr")) {
                    y = this.in.readInt();
                    x = this.in.readInt();
                    c = this.in.readShort();
                    type = this.in.readInt();
                    type = type == 252117248 || type == 0xF070000 ? 3 : 1;
                }
            }
            if (lastBoxFound || box == 1785737832) continue;
            this.in.skipBytes(length);
        }
        LOGGER.info("Finding XML metadata");
        this.in.seek((Long)vs.get(vs.size() - 1));
        boolean found = false;
        long off = -1L;
        byte[] buf = new byte[8192];
        block50: while (!found && this.in.getFilePointer() < this.in.length()) {
            int read = 0;
            if (this.in.getFilePointer() == ((Long)vs.get(vs.size() - 1)).longValue()) {
                read = this.in.read(buf);
            } else {
                System.arraycopy(buf, buf.length - 10, buf, 0, 10);
                read = this.in.read(buf, 10, buf.length - 10);
            }
            if (read == buf.length) {
                read -= 10;
            }
            for (int i22 = 0; i22 < read + 9; ++i22) {
                if (buf[i22] != -1 || buf[i22 + 1] != -39) continue;
                found = true;
                off = this.in.getFilePointer() - (long)(read + 10) + (long)i22;
                i22 = buf.length;
                continue block50;
            }
        }
        buf = null;
        LOGGER.info("Parsing XML");
        ArrayList<Object> zs = new ArrayList();
        ArrayList<Object> ts = new ArrayList();
        int numSeries = 0;
        ND2Handler handler = null;
        if (off > 0L && off < this.in.length() - 5L && this.in.length() - off - 5L > 14L) {
            this.in.seek(off + 4L);
            StringBuffer sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><NIKON>");
            String s = null;
            int blockLength = 0;
            while (this.in.getFilePointer() < this.in.length() && (blockLength = this.in.readShort()) >= 2) {
                int closedBracket;
                if ((long)(blockLength -= 2) + this.in.getFilePointer() >= this.in.length()) {
                    blockLength = (int)(this.in.length() - this.in.getFilePointer());
                }
                s = this.in.readString(blockLength);
                int openBracket = (s = s.replaceAll("<!--.+?>", "")).indexOf("<");
                if (openBracket == -1 || (closedBracket = s.lastIndexOf(">") + 1) < openBracket || (s = s.substring(openBracket, closedBracket).trim()).indexOf("CalibrationSeq") != -1 || s.indexOf("VCAL") != -1 || s.indexOf("jp2cLUNK") != -1) continue;
                sb.append(s);
            }
            s = null;
            sb.append("</NIKON>");
            LOGGER.info("Finished assembling XML string");
            int offset = 0;
            int len = sb.length();
            for (int i23 = 0; i23 < len; ++i23) {
                char ch = sb.charAt(i23);
                if (offset == 0 && ch == '!') {
                    offset = i23 + 1;
                }
                if (!Character.isISOControl(ch) && Character.isDefined(ch)) continue;
                sb.setCharAt(i23, ' ');
            }
            ((CoreMetadata)this.core.get((int)0)).dimensionOrder = "";
            if (len - offset < offset) {
                offset = 0;
            }
            String xml = sb.substring(offset, len);
            sb = null;
            handler = new ND2Handler(this.core, vs.size());
            try {
                xml = XMLTools.sanitizeXML(xml);
                XMLTools.parseXML(xml, (DefaultHandler)handler);
            }
            catch (IOException e) {
                // empty catch block
            }
            xml = null;
            this.isLossless = handler.isLossless();
            this.fieldIndex = handler.getFieldIndex();
            zs = handler.getZSections();
            ts = handler.getTimepoints();
            numSeries = handler.getSeriesCount();
            this.core = handler.getCoreMetadataList();
            Hashtable<String, Object> globalMetadata = handler.getMetadata();
            for (String key : globalMetadata.keySet()) {
                this.addGlobalMeta(key, globalMetadata.get(key));
            }
        }
        LOGGER.info("Populating metadata");
        ((CoreMetadata)this.core.get((int)0)).pixelType = 1;
        this.offsets = new long[1][2];
        this.offsets[0][0] = (Long)vs.get(0);
        if (this.offsets[0].length > 1 && vs.size() > 1) {
            this.offsets[0][1] = (Long)vs.get(1);
        }
        this.in.seek(this.offsets[0][0]);
        if (this.getSizeC() == 0) {
            ((CoreMetadata)this.core.get((int)0)).sizeC = 1;
        }
        int n = c = (numBands = c) > 1 ? numBands : this.getSizeC();
        if (numBands == 1 && this.getImageCount() == 1) {
            c = 1;
        }
        for (i = 0; i < this.getSeriesCount(); ++i) {
            CoreMetadata ms = (CoreMetadata)this.core.get(i);
            ms.sizeC = c;
            ms.rgb = numBands > 1;
            ms.pixelType = type;
        }
        if (this.getDimensionOrder() == null) {
            ((CoreMetadata)this.core.get((int)0)).dimensionOrder = "";
        }
        if (this.getSizeC() > 1) {
            ((CoreMetadata)this.core.get((int)0)).dimensionOrder = this.getDimensionOrder().replaceAll("C", "");
            ((CoreMetadata)this.core.get((int)0)).dimensionOrder = "C" + this.getDimensionOrder();
            ++this.fieldIndex;
        }
        if (this.getDimensionOrder().indexOf("Z") == -1) {
            ((CoreMetadata)this.core.get((int)0)).dimensionOrder = ((CoreMetadata)this.core.get((int)0)).dimensionOrder + "Z";
        }
        if (this.getDimensionOrder().indexOf("C") == -1) {
            ((CoreMetadata)this.core.get((int)0)).dimensionOrder = ((CoreMetadata)this.core.get((int)0)).dimensionOrder + "C";
        }
        if (this.getDimensionOrder().indexOf("T") == -1) {
            ((CoreMetadata)this.core.get((int)0)).dimensionOrder = ((CoreMetadata)this.core.get((int)0)).dimensionOrder + "T";
        }
        ((CoreMetadata)this.core.get((int)0)).dimensionOrder = "XY" + this.getDimensionOrder();
        if (this.getImageCount() == 0) {
            int channels;
            ((CoreMetadata)this.core.get((int)0)).imageCount = vs.size();
            ((CoreMetadata)this.core.get((int)0)).sizeZ = Math.max(zs.size(), 1);
            ((CoreMetadata)this.core.get((int)0)).sizeT = Math.max(ts.size(), 1);
            int n2 = channels = this.isRGB() ? 1 : this.getSizeC();
            if (channels * this.getSizeZ() * this.getSizeT() != this.getImageCount()) {
                ((CoreMetadata)this.core.get((int)0)).sizeZ = 1;
                ((CoreMetadata)this.core.get((int)0)).sizeT = this.getImageCount() / channels;
                ((CoreMetadata)this.core.get((int)0)).imageCount = this.getSizeZ() * this.getSizeT() * channels;
            }
        }
        if (this.getSizeZ() == 0) {
            ((CoreMetadata)this.core.get((int)0)).sizeZ = 1;
        }
        if (this.getSizeT() == 0) {
            ((CoreMetadata)this.core.get((int)0)).sizeT = 1;
        }
        for (i = 0; i < this.getSeriesCount(); ++i) {
            CoreMetadata ms = (CoreMetadata)this.core.get(i);
            ms.sizeZ = this.getSizeZ();
            ms.sizeT = this.getSizeT();
            ms.imageCount = this.getSizeZ() * this.getSizeT() * (this.isRGB() ? 1 : this.getSizeC());
            ms.dimensionOrder = this.getDimensionOrder();
            ms.sizeX = x;
            ms.sizeY = y;
            ms.interleaved = false;
            ms.littleEndian = false;
            ms.metadataComplete = true;
        }
        int nplanes = this.getSizeZ() * this.getEffectiveSizeC();
        if (numSeries == 0) {
            numSeries = 1;
        }
        if (numSeries * nplanes * this.getSizeT() > vs.size()) {
            numSeries = vs.size() / (nplanes * this.getSizeT());
        }
        this.offsets = new long[numSeries][this.getImageCount()];
        for (int i24 = 0; i24 < this.getSizeT(); ++i24) {
            for (int j = 0; j < numSeries; ++j) {
                for (int q = 0; q < nplanes; ++q) {
                    this.offsets[j][i24 * nplanes + q] = (Long)vs.remove(0);
                }
            }
        }
        this.populateMetadataStore(handler);
    }

    private void iterateIn(RandomAccessInputStream in, Long stop) {
        try {
            Integer currentColor = null;
            block15: while (in.getFilePointer() < stop) {
                Object value;
                long startOffset = in.getFilePointer();
                int type = in.read();
                int letters = in.read();
                String name = DataTools.stripString(in.readString(letters * 2));
                switch (type) {
                    case 1: {
                        value = in.readBoolean();
                        break;
                    }
                    case 2: {
                        value = in.readInt();
                        break;
                    }
                    case 3: {
                        value = in.readInt();
                        break;
                    }
                    case 4: {
                        value = in.readLong();
                        break;
                    }
                    case 5: {
                        value = in.readLong();
                        break;
                    }
                    case 6: {
                        value = in.readDouble();
                        break;
                    }
                    case 7: {
                        value = in.readLong();
                        break;
                    }
                    case 8: {
                        long start = in.getFilePointer();
                        value = DataTools.stripString(in.findString("\u0000\u0000\u0000"));
                        long end = in.getFilePointer();
                        if ((end - start) % 2L == 0L) break;
                        in.skipBytes(1);
                        break;
                    }
                    case 9: {
                        long length = in.readLong();
                        if (length + in.getFilePointer() > stop) {
                            in.seek(stop);
                            continue block15;
                        }
                        byte[] data = new byte[(int)length];
                        in.read(data);
                        value = new String(data, "UTF-8");
                        break;
                    }
                    case 10: {
                        int numberOfItems = in.readInt();
                        Long off = in.readLong() - in.getFilePointer() - 4L - 2L - (long)(letters * 2);
                        value = "LEVEL";
                        this.iterateIn(in, off + in.getFilePointer());
                        if (off < 0L) break;
                        in.seek(off + in.getFilePointer() + (long)(numberOfItems * 8));
                        value = in.readLong();
                        break;
                    }
                    case 11: {
                        int numberOfItems = in.readInt();
                        Long off = in.readLong();
                        value = "LEVEL";
                        long endOffset = off + startOffset;
                        this.iterateIn(in, endOffset);
                        in.seek(endOffset + (long)(numberOfItems * 8));
                        break;
                    }
                    default: {
                        continue block15;
                    }
                }
                name = name.trim();
                if (name.equals("bUseZ")) {
                    this.useZ = new Boolean(value.toString());
                } else if (name.equals("sDescription")) {
                    if (currentColor != null) {
                        this.textChannelNames.add(value.toString());
                        this.channelColors.put(value.toString(), currentColor);
                    }
                } else if (name.equals("uiColor")) {
                    currentColor = (Integer)value;
                } else if (name.equals("dExposureTime")) {
                    this.exposureTime.add((Double)value);
                } else if (name.equals("EmWavelength")) {
                    Double wave = Double.parseDouble(value.toString());
                    this.textEmissionWavelengths.add(wave.intValue());
                }
                if (type == 11 || type == 10) continue;
                this.addGlobalMeta(name, value);
            }
        }
        catch (Exception e) {
            LOGGER.debug("", e);
        }
    }

    private void populateMetadataStore(ND2Handler handler) throws FormatException {
        Double mag;
        Double na;
        int i;
        int i2;
        int i3;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        String filename = new Location(this.getCurrentFile()).getName();
        if (handler != null) {
            ArrayList<String> posNames = handler.getPositionNames();
            for (i3 = 0; i3 < this.getSeriesCount(); ++i3) {
                String suffix = i3 < posNames.size() ? posNames.get(i3) : "(series " + (i3 + 1) + ")";
                String name = filename + " " + suffix;
                store.setImageName(name.trim(), i3);
            }
        }
        this.colors = new int[this.getEffectiveSizeC()];
        ArrayList<String> channelNames = null;
        if (handler != null) {
            channelNames = handler.getChannelNames();
            if (channelNames.size() < this.getEffectiveSizeC() && this.backupHandler != null) {
                channelNames = this.backupHandler.getChannelNames();
            } else if (channelNames.size() < this.getEffectiveSizeC()) {
                channelNames = this.textChannelNames;
            }
            for (i3 = 0; i3 < this.getSeriesCount(); ++i3) {
                for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                    int index = i3 * this.getSizeC() + c;
                    if (index >= channelNames.size()) continue;
                    String channelName = channelNames.get(index);
                    Integer channelColor = this.channelColors.get(channelName);
                    this.colors[c] = channelColor == null ? 0 : channelColor;
                }
            }
        }
        if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) {
            return;
        }
        String instrumentID = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrumentID, 0);
        for (i2 = 0; i2 < this.getSeriesCount(); ++i2) {
            store.setImageInstrumentRef(instrumentID, i2);
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                int red = this.colors[c] & 0xFF;
                int green = (this.colors[c] & 0xFF00) >> 8;
                int blue = (this.colors[c] & 0xFF0000) >> 16;
                if (red == 0 && green == 0 && blue == 0) continue;
                store.setChannelColor(new Color(red, green, blue, 255), i2, c);
            }
        }
        if (handler != null) {
            for (i2 = 0; i2 < this.getSeriesCount(); ++i2) {
                PositiveFloat size;
                double sizeX = handler.getPixelSizeX();
                double sizeY = handler.getPixelSizeY();
                double sizeZ = handler.getPixelSizeZ();
                if (this.trueSizeX > 0.0) {
                    store.setPixelsPhysicalSizeX(new PositiveFloat(this.trueSizeX), i2);
                } else {
                    size = FormatTools.getPhysicalSizeX(sizeX);
                    if (size != null) {
                        store.setPixelsPhysicalSizeX(size, i2);
                    }
                }
                if (this.trueSizeY > 0.0) {
                    store.setPixelsPhysicalSizeY(new PositiveFloat(this.trueSizeY), i2);
                } else if (this.trueSizeX > 0.0) {
                    store.setPixelsPhysicalSizeY(new PositiveFloat(this.trueSizeX), i2);
                } else {
                    size = FormatTools.getPhysicalSizeY(sizeY);
                    if (size == null) {
                        size = FormatTools.getPhysicalSizeY(sizeX);
                    }
                    if (size != null) {
                        store.setPixelsPhysicalSizeY(size, i2);
                    }
                }
                if (this.trueSizeZ > 0.0) {
                    store.setPixelsPhysicalSizeZ(new PositiveFloat(this.trueSizeZ), i2);
                    continue;
                }
                size = FormatTools.getPhysicalSizeZ(sizeZ);
                if (size == null) continue;
                store.setPixelsPhysicalSizeZ(size, i2);
            }
        }
        if (handler != null && handler.getExposureTimes().size() > 0) {
            this.exposureTime = handler.getExposureTimes();
        }
        for (i2 = 0; i2 < this.getSeriesCount(); ++i2) {
            if (this.tsT.size() > 0) {
                this.setSeries(i2);
                for (int n = 0; n < this.getImageCount(); ++n) {
                    int[] coords = this.getZCTCoords(n);
                    int stampIndex = coords[2] + i2 * this.getSizeT();
                    if (this.tsT.size() == this.getImageCount()) {
                        stampIndex = n;
                    } else if (this.tsT.size() == this.getSizeZ()) {
                        stampIndex = coords[0];
                    }
                    double stamp = this.tsT.get(stampIndex);
                    store.setPlaneDeltaT(stamp, i2, n);
                    int index = i2 * this.getSizeC() + coords[1];
                    if (this.exposureTime.size() == this.getSizeC()) {
                        index = coords[1];
                    }
                    if (this.exposureTime == null || index >= this.exposureTime.size()) continue;
                    store.setPlaneExposureTime(this.exposureTime.get(index), i2, n);
                }
            }
            if (handler != null) {
                if (this.posX == null) {
                    this.posX = handler.getXPositions();
                }
                if (this.posY == null) {
                    this.posY = handler.getYPositions();
                }
                if (this.posZ == null) {
                    this.posZ = handler.getZPositions();
                }
            }
            String pos = "for position";
            for (int n = 0; n < this.getImageCount(); ++n) {
                int index = i2 * this.getImageCount() + n;
                if (this.split) {
                    int planes = this.getImageCount() / this.getSizeC();
                    index = i2 * planes + n % planes;
                }
                if (this.posX != null) {
                    if (index >= this.posX.size()) {
                        index = i2;
                    }
                    if (index < this.posX.size()) {
                        String key = "X position ";
                        store.setPlanePositionX(this.posX.get(index), i2, n);
                        this.addSeriesMetaList(key, this.posX.get(index));
                        this.addGlobalMetaList(key + pos, this.posX.get(index));
                    }
                }
                if (this.posY != null && index < this.posY.size()) {
                    String key = "Y position ";
                    store.setPlanePositionY(this.posY.get(index), i2, n);
                    this.addSeriesMetaList(key, this.posY.get(index));
                    this.addGlobalMetaList(key + pos, this.posY.get(index));
                }
                if (this.posZ == null || index >= this.posZ.size()) continue;
                store.setPlanePositionZ(this.posZ.get(index), i2, n);
                String key = "Z position " + pos + ", plane";
                this.addSeriesMetaList(key, this.posZ.get(index));
                this.addGlobalMetaList(key, this.posZ.get(index));
            }
        }
        if (handler == null) {
            this.setSeries(0);
            return;
        }
        String detectorID = MetadataTools.createLSID("Detector", 0, 0);
        store.setDetectorID(detectorID, 0, 0);
        store.setDetectorModel(handler.getCameraModel(), 0, 0);
        store.setDetectorType(this.getDetectorType("Other"), 0, 0);
        ArrayList<String> modality = handler.getModalities();
        ArrayList<String> binning = handler.getBinnings();
        ArrayList<Double> speed = handler.getSpeeds();
        ArrayList<Double> gain = handler.getGains();
        ArrayList<Double> temperature = handler.getTemperatures();
        ArrayList<Integer> exWave = handler.getExcitationWavelengths();
        ArrayList<Integer> emWave = handler.getEmissionWavelengths();
        ArrayList<Integer> power = handler.getPowers();
        ArrayList<Hashtable<String, String>> rois = handler.getROIs();
        if (this.backupHandler != null) {
            if (emWave.size() == 0) {
                emWave = this.backupHandler.getEmissionWavelengths();
            }
            if (exWave.size() == 0) {
                exWave = this.backupHandler.getExcitationWavelengths();
            }
        }
        for (i = 0; i < this.getSeriesCount(); ++i) {
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                PositiveInteger excitation;
                int index = c;
                Double pinholeSize = handler.getPinholeSize();
                if (pinholeSize != null) {
                    store.setChannelPinholeSize(pinholeSize, i, c);
                }
                if (index < channelNames.size()) {
                    String channelName = channelNames.get(index);
                    store.setChannelName(channelName, i, c);
                } else if (channelNames.size() >= this.getEffectiveSizeC()) {
                    store.setChannelName(channelNames.get(c), i, c);
                }
                if (index < modality.size()) {
                    store.setChannelAcquisitionMode(this.getAcquisitionMode(modality.get(index)), i, c);
                }
                if (index < emWave.size() || index < this.textEmissionWavelengths.size()) {
                    Integer value = index < emWave.size() ? emWave.get(index) : this.textEmissionWavelengths.get(index);
                    PositiveInteger emission = FormatTools.getEmissionWavelength(value);
                    if (emission != null) {
                        store.setChannelEmissionWavelength(emission, i, c);
                    }
                } else if (emWave.size() > 0 || this.textEmissionWavelengths.size() > 0) {
                    store.setChannelColor(new Color(255, 255, 255, 255), i, c);
                }
                if (index < exWave.size() && (excitation = FormatTools.getExcitationWavelength(exWave.get(index))) != null) {
                    store.setChannelExcitationWavelength(excitation, i, c);
                }
                if (index < binning.size()) {
                    store.setDetectorSettingsBinning(this.getBinning(binning.get(index)), i, c);
                }
                if (index < gain.size()) {
                    store.setDetectorSettingsGain(gain.get(index), i, c);
                }
                if (index < speed.size()) {
                    store.setDetectorSettingsReadOutRate(speed.get(index), i, c);
                }
                store.setDetectorSettingsID(detectorID, i, c);
            }
        }
        for (i = 0; i < this.getSeriesCount(); ++i) {
            if (i * this.getSizeC() >= temperature.size()) continue;
            Double temp = temperature.get(i * this.getSizeC());
            store.setImagingEnvironmentTemperature(temp, i);
        }
        Double voltage = handler.getVoltage();
        if (voltage != null) {
            store.setDetectorSettingsVoltage(voltage, 0, 0);
        }
        if ((na = handler.getNumericalAperture()) != null) {
            store.setObjectiveLensNA(na, 0, 0);
        }
        if ((mag = handler.getMagnification()) != null) {
            store.setObjectiveCalibratedMagnification(mag, 0, 0);
        }
        store.setObjectiveModel(handler.getObjectiveModel(), 0, 0);
        String immersion = handler.getImmersion();
        if (immersion == null) {
            immersion = "Other";
        }
        store.setObjectiveImmersion(this.getImmersion(immersion), 0, 0);
        String correction = handler.getCorrection();
        if (correction == null || correction.length() == 0) {
            correction = "Other";
        }
        store.setObjectiveCorrection(this.getCorrection(correction), 0, 0);
        String objectiveID = MetadataTools.createLSID("Objective", 0, 0);
        store.setObjectiveID(objectiveID, 0, 0);
        if (this.refractiveIndex == null) {
            this.refractiveIndex = handler.getRefractiveIndex();
        }
        for (int i4 = 0; i4 < this.getSeriesCount(); ++i4) {
            store.setObjectiveSettingsID(objectiveID, i4);
            if (this.refractiveIndex == null) continue;
            store.setObjectiveSettingsRefractiveIndex(this.refractiveIndex, i4);
        }
        this.setSeries(0);
        if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.NO_OVERLAYS) {
            return;
        }
        handler.populateROIs(store);
    }

    private Codec createCodec(boolean isJPEG) {
        return isJPEG ? new JPEG2000Codec() : new ZlibCodec();
    }

    private void copyPixels(int x, int y, int w, int h, int bpp, int scanlinePad, byte[] pix, byte[] buf, boolean split) throws IOException {
        if (split) {
            pix = ImageTools.splitChannels(pix, this.lastChannel, this.getEffectiveSizeC(), bpp, false, true);
        }
        RandomAccessInputStream s = new RandomAccessInputStream(pix);
        this.readPlane(s, x, y, w, h, scanlinePad, buf);
        s.close();
    }

    public static String sanitizeControl(String s) {
        char[] c = s.toCharArray();
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isISOControl(c[i]) && Character.isDefined(c[i])) continue;
            c[i] = 32;
        }
        return new String(c);
    }

    private int getScanlinePad() {
        int scanlinePad;
        int n = scanlinePad = this.isJPEG ? 0 : this.getSizeX() % 2;
        if (scanlinePad == 1 && this.split && !this.isLossless && (this.nXFields % 2 != 0 || this.nXFields == 0 && (this.getSizeC() >= 4 || this.getSizeC() == 2))) {
            scanlinePad = 0;
        }
        return scanlinePad;
    }

    private void parseText(String textString, int offsetCount, boolean useDimensions) {
        try {
            ND2Handler handler = new ND2Handler(this.core, offsetCount);
            String xmlString = XMLTools.sanitizeXML(textString);
            int start = xmlString.indexOf("<");
            int end = xmlString.lastIndexOf(">");
            if (start >= 0 && end >= 0 && end >= start) {
                xmlString = xmlString.substring(start, end + 1);
            }
            XMLTools.parseXML(xmlString, (DefaultHandler)handler);
            xmlString = null;
            textString = null;
            this.core = handler.getCoreMetadataList();
            if (this.backupHandler == null || this.backupHandler.getChannelNames().size() == 0) {
                this.backupHandler = handler;
            }
            Hashtable<String, Object> globalMetadata = handler.getMetadata();
            for (String key : globalMetadata.keySet()) {
                this.addGlobalMeta(key, globalMetadata.get(key));
            }
        }
        catch (IOException e) {
            LOGGER.debug("Could not parse XML", e);
            String[] lines = textString.split("\n");
            ND2Handler handler = new ND2Handler(this.core, offsetCount);
            for (String line : lines) {
                int separator = line.indexOf(":");
                if (separator < 0) continue;
                String key = line.substring(0, separator).trim();
                String value = line.substring(separator + 1).trim();
                if (useDimensions) {
                    handler.parseKeyAndValue(key, value, null);
                }
                if (!handler.isDimensions(key)) continue;
                this.textData = true;
            }
            if (useDimensions) {
                this.core = handler.getCoreMetadataList();
            }
            if (((CoreMetadata)this.core.get((int)0)).sizeZ == 0 && this.getSizeT() != offsetCount) {
                ((CoreMetadata)this.core.get((int)0)).sizeT = 0;
            }
            textString = NativeND2Reader.sanitizeControl(textString);
            lines = textString.split(" ");
            for (int i = 0; i < lines.length; ++i) {
                String key = lines[i++];
                while (!key.endsWith(":") && key.indexOf("_") < 0 && i < lines.length) {
                    key = key + " " + lines[i++];
                    if (i < lines.length) continue;
                }
                if (i >= lines.length) break;
                String value = lines[i++];
                while (i < lines.length && lines[i].trim().length() > 0) {
                    value = value + " " + lines[i++];
                    if (i < lines.length) continue;
                }
                key = key.trim();
                key = key.substring(0, key.length() - 1);
                value = value.trim();
                if (key.startsWith("- Step")) {
                    int end = key.indexOf(" ", 8);
                    if (end < 0) {
                        end = key.length();
                    }
                    if (end >= 8) {
                        value = key.substring(8, end);
                        key = key.substring(0, 8);
                    }
                    try {
                        this.trueSizeZ = Double.parseDouble(DataTools.sanitizeDouble(value));
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.trace("Could not parse step", nfe);
                    }
                } else if (key.equals("Name")) {
                    this.textChannelNames.add(value);
                } else if (key.startsWith("Line:")) {
                    if (value.endsWith("Active")) {
                        int first = key.lastIndexOf(":") + 1;
                        int last = key.lastIndexOf(";");
                        try {
                            this.textEmissionWavelengths.add(new Integer(key.substring(first, last)) + 20);
                        }
                        catch (NumberFormatException nfe) {
                            LOGGER.trace("Could not parse emission wavelength", nfe);
                        }
                    }
                } else if (key.equals("Refractive Index")) {
                    try {
                        this.refractiveIndex = Double.parseDouble(DataTools.sanitizeDouble(value));
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.trace("Could not parse refractive index", nfe);
                    }
                }
                if (this.metadata.containsKey(key)) {
                    Object oldValue = this.metadata.get(key);
                    this.metadata.put(key + " #1", oldValue);
                    this.metadata.put(key + " #2", value);
                    this.metadata.remove(key);
                    continue;
                }
                if (this.metadata.containsKey(key + " #1")) {
                    int index = 1;
                    while (this.metadata.containsKey(key + " #" + index)) {
                        ++index;
                    }
                    this.metadata.put(key + " #" + index, value);
                    continue;
                }
                this.metadata.put(key, value);
            }
        }
    }
}

