/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.PositiveFloat;

public class OBFReader
extends FormatReader {
    private static final boolean LITTLE_ENDIAN = true;
    private static final String FILE_MAGIC_STRING = "OMAS_BF\n";
    private static final String STACK_MAGIC_STRING = "OMAS_BF_STACK\n";
    private static final short MAGIC_NUMBER = -1;
    private static final int FILE_VERSION = 1;
    private static final int STACK_VERSION = 3;
    private static final int MAXIMAL_NUMBER_OF_DIMENSIONS = 15;
    private List<Stack> stacks = new ArrayList<Stack>();
    private Frame currentInflatedFrame = new Frame();
    private transient Inflater inflater = new Inflater();

    public OBFReader() {
        super("OBF", new String[]{"obf", "msr"});
        this.suffixNecessary = false;
        this.suffixSufficient = false;
        this.datasetDescription = "OBF file";
    }

    private int getFileVersion(RandomAccessInputStream stream) throws IOException {
        stream.seek(0L);
        stream.order(true);
        try {
            String magicString = stream.readString(FILE_MAGIC_STRING.length());
            short magicNumber = stream.readShort();
            int version = stream.readInt();
            if (magicString.equals(FILE_MAGIC_STRING) && magicNumber == -1) {
                return version;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int fileVersion = this.getFileVersion(stream);
        return fileVersion >= 0 && fileVersion <= 1;
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.currentInflatedFrame.series = -1;
        this.currentInflatedFrame.number = -1;
        this.in = new RandomAccessInputStream(id);
        int fileVersion = this.getFileVersion(this.in);
        long stackPosition = this.in.readLong();
        int lengthOfDescription = this.in.readInt();
        String description = this.in.readString(lengthOfDescription);
        this.metadata.put("Description", description);
        if (stackPosition != 0L) {
            this.core.clear();
            while ((stackPosition = this.initStack(stackPosition, fileVersion)) != 0L) {
            }
        }
        MetadataStore ome = this.makeFilterMetadata();
        MetadataTools.populatePixels(ome, this);
        for (int series = 0; series != this.core.size(); ++series) {
            double lengthZ;
            double lengthY;
            double lengthX;
            CoreMetadata obf = (CoreMetadata)this.core.get(series);
            String name = obf.seriesMetadata.get("Name").toString();
            ome.setImageName(name, series);
            List lengths = (List)obf.seriesMetadata.get("Lengths");
            if (lengths.size() > 0 && (lengthX = Math.abs((Double)lengths.get(0))) > 0.0) {
                PositiveFloat physicalSizeX = new PositiveFloat(lengthX / (double)obf.sizeX);
                ome.setPixelsPhysicalSizeX(physicalSizeX, series);
            }
            if (lengths.size() > 1 && (lengthY = Math.abs((Double)lengths.get(1))) > 0.0) {
                PositiveFloat physicalSizeY = new PositiveFloat(lengthY / (double)obf.sizeY);
                ome.setPixelsPhysicalSizeY(physicalSizeY, series);
            }
            if (lengths.size() <= 2 || !((lengthZ = Math.abs((Double)lengths.get(2))) > 0.0)) continue;
            PositiveFloat physicalSizeZ = new PositiveFloat(lengthZ / (double)obf.sizeZ);
            ome.setPixelsPhysicalSizeZ(physicalSizeZ, series);
        }
    }

    private long initStack(long current, int fileVersion) throws FormatException, IOException {
        this.in.seek(current);
        String magicString = this.in.readString(STACK_MAGIC_STRING.length());
        short magicNumber = this.in.readShort();
        int version = this.in.readInt();
        if (magicString.equals(STACK_MAGIC_STRING) && magicNumber == -1 && version <= 3) {
            CoreMetadata obf = new CoreMetadata();
            this.core.add(obf);
            obf.littleEndian = true;
            obf.thumbnail = false;
            int numberOfDimensions = this.in.readInt();
            if (numberOfDimensions > 5) {
                throw new FormatException("Unsupported number of " + numberOfDimensions + " dimensions");
            }
            int[] sizes = new int[15];
            for (int dimension = 0; dimension != 15; ++dimension) {
                int size = this.in.readInt();
                sizes[dimension] = dimension < numberOfDimensions ? size : 1;
            }
            obf.sizeX = sizes[0];
            obf.sizeY = sizes[1];
            obf.sizeZ = sizes[2];
            obf.sizeC = sizes[3];
            obf.sizeT = sizes[4];
            obf.imageCount = sizes[2] * sizes[3] * sizes[4];
            obf.dimensionOrder = "XYZCT";
            obf.orderCertain = false;
            ArrayList<Double> lengths = new ArrayList<Double>();
            for (int dimension = 0; dimension != 15; ++dimension) {
                double length = this.in.readDouble();
                if (dimension >= numberOfDimensions) continue;
                lengths.add(new Double(length));
            }
            obf.seriesMetadata.put("Lengths", lengths);
            ArrayList<Double> offsets = new ArrayList<Double>();
            for (int dimension = 0; dimension != 15; ++dimension) {
                double offset = this.in.readDouble();
                if (dimension >= numberOfDimensions) continue;
                offsets.add(new Double(offset));
            }
            obf.seriesMetadata.put("Offsets", offsets);
            int type = this.in.readInt();
            obf.pixelType = this.getPixelType(type);
            obf.bitsPerPixel = this.getBitsPerPixel(type);
            obf.indexed = false;
            obf.rgb = false;
            obf.interleaved = false;
            Stack stack = new Stack();
            int compression = this.in.readInt();
            stack.compression = this.getCompression(compression);
            this.in.skipBytes(4);
            int lengthOfName = this.in.readInt();
            int lengthOfDescription = this.in.readInt();
            this.in.skipBytes(8);
            long lengthOfData = this.in.readLong();
            stack.length = this.getLength(lengthOfData);
            long next = this.in.readLong();
            String name = this.in.readString(lengthOfName);
            obf.seriesMetadata.put("Name", name);
            String description = this.in.readString(lengthOfDescription);
            obf.seriesMetadata.put("Description", description);
            stack.position = this.in.getFilePointer();
            this.stacks.add(stack);
            if (fileVersion >= 1) {
                this.in.skip(lengthOfData);
                long footer = this.in.getFilePointer();
                int offset = this.in.readInt();
                ArrayList<Boolean> stepsPresent = new ArrayList<Boolean>();
                for (int dimension = 0; dimension != 15; ++dimension) {
                    int present = this.in.readInt();
                    if (dimension >= numberOfDimensions) continue;
                    stepsPresent.add(new Boolean(present != 0));
                }
                ArrayList<Boolean> stepLabelsPresent = new ArrayList<Boolean>();
                for (int dimension = 0; dimension != 15; ++dimension) {
                    int present = this.in.readInt();
                    if (dimension >= numberOfDimensions) continue;
                    stepLabelsPresent.add(new Boolean(present != 0));
                }
                this.in.seek(footer + (long)offset);
                ArrayList<String> labels = new ArrayList<String>();
                for (int dimension = 0; dimension != numberOfDimensions; ++dimension) {
                    int length = this.in.readInt();
                    String label = this.in.readString(length);
                    labels.add(label);
                }
                obf.seriesMetadata.put("Labels", labels);
                ArrayList steps = new ArrayList();
                for (int dimension = 0; dimension != numberOfDimensions; ++dimension) {
                    ArrayList<Double> list = new ArrayList<Double>();
                    if (((Boolean)stepsPresent.get(dimension)).booleanValue()) {
                        for (int position = 0; position != sizes[dimension]; ++position) {
                            double step = this.in.readDouble();
                            list.add(new Double(step));
                        }
                    }
                    steps.add(list);
                }
                obf.seriesMetadata.put("Steps", steps);
                ArrayList stepLabels = new ArrayList();
                for (int dimension = 0; dimension != numberOfDimensions; ++dimension) {
                    ArrayList<String> list = new ArrayList<String>();
                    if (((Boolean)stepLabelsPresent.get(dimension)).booleanValue()) {
                        for (int position = 0; position != sizes[dimension]; ++position) {
                            int length = this.in.readInt();
                            String label = this.in.readString(length);
                            list.add(label);
                        }
                    }
                    stepLabels.add(list);
                }
                obf.seriesMetadata.put("StepLabels", stepLabels);
            }
            return next;
        }
        throw new FormatException("Unsupported stack format");
    }

    private int getPixelType(int type) throws FormatException {
        switch (type) {
            case 1: {
                return 1;
            }
            case 2: {
                return 0;
            }
            case 4: {
                return 3;
            }
            case 8: {
                return 2;
            }
            case 16: {
                return 5;
            }
            case 32: {
                return 4;
            }
            case 64: {
                return 6;
            }
            case 128: {
                return 7;
            }
        }
        throw new FormatException("Unsupported data type " + type);
    }

    private int getBitsPerPixel(int type) throws FormatException {
        switch (type) {
            case 1: 
            case 2: {
                return 8;
            }
            case 4: 
            case 8: {
                return 16;
            }
            case 16: 
            case 32: {
                return 32;
            }
            case 64: {
                return 32;
            }
            case 128: {
                return 64;
            }
        }
        throw new FormatException("Unsupported data type " + type);
    }

    private long getLength(long length) throws FormatException {
        if (length >= 0L) {
            return length;
        }
        throw new FormatException("Negative stack length on disk");
    }

    private boolean getCompression(int compression) throws FormatException {
        switch (compression) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw new FormatException("Unsupported compression " + compression);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] openBytes(int no, byte[] buffer, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buffer.length, x, y, w, h);
        int rows = this.getSizeY();
        int columns = this.getSizeX();
        int bytesPerPixel = this.getBitsPerPixel() / 8;
        int series = this.getSeries();
        Stack stack = this.stacks.get(series);
        if (stack.compression) {
            if (series != this.currentInflatedFrame.series) {
                this.currentInflatedFrame.bytes = new byte[rows * columns * bytesPerPixel];
                this.currentInflatedFrame.series = series;
                this.currentInflatedFrame.number = -1;
            }
            byte[] bytes = this.currentInflatedFrame.bytes;
            if (no != this.currentInflatedFrame.number) {
                if (no < this.currentInflatedFrame.number) {
                    this.currentInflatedFrame.number = -1;
                }
                if (this.currentInflatedFrame.number == -1) {
                    this.in.seek(stack.position);
                    this.inflater.reset();
                }
                byte[] input = new byte[8192];
                while (no != this.currentInflatedFrame.number) {
                    for (int offset = 0; offset != bytes.length; offset += this.inflater.inflate(bytes, offset, bytes.length - offset)) {
                        if (this.inflater.needsInput()) {
                            long remainder = stack.position + stack.length - this.in.getFilePointer();
                            if (remainder <= 0L) throw new FormatException("Corrupted zlib compression");
                            int length = remainder > (long)input.length ? input.length : (int)remainder;
                            this.in.read(input, 0, length);
                            this.inflater.setInput(input, 0, length);
                        } else if (this.inflater.needsDictionary()) {
                            throw new FormatException("Unsupported zlib compression");
                        }
                        try {
                            continue;
                        }
                        catch (DataFormatException exception) {
                            throw new FormatException(exception.getMessage());
                        }
                    }
                    ++this.currentInflatedFrame.number;
                }
            }
            for (int row = 0; row != h; ++row) {
                System.arraycopy(bytes, ((row + y) * columns + x) * bytesPerPixel, buffer, row * w * bytesPerPixel, w * bytesPerPixel);
            }
            return buffer;
        } else {
            for (int row = 0; row != h; ++row) {
                this.in.seek(stack.position + (long)(((no * rows + row + y) * columns + x) * bytesPerPixel));
                this.in.read(buffer, row * w * bytesPerPixel, w * bytesPerPixel);
            }
        }
        return buffer;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        this.stacks = new ArrayList<Stack>();
        this.currentInflatedFrame = new Frame();
        this.inflater = new Inflater();
        super.close(fileOnly);
    }

    private class Frame {
        byte[] bytes;
        int series;
        int number;

        private Frame() {
        }
    }

    private class Stack {
        long position;
        long length;
        boolean compression;

        private Stack() {
        }
    }
}

