/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.Timestamp;

public class PDSReader
extends FormatReader {
    private static final String PDS_MAGIC_STRING = " IDENTIFICATION";
    private static final String DATE_FORMAT = "HH:mm:ss  d-MMM-** yyyy";
    private String pixelsFile;
    private int recordWidth;
    private int lutIndex = -1;
    private boolean reverseX = false;
    private boolean reverseY = false;

    public PDSReader() {
        super("Perkin Elmer Densitometer", new String[]{"hdr", "img"});
        this.domains = new String[]{"Electron Microscopy (EM)"};
        this.suffixSufficient = false;
        this.hasCompanionFiles = true;
        this.datasetDescription = "One .hdr file and a similarly-named .img file";
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        if (!open) {
            return false;
        }
        if (PDSReader.checkSuffix(name, "hdr")) {
            return super.isThisType(name, open);
        }
        if (PDSReader.checkSuffix(name, "img")) {
            String headerFile = name.substring(0, name.lastIndexOf(".")) + ".hdr";
            return new Location(headerFile).exists() && this.isThisType(headerFile, open);
        }
        return false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 15;
        if (!FormatTools.validStream(stream, 15, false)) {
            return false;
        }
        return stream.readString(15).equals(PDS_MAGIC_STRING);
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.lutIndex < 0 || this.lutIndex >= 3) {
            return null;
        }
        short[][] lut = new short[3][65536];
        for (int i = 0; i < lut[this.lutIndex].length; ++i) {
            lut[this.lutIndex][i] = (short)i;
        }
        return lut;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            return new String[]{this.currentId};
        }
        return new String[]{this.currentId, this.pixelsFile};
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        int end;
        int row;
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int pad = this.recordWidth - this.getSizeX() % this.recordWidth;
        RandomAccessInputStream pixels = new RandomAccessInputStream(this.pixelsFile);
        int realX = this.reverseX ? this.getSizeX() - w - x : x;
        int realY = this.reverseY ? this.getSizeY() - h - y : y;
        this.readPlane(pixels, realX, realY, w, h, pad, buf);
        pixels.close();
        if (this.reverseX) {
            for (row = 0; row < h; ++row) {
                for (int col = 0; col < w / 2; ++col) {
                    int begin = 2 * (row * w + col);
                    end = 2 * (row * w + (w - col - 1));
                    byte b0 = buf[begin];
                    byte b1 = buf[begin + 1];
                    buf[begin] = buf[end];
                    buf[begin + 1] = buf[end + 1];
                    buf[end] = b0;
                    buf[end + 1] = b1;
                }
            }
        }
        if (this.reverseY) {
            for (row = 0; row < h / 2; ++row) {
                byte[] b = new byte[w * 2];
                int start = row * w * 2;
                end = (h - row - 1) * w * 2;
                System.arraycopy(buf, start, b, 0, b.length);
                System.arraycopy(buf, end, buf, start, b.length);
                System.arraycopy(b, 0, buf, end, b.length);
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.recordWidth = 0;
            this.pixelsFile = null;
            this.lutIndex = -1;
            this.reverseY = false;
            this.reverseX = false;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        if (!PDSReader.checkSuffix(id, "hdr")) {
            String headerFile = id.substring(0, id.lastIndexOf(".")) + ".hdr";
            if (!new Location(headerFile).exists() && !new Location(headerFile = id.substring(0, id.lastIndexOf(".")) + ".HDR").exists()) {
                throw new FormatException("Could not find matching .hdr file.");
            }
            this.initFile(headerFile);
            return;
        }
        super.initFile(id);
        String[] headerData = DataTools.readFile(id).split("\r\n");
        if (headerData.length == 1) {
            headerData = headerData[0].split("\r");
        }
        Double xPos = null;
        Double yPos = null;
        Double deltaX = null;
        Double deltaY = null;
        String date = null;
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        for (String line : headerData) {
            int eq = line.indexOf("=");
            if (eq < 0) continue;
            int end = line.indexOf("/");
            if (end < 0) {
                end = line.length();
            }
            String key = line.substring(0, eq).trim();
            String value = line.substring(eq + 1, end).trim();
            if (key.equals("NXP")) {
                m.sizeX = Integer.parseInt(value);
            } else if (key.equals("NYP")) {
                m.sizeY = Integer.parseInt(value);
            } else if (key.equals("XPOS")) {
                xPos = new Double(value);
                this.addGlobalMeta("X position for position #1", xPos);
            } else if (key.equals("YPOS")) {
                yPos = new Double(value);
                this.addGlobalMeta("Y position for position #1", yPos);
            } else if (key.equals("SIGNX")) {
                this.reverseX = value.replaceAll("'", "").trim().equals("-");
            } else if (key.equals("SIGNY")) {
                this.reverseY = value.replaceAll("'", "").trim().equals("-");
            } else if (key.equals("DELTAX")) {
                deltaX = new Double(value);
            } else if (key.equals("DELTAY")) {
                deltaY = new Double(value);
            } else if (key.equals("COLOR")) {
                int color = Integer.parseInt(value);
                if (color == 4) {
                    m.sizeC = 3;
                    m.rgb = true;
                } else {
                    m.sizeC = 1;
                    m.rgb = false;
                    this.lutIndex = color - 1;
                    m.indexed = this.lutIndex >= 0;
                }
            } else if (key.equals("SCAN TIME")) {
                long modTime = new Location(this.currentId).getAbsoluteFile().lastModified();
                String year = DateTools.convertDate(modTime, 0, "yyyy");
                date = value.replaceAll("'", "") + " " + year;
                date = DateTools.formatDate(date, DATE_FORMAT);
            } else if (key.equals("FILE REC LEN")) {
                this.recordWidth = Integer.parseInt(value) / 2;
            }
            this.addGlobalMeta(key, value);
        }
        m.sizeZ = 1;
        m.sizeT = 1;
        m.imageCount = 1;
        m.dimensionOrder = "XYCZT";
        m.pixelType = 3;
        m.littleEndian = true;
        String base = this.currentId.substring(0, this.currentId.lastIndexOf("."));
        this.pixelsFile = base + ".IMG";
        if (!new Location(this.pixelsFile).exists()) {
            this.pixelsFile = base + ".img";
        }
        boolean minimumMetadata = this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, !minimumMetadata);
        if (date != null) {
            store.setImageAcquisitionDate(new Timestamp(date), 0);
        }
        if (!minimumMetadata) {
            store.setPlanePositionX(xPos, 0, 0);
            store.setPlanePositionY(yPos, 0, 0);
            PositiveFloat sizeX = FormatTools.getPhysicalSizeX(deltaX);
            PositiveFloat sizeY = FormatTools.getPhysicalSizeY(deltaY);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
        }
    }
}

