/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.PositiveFloat;

public class PQBinReader
extends FormatReader {
    public static final int HEADER_SIZE = 20;
    protected int timeBins;
    protected byte[] dataStore = null;
    protected boolean preLoad = true;

    public PQBinReader() {
        super("PicoQuant Bin", "bin");
        this.domains = new String[]{"Fluorescence-Lifetime Imaging"};
        this.suffixSufficient = false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        long fileLength = stream.length();
        int bpp = FormatTools.getBytesPerPixel(5);
        stream.order(true);
        int sizeX = stream.readInt();
        int sizeY = stream.readInt();
        float pixResol = stream.readFloat();
        int sizeT = stream.readInt();
        return (long)(sizeX * sizeY * sizeT * bpp + 20) == fileLength;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int sizeX = this.getSizeX();
        int sizeY = this.getSizeY();
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        boolean little = this.isLittleEndian();
        int planeSize = sizeX * sizeY * this.timeBins * bpp;
        int timeBin = no;
        int binSize = sizeX * sizeY * bpp;
        if (this.preLoad) {
            int input;
            if (this.dataStore == null) {
                this.dataStore = new byte[planeSize];
                byte[] rowBuf = new byte[bpp * this.timeBins * sizeX];
                this.in.seek(20L);
                for (int row = 0; row < sizeY; ++row) {
                    this.in.read(rowBuf);
                    input = 0;
                    for (int col = 0; col < sizeX; ++col) {
                        int output = (row * sizeX + col) * bpp;
                        for (int t = 0; t < this.timeBins; ++t) {
                            for (int bb = 0; bb < bpp; ++bb) {
                                this.dataStore[output + bb] = rowBuf[input + bb];
                            }
                            output += binSize;
                            input += bpp;
                        }
                    }
                }
            }
            int iLineSize = sizeX * bpp;
            int oLineSize = w * bpp;
            input = binSize * timeBin + y * iLineSize + x * bpp;
            int output = 0;
            for (int row = 0; row < h; ++row) {
                System.arraycopy(this.dataStore, input, buf, output, oLineSize);
                input += iLineSize;
                output += oLineSize;
            }
        } else {
            byte[] rowBuf = new byte[bpp * this.timeBins * w];
            this.in.seek(20 + y * sizeX * bpp * this.timeBins);
            for (int row = 0; row < h; ++row) {
                this.in.skipBytes(x * bpp * this.timeBins);
                this.in.read(rowBuf);
                for (int col = 0; col < w; ++col) {
                    int output = (row * w + col) * bpp;
                    int input = (col * this.timeBins + timeBin) * bpp;
                    for (int bb = 0; bb < bpp; ++bb) {
                        buf[output + bb] = rowBuf[input + bb];
                    }
                }
                this.in.skipBytes(bpp * this.timeBins * (sizeX - x - w));
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.dataStore = null;
            this.timeBins = 0;
            this.preLoad = true;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        m.littleEndian = true;
        this.in.order(this.isLittleEndian());
        LOGGER.info("Reading header PQBin");
        m.sizeX = this.in.readInt();
        m.sizeY = this.in.readInt();
        float pixResol = this.in.readFloat();
        m.sizeT = this.in.readInt();
        float timeResol = this.in.readFloat();
        this.timeBins = m.sizeT;
        m.sizeZ = 1;
        m.sizeC = 1;
        m.dimensionOrder = "XYZCT";
        m.pixelType = 5;
        m.rgb = false;
        m.imageCount = m.sizeT;
        m.indexed = false;
        m.falseColor = false;
        m.metadataComplete = true;
        m.moduloT.type = "Lifetime";
        m.moduloT.parentType = "Spectra";
        m.moduloT.typeDescription = "TCSPC";
        m.moduloT.start = 0.0;
        float timeBase = timeResol * 1000.0f;
        m.moduloT.step = timeBase / (float)this.timeBins;
        m.moduloT.end = m.moduloT.step * (double)(m.sizeT - 1);
        m.moduloT.unit = "ps";
        this.preLoad = m.sizeX * m.sizeY * m.sizeT <= 36000000;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        PositiveFloat pRpf = new PositiveFloat(Double.valueOf(pixResol));
        store.setPixelsPhysicalSizeX(pRpf, 0);
        store.setPixelsPhysicalSizeY(pRpf, 0);
    }
}

