/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.PositiveFloat;

public class RHKReader
extends FormatReader {
    private static final int HEADER_SIZE = 512;
    private boolean invertX = false;
    private boolean invertY = false;
    private long pixelOffset = 0L;

    public RHKReader() {
        super("RHK Technologies", new String[]{"sm2", "sm3"});
        this.domains = new String[]{"Scanning Probe Microscopy (SPM)"};
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        int row;
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(this.pixelOffset);
        int realX = this.invertX ? this.getSizeX() - x - w : x;
        int realY = this.invertY ? this.getSizeY() - y - h : y;
        this.readPlane(this.in, realX, realY, w, h, buf);
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        if (this.invertY) {
            byte[] rowBuf = new byte[w * bpp];
            for (row = 0; row < h / 2; ++row) {
                int top = row * rowBuf.length;
                int bottom = (h - row - 1) * rowBuf.length;
                System.arraycopy(buf, top, rowBuf, 0, rowBuf.length);
                System.arraycopy(buf, bottom, buf, top, rowBuf.length);
                System.arraycopy(rowBuf, 0, buf, bottom, rowBuf.length);
            }
        }
        if (this.invertX) {
            byte[] pixel = new byte[bpp];
            for (row = 0; row < h; ++row) {
                for (int col = 0; col < w / 2; ++col) {
                    int left = row * w * bpp + col * bpp;
                    int right = row * w * bpp + (w - col - 1) * bpp;
                    System.arraycopy(buf, left, pixel, 0, bpp);
                    System.arraycopy(buf, right, buf, left, bpp);
                    System.arraycopy(pixel, 0, buf, right, bpp);
                }
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.invertX = false;
            this.invertY = false;
            this.pixelOffset = 0L;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        int lineType;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        m.littleEndian = true;
        this.in.order(this.isLittleEndian());
        boolean xpm = this.in.readShort() == 170;
        int dataType = -1;
        if (xpm) {
            this.in.seek(40L);
            int imageType = this.in.readInt();
            int pageType = this.in.readInt();
            dataType = this.in.readInt();
            lineType = this.in.readInt();
            this.in.skipBytes(8);
            m.sizeX = this.in.readInt();
            m.sizeY = this.in.readInt();
            this.in.skipBytes(16);
            this.pixelOffset = this.in.readInt();
        } else {
            this.in.seek(32L);
            String[] typeData = this.in.readString(32).trim().split(" ");
            int imageType = Integer.parseInt(typeData[0]);
            dataType = Integer.parseInt(typeData[1]);
            lineType = Integer.parseInt(typeData[2]);
            m.sizeX = Integer.parseInt(typeData[3]);
            m.sizeY = Integer.parseInt(typeData[4]);
            int pageType = Integer.parseInt(typeData[6]);
            this.pixelOffset = 512L;
        }
        switch (dataType) {
            case 0: {
                m.pixelType = 6;
                break;
            }
            case 1: {
                m.pixelType = 2;
                break;
            }
            case 2: {
                m.pixelType = 4;
                break;
            }
            case 3: {
                m.pixelType = 1;
                break;
            }
            default: {
                throw new FormatException("Unsupported data type: " + dataType);
            }
        }
        double xScale = 0.0;
        double yScale = 0.0;
        if (xpm) {
            this.in.skipBytes(8);
            xScale = this.in.readFloat() * 1000000.0f;
            yScale = this.in.readFloat() * 1000000.0f;
        } else {
            String[] xAxis = this.in.readString(32).trim().split(" ");
            String[] yAxis = this.in.readString(32).trim().split(" ");
            xScale = Double.parseDouble(xAxis[1]) * 1000000.0;
            yScale = Double.parseDouble(yAxis[1]) * 1000000.0;
            this.invertX = xScale < 0.0;
            this.invertY = yScale > 0.0;
        }
        this.in.seek(352L);
        String description = this.in.readString(32).trim();
        this.addGlobalMeta("Description", description);
        m.rgb = false;
        m.sizeZ = 1;
        m.sizeC = 1;
        m.sizeT = 1;
        m.imageCount = 1;
        m.dimensionOrder = "XYZCT";
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            PositiveFloat sizeX = FormatTools.getPhysicalSizeX(xScale);
            PositiveFloat sizeY = FormatTools.getPhysicalSizeY(yScale);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
            store.setImageDescription(description, 0);
        }
    }
}

