/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.SDTInfo;
import loci.formats.meta.MetadataStore;

public class SDTReader
extends FormatReader {
    protected SDTInfo info;
    protected int timeBins;
    protected int channels;
    protected boolean intensity = false;
    protected boolean preLoad = true;
    protected byte[] chanStore = null;
    protected int storedChannel = -1;
    protected int storedSeries = -1;

    public SDTReader() {
        super("SPCImage Data", "sdt");
        this.domains = new String[]{"Fluorescence-Lifetime Imaging"};
    }

    public void setIntensity(boolean intensity) {
        FormatTools.assertId(this.currentId, false, 1);
        this.intensity = intensity;
    }

    public void setPreLoad(boolean preLoad) {
        this.preLoad = preLoad;
    }

    public boolean isIntensity() {
        return this.intensity;
    }

    public int getTimeBinCount() {
        return this.timeBins;
    }

    public int getChannelCount() {
        return this.channels;
    }

    public SDTInfo getInfo() {
        return this.info;
    }

    @Override
    public boolean isInterleaved(int subC) {
        FormatTools.assertId(this.currentId, true, 1);
        return !this.intensity && subC == 0;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        int row;
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int sizeX = this.getSizeX();
        int sizeY = this.getSizeY();
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        boolean little = this.isLittleEndian();
        int paddedWidth = sizeX + (4 - sizeX % 4) % 4;
        int planeSize = paddedWidth * sizeY * this.timeBins * bpp;
        if (this.preLoad && !this.intensity) {
            int output;
            int channel = no / this.timeBins;
            int timeBin = no % this.timeBins;
            byte[] rowBuf = new byte[bpp * this.timeBins * paddedWidth];
            int binSize = paddedWidth * sizeY * bpp;
            if (this.chanStore == null || this.storedChannel != channel || this.storedSeries != this.getSeries()) {
                this.chanStore = new byte[planeSize];
                this.in.seek(this.info.allBlockOffsets[this.getSeries()] + (long)(channel * planeSize));
                for (int row2 = 0; row2 < sizeY; ++row2) {
                    this.in.read(rowBuf);
                    int input = 0;
                    for (int col = 0; col < paddedWidth; ++col) {
                        output = (row2 * paddedWidth + col) * bpp;
                        for (int t = 0; t < this.timeBins; ++t) {
                            for (int bb = 0; bb < bpp; ++bb) {
                                this.chanStore[output + bb] = rowBuf[input + bb];
                            }
                            output += binSize;
                            input += bpp;
                        }
                    }
                }
                this.storedChannel = channel;
                this.storedSeries = this.getSeries();
            }
            int iLineSize = paddedWidth * bpp;
            int oLineSize = w * bpp;
            int input = binSize * timeBin + y * iLineSize + x * bpp;
            output = 0;
            for (int row3 = 0; row3 < h; ++row3) {
                System.arraycopy(this.chanStore, input, buf, output, oLineSize);
                input += iLineSize;
                output += oLineSize;
            }
            if (this.info.incr > 1) {
                short incr = this.info.incr;
                ByteBuffer bb = ByteBuffer.wrap(buf);
                bb.order(ByteOrder.LITTLE_ENDIAN);
                for (int i = 0; i < buf.length; i += 2) {
                    short s = bb.getShort(i);
                    if (s > 0) {
                        bb.putShort(i, (short)(s / incr));
                        continue;
                    }
                    int ii = s & 0xFFFF;
                    bb.putShort(i, (short)(ii / incr));
                }
            }
            return buf;
        }
        int channel = this.intensity ? no : no / this.timeBins;
        int timeBin = this.intensity ? 0 : no % this.timeBins;
        byte[] b = !this.intensity ? buf : new byte[sizeY * sizeX * this.timeBins * bpp];
        byte[] rowBuf = new byte[bpp * this.timeBins * w];
        this.in.seek(this.info.allBlockOffsets[this.getSeries()] + (long)(channel * planeSize) + (long)(y * paddedWidth * bpp * this.timeBins));
        for (row = 0; row < h; ++row) {
            this.in.skipBytes(x * bpp * this.timeBins);
            this.in.read(rowBuf);
            if (this.intensity) {
                System.arraycopy(rowBuf, 0, b, row * bpp * this.timeBins * w, b.length);
            } else {
                for (int col = 0; col < w; ++col) {
                    int output = (row * w + col) * bpp;
                    int input = (col * this.timeBins + timeBin) * bpp;
                    for (int bb = 0; bb < bpp; ++bb) {
                        b[output + bb] = rowBuf[input + bb];
                    }
                }
            }
            this.in.skipBytes(bpp * this.timeBins * (paddedWidth - x - w));
        }
        if (!this.intensity) {
            return buf;
        }
        for (row = 0; row < h; ++row) {
            int yi = (y + row) * sizeX * this.timeBins * bpp;
            int ri = row * w * bpp;
            for (int col = 0; col < w; ++col) {
                int xi = yi + (x + col) * this.timeBins * bpp;
                int ci = ri + col * bpp;
                int sum = 0;
                for (int t = 0; t < this.timeBins; ++t) {
                    sum = (short)(sum + DataTools.bytesToShort(b, xi + t * bpp, little));
                }
                DataTools.unpackBytes(sum, buf, ci, 2, little);
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.preLoad = true;
            this.chanStore = null;
            this.storedChannel = -1;
            this.storedSeries = -1;
            this.channels = 0;
            this.timeBins = 0;
            this.info = null;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.in.order(true);
        LOGGER.info("Reading header");
        this.info = new SDTInfo(this.in, this.metadata);
        this.timeBins = this.info.timeBins;
        this.channels = this.info.channels;
        this.addGlobalMeta("time bins", this.timeBins);
        this.addGlobalMeta("channels", this.channels);
        double timeBase = 1.0E9 * (double)this.info.tacR / (double)this.info.tacG;
        this.addGlobalMeta("time base", timeBase);
        LOGGER.info("Populating metadata");
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        int timepoints = this.info.timepoints;
        if (timepoints == 0) {
            timepoints = 1;
        }
        m.sizeX = this.info.width;
        m.sizeY = this.info.height;
        m.sizeZ = 1;
        m.sizeT = this.intensity ? timepoints : this.timeBins * timepoints;
        m.sizeC = this.channels;
        m.dimensionOrder = "XYZTC";
        m.pixelType = 3;
        m.rgb = false;
        m.littleEndian = true;
        m.imageCount = m.sizeZ * m.sizeC * m.sizeT;
        m.indexed = false;
        m.falseColor = false;
        m.metadataComplete = true;
        this.preLoad = m.sizeX * m.sizeY * m.sizeT <= 0x8000000;
        if (this.intensity) {
            m.moduloT.parentType = "Spectra";
        } else {
            m.moduloT.type = "Lifetime";
            m.moduloT.parentType = "Spectra";
            m.moduloT.typeDescription = "TCSPC";
            m.moduloT.start = 0.0;
            m.moduloT.step = (timeBase *= 1000.0) / (double)this.timeBins;
            m.moduloT.end = m.moduloT.step * (double)(m.sizeT - 1);
            m.moduloT.unit = "ps";
        }
        for (int i = 1; i < this.info.allBlockOffsets.length; ++i) {
            this.core.add(m);
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }
}

