/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.TiffCompression;
import ome.xml.model.primitives.PositiveFloat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TiffReader
extends BaseTiffReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(TiffReader.class);
    public static final String[] TIFF_SUFFIXES = new String[]{"tif", "tiff", "tf2", "tf8", "btf"};
    public static final String[] COMPANION_SUFFIXES = new String[]{"xml", "txt"};
    public static final int IMAGEJ_TAG = 50839;
    private String companionFile;
    private String description;
    private String calibrationUnit;
    private Double physicalSizeZ;
    private Double timeIncrement;
    private Integer xOrigin;
    private Integer yOrigin;

    public TiffReader() {
        super("Tagged Image File Format", TIFF_SUFFIXES);
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        if (noPixels) {
            String[] stringArray;
            if (this.companionFile == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.companionFile;
            }
            return stringArray;
        }
        if (this.companionFile != null) {
            return new String[]{this.companionFile, this.currentId};
        }
        return new String[]{this.currentId};
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.companionFile = null;
            this.description = null;
            this.calibrationUnit = null;
            this.physicalSizeZ = null;
            this.timeIncrement = null;
            this.xOrigin = null;
            this.yOrigin = null;
        }
    }

    @Override
    protected void initStandardMetadata() throws FormatException, IOException {
        boolean metamorph;
        boolean ij;
        super.initStandardMetadata();
        String comment = ((IFD)this.ifds.get(0)).getComment();
        LOGGER.info("Checking comment style");
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        if (this.ifds.size() > 1) {
            m.orderCertain = false;
        }
        this.description = null;
        this.calibrationUnit = null;
        this.physicalSizeZ = null;
        this.timeIncrement = null;
        this.xOrigin = null;
        this.yOrigin = null;
        MetadataLevel level = this.getMetadataOptions().getMetadataLevel();
        if (level != MetadataLevel.MINIMUM) {
            Integer[] tags;
            for (Integer tag : tags = ((IFD)this.ifds.get(0)).keySet().toArray(new Integer[0])) {
                Object value;
                if (tag < 65000 || !((value = ((IFD)this.ifds.get(0)).get(tag)) instanceof short[])) continue;
                short[] s = (short[])value;
                byte[] b = new byte[s.length];
                for (int i = 0; i < b.length; ++i) {
                    b[i] = (byte)s[i];
                }
                String metadata = DataTools.stripString(new String(b, "UTF-8"));
                if (metadata.indexOf("xml") != -1) {
                    metadata = metadata.substring(metadata.indexOf("<"));
                    metadata = "<root>" + XMLTools.sanitizeXML(metadata) + "</root>";
                    try {
                        Hashtable<String, String> xmlMetadata = XMLTools.parseXML(metadata);
                        for (String key : xmlMetadata.keySet()) {
                            this.addGlobalMeta(key, xmlMetadata.get(key));
                        }
                        continue;
                    }
                    catch (IOException e) {
                        continue;
                    }
                }
                this.addGlobalMeta(tag.toString(), metadata);
            }
        }
        if (ij = this.checkCommentImageJ(comment)) {
            this.parseCommentImageJ(comment);
        }
        if ((metamorph = this.checkCommentMetamorph(comment)) && level != MetadataLevel.MINIMUM) {
            this.parseCommentMetamorph(comment);
        }
        this.put("MetaMorph", metamorph ? "yes" : "no");
        if (!ij && !metamorph && level != MetadataLevel.MINIMUM) {
            this.parseCommentGeneric(comment);
        }
        if (this.isGroupFiles()) {
            Location currentFile = new Location(this.currentId).getAbsoluteFile();
            String currentName = currentFile.getName();
            Location directory = currentFile.getParentFile();
            String[] files = directory.list(true);
            if (files != null) {
                for (String file2 : files) {
                    String name = file2;
                    if (name.indexOf(".") != -1) {
                        name = name.substring(0, name.indexOf("."));
                    }
                    if (!currentName.startsWith(name) || !TiffReader.checkSuffix(name, COMPANION_SUFFIXES)) continue;
                    this.companionFile = new Location(directory, file2).getAbsolutePath();
                    break;
                }
            }
        }
    }

    @Override
    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        if (this.description != null) {
            this.description = this.description.replaceAll("\n", "; ");
            store.setImageDescription(this.description, 0);
        }
        this.populateMetadataStoreImageJ(store);
    }

    private boolean checkCommentImageJ(String comment) {
        return comment != null && comment.startsWith("ImageJ=");
    }

    private boolean checkCommentMetamorph(String comment) {
        String software = ((IFD)this.ifds.get(0)).getIFDTextValue(305);
        return comment != null && software != null && software.indexOf("MetaMorph") != -1;
    }

    private void parseCommentImageJ(String comment) throws FormatException, IOException {
        int nl = comment.indexOf("\n");
        this.put("ImageJ", nl < 0 ? comment.substring(7) : comment.substring(7, nl));
        this.metadata.remove("Comment");
        this.description = "";
        int z = 1;
        int t = 1;
        int c = this.getSizeC();
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        if (((IFD)this.ifds.get(0)).containsKey(50839)) {
            comment = comment + "\n" + ((IFD)this.ifds.get(0)).getIFDTextValue(50839);
        }
        StringTokenizer st = new StringTokenizer(comment, "\n");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            String value = null;
            int eq = token.indexOf("=");
            if (eq >= 0) {
                value = token.substring(eq + 1);
            }
            if (token.startsWith("channels=")) {
                c = this.parseInt(value);
                continue;
            }
            if (token.startsWith("slices=")) {
                z = this.parseInt(value);
                continue;
            }
            if (token.startsWith("frames=")) {
                t = this.parseInt(value);
                continue;
            }
            if (token.startsWith("mode=")) {
                this.put("Color mode", value);
                continue;
            }
            if (token.startsWith("unit=")) {
                this.calibrationUnit = value;
                this.put("Unit", this.calibrationUnit);
                continue;
            }
            if (token.startsWith("finterval=")) {
                this.timeIncrement = this.parseDouble(value);
                this.put("Frame Interval", this.timeIncrement);
                continue;
            }
            if (token.startsWith("spacing=")) {
                this.physicalSizeZ = this.parseDouble(value);
                this.put("Spacing", this.physicalSizeZ);
                continue;
            }
            if (token.startsWith("xorigin=")) {
                this.xOrigin = this.parseInt(value);
                this.put("X Origin", this.xOrigin);
                continue;
            }
            if (token.startsWith("yorigin=")) {
                this.yOrigin = this.parseInt(value);
                this.put("Y Origin", this.yOrigin);
                continue;
            }
            if (eq <= 0) continue;
            this.put(token.substring(0, eq).trim(), value);
        }
        if (z * c * t == c && this.isRGB()) {
            t = this.getImageCount();
        }
        m.dimensionOrder = "XYCZT";
        if (z * t * (this.isRGB() ? 1 : c) == this.ifds.size()) {
            m.sizeZ = z;
            m.sizeT = t;
            m.sizeC = this.isRGB() ? this.getSizeC() : c;
        } else if (z * c * t == this.ifds.size() && this.isRGB()) {
            m.sizeZ = z;
            m.sizeT = t;
            m.sizeC *= c;
        } else if (this.ifds.size() == 1 && z * t > this.ifds.size() && ((IFD)this.ifds.get(0)).getCompression() == TiffCompression.UNCOMPRESSED) {
            IFD firstIFD = (IFD)this.ifds.get(0);
            int planeSize = this.getSizeX() * this.getSizeY() * this.getRGBChannelCount() * FormatTools.getBytesPerPixel(this.getPixelType());
            long[] stripOffsets = firstIFD.getStripOffsets();
            long[] stripByteCounts = firstIFD.getStripByteCounts();
            long endOfFirstPlane = stripOffsets[stripOffsets.length - 1] + stripByteCounts[stripByteCounts.length - 1];
            long totalBytes = this.in.length() - endOfFirstPlane;
            int totalPlanes = (int)(totalBytes / (long)planeSize) + 1;
            this.ifds = new IFDList();
            this.ifds.add(firstIFD);
            for (int i = 1; i < totalPlanes; ++i) {
                IFD ifd = new IFD(firstIFD);
                this.ifds.add(ifd);
                long[] prevOffsets = ((IFD)this.ifds.get(i - 1)).getStripOffsets();
                long[] offsets = new long[stripOffsets.length];
                offsets[0] = prevOffsets[prevOffsets.length - 1] + stripByteCounts[stripByteCounts.length - 1];
                for (int j = 1; j < offsets.length; ++j) {
                    offsets[j] = offsets[j - 1] + stripByteCounts[j - 1];
                }
                ifd.putIFDValue(273, offsets);
            }
            if (z * c * t == this.ifds.size()) {
                m.sizeZ = z;
                m.sizeT = t;
                m.sizeC = c;
            } else if (z * t == this.ifds.size()) {
                m.sizeZ = z;
                m.sizeT = t;
            } else {
                m.sizeZ = this.ifds.size();
            }
            m.imageCount = this.ifds.size();
        } else {
            m.sizeT = this.ifds.size();
            m.imageCount = this.ifds.size();
        }
    }

    private void populateMetadataStoreImageJ(MetadataStore store) {
        if (this.physicalSizeZ != null) {
            PositiveFloat z;
            double zDepth = this.physicalSizeZ;
            if (zDepth < 0.0) {
                zDepth = -zDepth;
            }
            if ((z = FormatTools.getPhysicalSizeZ(zDepth)) != null) {
                store.setPixelsPhysicalSizeZ(z, 0);
            }
        }
        if (this.timeIncrement != null) {
            store.setPixelsTimeIncrement(this.timeIncrement, 0);
        }
    }

    private void parseCommentMetamorph(String comment) {
        StringTokenizer st = new StringTokenizer(comment, "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            int colon = line.indexOf(":");
            if (colon < 0) {
                this.addGlobalMeta("Comment", line);
                this.description = line;
                continue;
            }
            String key = line.substring(0, colon);
            String value = line.substring(colon + 1);
            this.addGlobalMeta(key, value);
        }
    }

    private void parseCommentGeneric(String comment) {
        if (comment == null) {
            return;
        }
        String[] lines = comment.split("\n");
        if (lines.length > 1) {
            comment = "";
            for (String line : lines) {
                int eq = line.indexOf("=");
                if (eq != -1) {
                    String key = line.substring(0, eq).trim();
                    String value = line.substring(eq + 1).trim();
                    this.addGlobalMeta(key, value);
                    continue;
                }
                if (line.startsWith("[")) continue;
                comment = comment + line + "\n";
            }
            this.addGlobalMeta("Comment", comment);
            this.description = comment;
        }
    }

    private int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            LOGGER.debug("Failed to parse integer value", e);
            return 0;
        }
    }

    private double parseDouble(String s) {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            LOGGER.debug("Failed to parse floating point value", e);
            return 0.0;
        }
    }
}

