/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import loci.common.ByteArrayHandle;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.MissingLibraryException;
import loci.formats.codec.LZOCodec;
import loci.formats.meta.MetadataStore;
import loci.formats.services.MetakitService;
import ome.xml.model.primitives.PositiveFloat;

public class VolocityReader
extends FormatReader {
    private static final String DATA_DIR = "Data";
    private static final String EMBEDDED_STREAM = "embedded-stream.raw";
    private static final int SIGNATURE_SIZE = 13;
    private ArrayList<Stack> stacks;
    private ArrayList<String> extraFiles;
    private Object[][] sampleTable;
    private Object[][] stringTable;
    private Location dir = null;
    private ArrayList<Double[]> timestamps = new ArrayList();

    public VolocityReader() {
        super("Volocity Library", new String[]{"mvd2", "aisf", "aiix", "dat", "atsf"});
        this.domains = new String[]{"Unknown"};
        this.hasCompanionFiles = true;
        this.datasetDescription = "One .mvd2 file plus a 'Data' directory";
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        ArrayList<String> files = new ArrayList<String>();
        files.addAll(this.extraFiles);
        if (!noPixels) {
            Stack stack = this.stacks.get(this.getSeries());
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                files.add(stack.pixelsFiles[c]);
            }
            if (stack.timestampFile != null) {
                files.add(stack.timestampFile);
            }
        }
        return files.toArray(new String[files.size()]);
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        if (VolocityReader.checkSuffix(name, "mvd2")) {
            return super.isThisType(name, open);
        }
        if (open && VolocityReader.checkSuffix(name, this.suffixes)) {
            Location file2 = new Location(name).getAbsoluteFile();
            Location parent = file2.getParentFile();
            if ((parent = parent.getParentFile()) != null && (parent = parent.getParentFile()) != null) {
                Location mvd2 = new Location(parent, parent.getName() + ".mvd2");
                return mvd2.exists() && super.isThisType(mvd2.getAbsolutePath());
            }
        }
        return false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 2;
        if (!FormatTools.validStream(stream, 2, false)) {
            return false;
        }
        String check = stream.readString(2);
        return check.equals("JL") || check.equals("LJ");
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        long offset;
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int[] zct = this.getZCTCoords(no);
        Stack stack = this.stacks.get(this.getSeries());
        if (!new Location(stack.pixelsFiles[zct[1]]).exists()) {
            Arrays.fill(buf, (byte)0);
            return buf;
        }
        RandomAccessInputStream pix = new RandomAccessInputStream(stack.pixelsFiles[zct[1]]);
        int padding = zct[2] * stack.planePadding;
        long planeSize = FormatTools.getPlaneSize(this);
        int planesInFile = (int)(pix.length() / planeSize);
        int planeIndex = no / this.getEffectiveSizeC();
        if (planesInFile == this.getSizeT()) {
            planeIndex = zct[2];
            int block = stack.blockSize;
            padding = block - (int)(planeSize % (long)block);
            if (padding == block) {
                padding = 0;
            }
            padding *= zct[2];
        }
        if ((offset = (long)stack.blockSize + (long)planeIndex * planeSize + (long)padding) >= pix.length()) {
            pix.close();
            return buf;
        }
        pix.seek(offset);
        if (stack.clippingData) {
            pix.seek(offset - 3L);
            ByteArrayHandle v = new ByteArrayHandle();
            while (v.length() < (long)FormatTools.getPlaneSize(this) && pix.getFilePointer() < pix.length()) {
                try {
                    byte[] b = new LZOCodec().decompress(pix, null);
                    pix.skipBytes(4);
                    v.write(b);
                }
                catch (IOException e) {}
            }
            RandomAccessInputStream s = new RandomAccessInputStream(v);
            s.seek(0L);
            this.readPlane(s, x, y, w, h, buf);
            s.close();
        } else {
            if (pix.getFilePointer() + planeSize > pix.length()) {
                return buf;
            }
            this.readPlane(pix, x, y, w, h, buf);
        }
        pix.close();
        if (this.getRGBChannelCount() == 4) {
            for (int i = 0; i < buf.length / 4; ++i) {
                byte a = buf[i * 4];
                buf[i * 4] = buf[i * 4 + 1];
                buf[i * 4 + 1] = buf[i * 4 + 2];
                buf[i * 4 + 2] = buf[i * 4 + 3];
                buf[i * 4 + 3] = a;
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.stacks = null;
            this.sampleTable = null;
            this.stringTable = null;
            this.dir = null;
            this.timestamps.clear();
            Location.mapFile(EMBEDDED_STREAM, null);
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        Stack stack;
        int i;
        int x;
        RandomAccessInputStream s;
        int channelIndex;
        int i2;
        String[] files;
        Location file2;
        if (!VolocityReader.checkSuffix(id, "mvd2")) {
            file2 = new Location(id).getAbsoluteFile();
            Location parent = file2.getParentFile().getParentFile();
            for (String f : files = parent.list(true)) {
                if (!VolocityReader.checkSuffix(f, "mvd2")) continue;
                id = new Location(parent, f).getAbsolutePath();
                break;
            }
        }
        super.initFile(id);
        this.stacks = new ArrayList();
        this.extraFiles = new ArrayList();
        file2 = new Location(id).getAbsoluteFile();
        this.extraFiles.add(file2.getAbsolutePath());
        Location parentDir = file2.getParentFile();
        this.dir = new Location(parentDir, DATA_DIR);
        if (this.dir.exists()) {
            for (String f : files = this.dir.list(true)) {
                if (VolocityReader.checkSuffix(f, "aisf") || VolocityReader.checkSuffix(f, "atsf")) continue;
                this.extraFiles.add(new Location(this.dir, f).getAbsolutePath());
            }
        }
        try {
            ServiceFactory factory = new ServiceFactory();
            MetakitService reader = factory.getInstance(MetakitService.class);
            reader.initialize(id);
            this.sampleTable = reader.getTableData(1);
            this.stringTable = reader.getTableData(2);
            reader.close();
        }
        catch (DependencyException e) {
            throw new MissingLibraryException("Could not find Metakit library", e);
        }
        ArrayList<String> stackNames = new ArrayList<String>();
        ArrayList<Integer> parentIDs = new ArrayList<Integer>();
        for (i2 = 0; i2 < this.sampleTable.length; ++i2) {
            Integer stringID = (Integer)this.sampleTable[i2][11];
            String name = this.getString(stringID);
            channelIndex = this.getChildIndex((Integer)this.sampleTable[i2][0], "Channels");
            if (i2 <= 0 || (Integer)this.sampleTable[i2][2] != 1 || channelIndex < 0 && (this.sampleTable[i2][14] == null || this.sampleTable[i2][14].equals(0)) && ((byte[])this.sampleTable[i2][13]).length <= 21) continue;
            if (channelIndex < 0) {
                s = this.getStream(i2);
                s.seek(0L);
                if (s.read() != 73) {
                    s.order(false);
                }
                s.seek(22L);
                x = s.readInt();
                int y = s.readInt();
                int z = s.readInt();
                if (x * y * z > 0 && (long)(x * y * z) < s.length() * 3L) {
                    stackNames.add(name);
                    parentIDs.add((Integer)this.sampleTable[i2][0]);
                }
                s.close();
                continue;
            }
            stackNames.add(name);
            parentIDs.add((Integer)this.sampleTable[i2][0]);
        }
        for (i2 = 0; i2 < parentIDs.size(); ++i2) {
            int zLocationIndex;
            int yLocationIndex;
            int xLocationIndex;
            int descriptionIndex;
            int detectorIndex;
            int objectiveIndex;
            int zIndex;
            int yIndex;
            int xIndex;
            Stack stack2 = new Stack();
            stack2.core = new CoreMetadata();
            Integer parent = (Integer)parentIDs.get(i2);
            channelIndex = this.getChildIndex(parent, "Channels");
            if (channelIndex >= 0) {
                Integer[] channels = this.getAllChildren((Integer)this.sampleTable[channelIndex][0]);
                stack2.core.sizeC = channels.length;
                stack2.pixelsFiles = new String[stack2.core.sizeC];
                stack2.channelNames = new String[channels.length];
                for (int c = 0; c < channels.length; ++c) {
                    stack2.channelNames[c] = this.getString((Integer)this.sampleTable[channels[c]][11]);
                    RandomAccessInputStream data = this.getStream(channels[c]);
                    if (data.length() > 22L) {
                        data.seek(22L);
                        int stackID = data.readInt();
                        Location f = new Location(this.dir, stackID + ".aisf");
                        if (!f.exists()) {
                            f = new Location(this.dir, DataTools.swap(stackID) + ".aisf");
                        }
                        stack2.pixelsFiles[c] = f.getAbsolutePath();
                    } else {
                        Integer child = this.getAllChildren((Integer)this.sampleTable[channels[c]][0])[0];
                        stack2.pixelsFiles[c] = this.getFile((Integer)this.sampleTable[child][0], this.dir);
                    }
                    data.close();
                }
            } else {
                stack2.pixelsFiles = new String[1];
                stack2.pixelsFiles[0] = this.getFile(parent, this.dir);
                if (stack2.pixelsFiles[0] == null || !new Location(stack2.pixelsFiles[0]).exists()) {
                    int row = -1;
                    for (int r = 0; r < this.sampleTable.length; ++r) {
                        if (!this.sampleTable[r][0].equals(parent)) continue;
                        row = r;
                        break;
                    }
                    stack2.pixelsFiles[0] = EMBEDDED_STREAM;
                    ByteArrayHandle data = new ByteArrayHandle((byte[])this.sampleTable[row][13]);
                    Location.mapFile(stack2.pixelsFiles[0], data);
                }
            }
            RandomAccessInputStream data = null;
            int timestampIndex = this.getChildIndex(parent, "Timepoint times stream");
            if (timestampIndex >= 0) {
                data = this.getStream(timestampIndex);
                data.seek(22L);
                int timestampID = data.readInt();
                Location f = new Location(this.dir, timestampID + ".atsf");
                if (!f.exists()) {
                    f = new Location(this.dir, DataTools.swap(timestampID) + ".atsf");
                }
                stack2.timestampFile = f.getAbsolutePath();
                data.close();
            }
            if ((xIndex = this.getChildIndex(parent, "um/pixel (X)")) >= 0) {
                data = this.getStream(xIndex);
                data.seek(13L);
                stack2.physicalX = data.readDouble();
                data.close();
            }
            if ((yIndex = this.getChildIndex(parent, "um/pixel (Y)")) >= 0) {
                data = this.getStream(yIndex);
                data.seek(13L);
                stack2.physicalY = data.readDouble();
                data.close();
            }
            if ((zIndex = this.getChildIndex(parent, "um/pixel (Z)")) >= 0) {
                data = this.getStream(zIndex);
                data.seek(13L);
                stack2.physicalZ = data.readDouble();
                data.close();
            }
            if ((timestampIndex = this.getChildIndex(parent, "TimepointTimes")) >= 0) {
                data = this.getStream(timestampIndex);
                data.seek(13L);
                data.close();
            }
            if ((objectiveIndex = this.getChildIndex(parent, "Microscope Objective")) >= 0) {
                data = this.getStream(objectiveIndex);
                data.seek(13L);
                stack2.magnification = data.readDouble();
                data.close();
            }
            if ((detectorIndex = this.getChildIndex(parent, "Camera/Detector")) >= 0) {
                data = this.getStream(detectorIndex);
                data.seek(13L);
                int len = data.readInt();
                stack2.detector = data.readString(len);
                data.close();
            }
            if ((descriptionIndex = this.getChildIndex(parent, "Experiment Description")) >= 0) {
                data = this.getStream(descriptionIndex);
                data.seek(13L);
                int len = data.readInt();
                stack2.description = data.readString(len);
                data.close();
            }
            if ((xLocationIndex = this.getChildIndex(parent, "X Location")) >= 0) {
                data = this.getStream(xLocationIndex);
                data.seek(13L);
                stack2.xLocation = data.readDouble();
                data.close();
            }
            if ((yLocationIndex = this.getChildIndex(parent, "Y Location")) >= 0) {
                data = this.getStream(yLocationIndex);
                data.seek(13L);
                stack2.yLocation = data.readDouble();
                data.close();
            }
            if ((zLocationIndex = this.getChildIndex(parent, "Z Location")) >= 0) {
                data = this.getStream(zLocationIndex);
                data.seek(13L);
                stack2.zLocation = data.readDouble();
                data.close();
            }
            this.stacks.add(stack2);
        }
        for (i2 = 0; i2 < this.stacks.size(); ++i2) {
            Stack stack3 = this.stacks.get(i2);
            if (!new Location(stack3.pixelsFiles[0]).exists()) {
                this.stacks.remove(i2);
                --i2;
                continue;
            }
            RandomAccessInputStream base = new RandomAccessInputStream(stack3.pixelsFiles[0]);
            long baseLength = base.length();
            base.close();
            for (int q = 1; q < stack3.pixelsFiles.length; ++q) {
                if (!new Location(stack3.pixelsFiles[q]).exists()) continue;
                base = new RandomAccessInputStream(stack3.pixelsFiles[q]);
                long length = base.length();
                base.close();
                if (length <= baseLength) continue;
                Stack newStack = new Stack();
                newStack.timestampFile = stack3.timestampFile;
                newStack.core = new CoreMetadata();
                newStack.physicalX = stack3.physicalX;
                newStack.physicalY = stack3.physicalY;
                newStack.physicalZ = stack3.physicalZ;
                newStack.magnification = stack3.magnification;
                newStack.detector = stack3.detector;
                newStack.description = stack3.description;
                newStack.xLocation = stack3.xLocation;
                newStack.yLocation = stack3.yLocation;
                newStack.zLocation = stack3.zLocation;
                String[] pixels = stack3.pixelsFiles;
                newStack.pixelsFiles = new String[pixels.length - q];
                System.arraycopy(pixels, q, newStack.pixelsFiles, 0, newStack.pixelsFiles.length);
                stack3.pixelsFiles = new String[q];
                System.arraycopy(pixels, 0, stack3.pixelsFiles, 0, q);
                String[] channels = stack3.channelNames;
                newStack.channelNames = new String[channels.length - q];
                System.arraycopy(channels, q, newStack.channelNames, 0, newStack.channelNames.length);
                stack3.channelNames = new String[q];
                System.arraycopy(channels, 0, stack3.channelNames, 0, q);
                newStack.core.sizeC = newStack.channelNames.length;
                stack3.core.sizeC = stack3.channelNames.length;
                this.stacks.add(i2 + 1, newStack);
                stackNames.add(i2 + 1, (String)stackNames.get(i2));
            }
        }
        int seriesCount = this.stacks.size();
        this.core.clear();
        for (i = 0; i < seriesCount; ++i) {
            stack = this.stacks.get(i);
            CoreMetadata ms = stack.core;
            this.core.add(ms);
            this.setSeries(i);
            ms.littleEndian = true;
            if (stack.timestampFile != null) {
                s = new RandomAccessInputStream(stack.timestampFile);
                s.seek(0L);
                if (s.read() != 73) {
                    ms.littleEndian = false;
                }
                s.seek(17L);
                s.order(this.isLittleEndian());
                ms.sizeT = s.readInt();
                Double firstStamp = null;
                Double[] stamps = new Double[ms.sizeT];
                for (int t = 0; t < ms.sizeT; ++t) {
                    double timestamp = (double)s.readLong() / 1000000.0;
                    if (firstStamp == null) {
                        firstStamp = timestamp;
                    }
                    stamps[t] = timestamp - firstStamp;
                }
                this.timestamps.add(stamps);
                s.close();
            } else {
                ms.sizeT = 1;
            }
            ms.rgb = false;
            ms.interleaved = true;
            ms.dimensionOrder = "XYCZT";
            s = new RandomAccessInputStream(stack.pixelsFiles[0]);
            s.order(this.isLittleEndian());
            if (VolocityReader.checkSuffix(stack.pixelsFiles[0], "aisf")) {
                s.seek(18L);
                stack.blockSize = s.readShort() * 256;
                s.skipBytes(5);
                x = s.readInt();
                int y = s.readInt();
                int zStart = s.readInt();
                int w = s.readInt();
                int h = s.readInt();
                if (w - x < 0 || h - y < 0 || (w - x) * (h - y) < 0) {
                    ms.littleEndian = !this.isLittleEndian();
                    s.order(this.isLittleEndian());
                    s.seek(s.getFilePointer() - 20L);
                    x = s.readInt();
                    y = s.readInt();
                    zStart = s.readInt();
                    w = s.readInt();
                    h = s.readInt();
                }
                ms.sizeX = w - x;
                ms.sizeY = h - y;
                ms.sizeZ = s.readInt() - zStart;
                ms.imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
                ms.pixelType = 0;
                int planesPerFile = this.getSizeZ() * this.getSizeT();
                int planeSize = FormatTools.getPlaneSize(this);
                int bytesPerPixel = 0;
                for (int bytesPerPlane = (int)((s.length() - (long)stack.blockSize) / (long)planesPerFile); bytesPerPlane >= planeSize; bytesPerPlane -= planeSize) {
                    ++bytesPerPixel;
                }
                if (bytesPerPixel % 3 == 0) {
                    ms.sizeC *= 3;
                    ms.rgb = true;
                    bytesPerPixel /= 3;
                }
                ms.pixelType = FormatTools.pixelTypeFromBytes(bytesPerPixel, false, bytesPerPixel > 2);
                int timepoint = FormatTools.getPlaneSize(this) * this.getSizeZ();
                stack.planePadding = stack.blockSize - timepoint % stack.blockSize;
                if (stack.planePadding == stack.blockSize) {
                    stack.planePadding = 0;
                }
            } else {
                boolean embedded = Location.getMappedFile(EMBEDDED_STREAM) != null;
                s.seek(0L);
                if (s.read() != 73) {
                    ms.littleEndian = false;
                    s.order(false);
                }
                s.seek(22L);
                ms.sizeX = s.readInt();
                ms.sizeY = s.readInt();
                ms.sizeZ = s.readInt();
                ms.sizeC = embedded ? 1 : 4;
                ms.imageCount = this.getSizeZ() * this.getSizeT();
                ms.rgb = ms.sizeC > 1;
                ms.pixelType = 1;
                stack.blockSize = embedded ? (int)s.getFilePointer() : 99;
                stack.planePadding = 0;
                if (s.length() > (long)(ms.sizeX * ms.sizeY * ms.sizeZ * 6)) {
                    ms.pixelType = 3;
                    ms.sizeC = 3;
                    ms.rgb = true;
                }
                if (s.length() < (long)(ms.sizeX * ms.sizeY * ms.sizeZ * ms.sizeC)) {
                    ms.rgb = false;
                    ms.sizeC = 1;
                    long pixels = ms.sizeX * ms.sizeY * ms.sizeZ;
                    double approximateBytes = (double)s.length() / (double)pixels;
                    int bytes = (int)Math.ceil(approximateBytes);
                    if (bytes == 0) {
                        bytes = 1;
                    } else if (bytes == 3) {
                        bytes = 2;
                    }
                    ms.pixelType = FormatTools.pixelTypeFromBytes(bytes, false, false);
                    s.seek(70L);
                    stack.blockSize = s.readInt();
                    stack.clippingData = true;
                }
            }
            s.close();
        }
        this.setSeries(0);
        for (i = 0; i < this.getSeriesCount(); ++i) {
            this.setSeries(i);
            stack = this.stacks.get(i);
            this.addSeriesMeta("Name", stackNames.get(i));
            this.addSeriesMeta("Pixel width (in microns)", stack.physicalX);
            this.addSeriesMeta("Pixel height (in microns)", stack.physicalY);
            this.addSeriesMeta("Z step (in microns)", stack.physicalZ);
            this.addSeriesMeta("Objective magnification", stack.magnification);
            this.addSeriesMeta("Camera/Detector", stack.detector);
            this.addSeriesMeta("Description", stack.description);
            this.addSeriesMeta("X Location", stack.xLocation);
            this.addSeriesMeta("Y Location", stack.yLocation);
            this.addSeriesMeta("Z Location", stack.zLocation);
            if (stack.channelNames == null) continue;
            for (int c = 0; c < stack.channelNames.length; ++c) {
                this.addSeriesMetaList("Channel", stack.channelNames[c]);
            }
        }
        this.setSeries(0);
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        String instrument = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrument, 0);
        for (int i3 = 0; i3 < this.getSeriesCount(); ++i3) {
            store.setImageInstrumentRef(instrument, i3);
            this.setSeries(i3);
            Stack stack4 = this.stacks.get(i3);
            store.setImageName((String)stackNames.get(i3), i3);
            store.setImageDescription(stack4.description, i3);
            if (stack4.channelNames != null) {
                for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                    store.setChannelName(stack4.channelNames[c], i3, c);
                }
            }
            PositiveFloat sizeX = FormatTools.getPhysicalSizeX(stack4.physicalX);
            PositiveFloat sizeY = FormatTools.getPhysicalSizeY(stack4.physicalY);
            PositiveFloat sizeZ = FormatTools.getPhysicalSizeZ(stack4.physicalZ);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, i3);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, i3);
            }
            if (sizeZ != null) {
                store.setPixelsPhysicalSizeZ(sizeZ, i3);
            }
            String objective = MetadataTools.createLSID("Objective", 0, i3);
            store.setObjectiveID(objective, 0, i3);
            store.setObjectiveNominalMagnification(stack4.magnification, 0, i3);
            store.setObjectiveCorrection(this.getCorrection("Other"), 0, i3);
            store.setObjectiveImmersion(this.getImmersion("Other"), 0, i3);
            store.setObjectiveSettingsID(objective, i3);
            String detectorID = MetadataTools.createLSID("Detector", 0, i3);
            store.setDetectorID(detectorID, 0, i3);
            store.setDetectorModel(stack4.detector, 0, i3);
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                store.setDetectorSettingsID(detectorID, i3, c);
            }
            for (int img = 0; img < this.getImageCount(); ++img) {
                int[] coords = this.getZCTCoords(img);
                int z = coords[0];
                store.setPlanePositionX(stack4.xLocation, i3, img);
                store.setPlanePositionY(stack4.yLocation, i3, img);
                if (stack4.physicalZ != null) {
                    store.setPlanePositionZ(stack4.zLocation + (double)z * stack4.physicalZ, i3, img);
                }
                if (i3 >= this.timestamps.size() || coords[2] >= this.timestamps.get(i3).length) continue;
                store.setPlaneDeltaT(this.timestamps.get(i3)[coords[2]], i3, img);
            }
        }
        this.setSeries(0);
    }

    private String getString(Integer stringID) {
        for (int row = 0; row < this.stringTable.length; ++row) {
            if (!stringID.equals(this.stringTable[row][0])) continue;
            String s = (String)this.stringTable[row][1];
            if (s != null) {
                s = s.trim();
            }
            return s;
        }
        return null;
    }

    private int getChildIndex(Integer parentID, String childName) {
        for (int row = 0; row < this.sampleTable.length; ++row) {
            String name;
            if (!parentID.equals(this.sampleTable[row][1]) || !childName.equals(name = this.getString((Integer)this.sampleTable[row][11]))) continue;
            return row;
        }
        return -1;
    }

    private Integer[] getAllChildren(Integer parentID) {
        ArrayList<Integer> children = new ArrayList<Integer>();
        for (int row = 0; row < this.sampleTable.length; ++row) {
            if (!parentID.equals(this.sampleTable[row][1])) continue;
            children.add(row);
        }
        return children.toArray(new Integer[children.size()]);
    }

    private RandomAccessInputStream getStream(int row) throws IOException {
        Object o = this.sampleTable[row][14];
        String fileLink = o == null ? "0" : o.toString().trim();
        RandomAccessInputStream data = null;
        if (fileLink.equals("0")) {
            data = new RandomAccessInputStream((byte[])this.sampleTable[row][13]);
        } else {
            fileLink = new Location(this.dir, fileLink + ".dat").getAbsolutePath();
            data = new RandomAccessInputStream(fileLink);
        }
        data.order(true);
        return data;
    }

    private String getFile(Integer parent, Location dir) {
        for (int row = 0; row < this.sampleTable.length; ++row) {
            Object o;
            if (!parent.equals(this.sampleTable[row][0]) || (o = this.sampleTable[row][14]) == null) continue;
            String fileLink = o.toString().trim() + ".dat";
            return new Location(dir, fileLink).getAbsolutePath();
        }
        return null;
    }

    class Stack {
        public String[] pixelsFiles;
        public String timestampFile;
        public int planePadding;
        public int blockSize;
        public boolean clippingData;
        public CoreMetadata core;
        public String[] channelNames;
        public Double physicalX;
        public Double physicalY;
        public Double physicalZ;
        public Double magnification;
        public String detector;
        public String description;
        public double xLocation;
        public double yLocation;
        public double zLocation;

        Stack() {
        }
    }
}

