/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import loci.common.IRandomAccess;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.ZipHandle;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.ImageReader;

public class ZipReader
extends FormatReader {
    private ImageReader reader;
    private ArrayList<String> mappedFiles = new ArrayList();

    public ZipReader() {
        super("Zip", "zip");
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        return this.reader.get8BitLookupTable();
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        return this.reader.get16BitLookupTable();
    }

    @Override
    public void setGroupFiles(boolean groupFiles) {
        super.setGroupFiles(groupFiles);
        if (this.reader != null) {
            this.reader.setGroupFiles(groupFiles);
        }
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        return this.reader.openBytes(no, buf, x, y, w, h);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.reader != null) {
            this.reader.close(fileOnly);
        }
        if (!fileOnly) {
            this.reader = null;
        }
        for (String name : this.mappedFiles) {
            IRandomAccess handle = Location.getMappedFile(name);
            Location.mapFile(name, null);
            if (handle == null) continue;
            handle.close();
        }
        this.mappedFiles.clear();
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        int sep;
        super.initFile(id);
        this.reader = new ImageReader();
        this.reader.setMetadataOptions(this.getMetadataOptions());
        this.reader.setMetadataFiltered(this.isMetadataFiltered());
        this.reader.setOriginalMetadataPopulated(this.isOriginalMetadataPopulated());
        this.reader.setNormalized(this.isNormalized());
        this.reader.setMetadataStore(this.getMetadataStore());
        String innerFile = id;
        if (ZipReader.checkSuffix(id, "zip")) {
            innerFile = id.substring(0, id.length() - 4);
        }
        if ((sep = innerFile.lastIndexOf(File.separator)) < 0) {
            sep = innerFile.lastIndexOf("/");
        }
        if (sep >= 0) {
            innerFile = innerFile.substring(sep + 1);
        }
        IRandomAccess rawHandle = Location.getHandle(id, false, false);
        this.in = new RandomAccessInputStream(rawHandle, id);
        ZipInputStream zip = new ZipInputStream(this.in);
        ZipEntry ze = null;
        String entryName = null;
        boolean matchFound = false;
        while ((ze = zip.getNextEntry()) != null) {
            if (entryName == null) {
                entryName = ze.getName();
            }
            if (!matchFound && ze.getName().startsWith(innerFile)) {
                entryName = ze.getName();
                matchFound = true;
            }
            ZipHandle handle = new ZipHandle(id, ze);
            Location.mapFile(ze.getName(), handle);
            this.mappedFiles.add(ze.getName());
        }
        if (entryName == null) {
            throw new FormatException("Zip file does not contain any valid files");
        }
        this.reader.setId(entryName);
        this.metadataStore = this.reader.getMetadataStore();
        this.core = new ArrayList<CoreMetadata>(this.reader.getCoreMetadataList());
        this.metadata = this.reader.getGlobalMetadata();
    }
}

