/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.RandomAccessOutputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.out.TiffWriter;
import loci.formats.services.OMEXMLService;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffSaver;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveInteger;

public class OMETiffWriter
extends TiffWriter {
    private static final String WARNING_COMMENT = "<!-- Warning: this comment is an OME-XML metadata block, which contains crucial dimensional parameters and other important metadata. Please edit cautiously (if at all), and back up the original data before doing so. For more information, see the OME-TIFF web site: http://ome-xml.org/wiki/OmeTiff. -->";
    private List<Integer> seriesMap;
    private String[][] imageLocations;
    private OMEXMLMetadata omeMeta;
    private OMEXMLService service;
    private Map<String, Integer> ifdCounts = new HashMap<String, Integer>();
    private Map<String, String> uuids = new HashMap<String, String>();

    public OMETiffWriter() {
        super("OME-TIFF", new String[]{"ome.tif", "ome.tiff"});
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws IOException {
        boolean canReallyClose;
        try {
            if (this.currentId != null) {
                this.setupServiceAndMetadata();
                this.service.removeBinData(this.omeMeta);
                for (int series = 0; series < this.omeMeta.getImageCount(); ++series) {
                    this.setSeries(series);
                    this.populateImage(this.omeMeta, series);
                }
                ArrayList<String> files = new ArrayList<String>();
                String[][] arr$ = this.imageLocations;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String[] s;
                    for (String f : s = arr$[i$]) {
                        if (files.contains(f) || f == null) continue;
                        files.add(f);
                        String xml = this.getOMEXML(f);
                        this.saveComment(f, xml);
                    }
                }
            }
        }
        catch (DependencyException de) {
            try {
                throw new RuntimeException(de);
                catch (ServiceException se) {
                    throw new RuntimeException(se);
                }
                catch (FormatException fe) {
                    throw new RuntimeException(fe);
                }
                catch (IllegalArgumentException iae) {
                    throw new RuntimeException(iae);
                }
            }
            catch (Throwable throwable) {
                boolean canReallyClose2;
                super.close();
                boolean bl = canReallyClose2 = this.omeMeta == null || this.ifdCounts.size() == this.omeMeta.getImageCount();
                if (this.omeMeta != null && canReallyClose2) {
                    int sizeT;
                    int sizeC;
                    int sizeZ;
                    int omePlaneCount = 0;
                    for (int i = 0; i < this.omeMeta.getImageCount(); omePlaneCount += sizeZ * sizeC * sizeT, ++i) {
                        sizeZ = (Integer)this.omeMeta.getPixelsSizeZ(i).getValue();
                        sizeC = (Integer)this.omeMeta.getPixelsSizeC(i).getValue();
                        sizeT = (Integer)this.omeMeta.getPixelsSizeT(i).getValue();
                    }
                    int ifdCount = 0;
                    for (String key : this.ifdCounts.keySet()) {
                        ifdCount += this.ifdCounts.get(key).intValue();
                    }
                    boolean bl2 = canReallyClose2 = omePlaneCount == ifdCount;
                }
                if (canReallyClose2) {
                    this.seriesMap = null;
                    this.imageLocations = null;
                    this.omeMeta = null;
                    this.service = null;
                    this.ifdCounts.clear();
                    throw throwable;
                }
                Iterator<String> i$ = this.ifdCounts.keySet().iterator();
                while (i$.hasNext()) {
                    String k = i$.next();
                    this.ifdCounts.put(k, 0);
                }
                throw throwable;
            }
        }
        super.close();
        boolean bl = canReallyClose = this.omeMeta == null || this.ifdCounts.size() == this.omeMeta.getImageCount();
        if (this.omeMeta != null && canReallyClose) {
            int sizeT;
            int sizeC;
            int sizeZ;
            int omePlaneCount = 0;
            for (int i = 0; i < this.omeMeta.getImageCount(); omePlaneCount += sizeZ * sizeC * sizeT, ++i) {
                sizeZ = (Integer)this.omeMeta.getPixelsSizeZ(i).getValue();
                sizeC = (Integer)this.omeMeta.getPixelsSizeC(i).getValue();
                sizeT = (Integer)this.omeMeta.getPixelsSizeT(i).getValue();
            }
            int ifdCount = 0;
            for (String key : this.ifdCounts.keySet()) {
                ifdCount += this.ifdCounts.get(key).intValue();
            }
            boolean bl3 = canReallyClose = omePlaneCount == ifdCount;
        }
        if (canReallyClose) {
            this.seriesMap = null;
            this.imageLocations = null;
            this.omeMeta = null;
            this.service = null;
            this.ifdCounts.clear();
            return;
        }
        Iterator<String> i$ = this.ifdCounts.keySet().iterator();
        while (i$.hasNext()) {
            String k = i$.next();
            this.ifdCounts.put(k, 0);
        }
    }

    @Override
    public void saveBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        this.saveBytes(no, buf, null, x, y, w, h);
    }

    @Override
    public void saveBytes(int no, byte[] buf, IFD ifd, int x, int y, int w, int h) throws FormatException, IOException {
        if (this.seriesMap == null) {
            this.seriesMap = new ArrayList<Integer>();
        }
        if (!this.seriesMap.contains(this.series)) {
            this.seriesMap.add(new Integer(this.series));
        }
        super.saveBytes(no, buf, ifd, x, y, w, h);
        for (int index = no; this.imageLocations[this.series][index] != null && index < this.imageLocations[this.series].length - 1; ++index) {
        }
        this.imageLocations[this.series][index] = this.currentId;
    }

    @Override
    public void setId(String id) throws FormatException, IOException {
        if (id.equals(this.currentId)) {
            return;
        }
        super.setId(id);
        if (this.imageLocations == null) {
            MetadataRetrieve r = this.getMetadataRetrieve();
            this.imageLocations = new String[r.getImageCount()][];
            for (int i = 0; i < this.imageLocations.length; ++i) {
                this.setSeries(i);
                this.imageLocations[i] = new String[this.planeCount()];
            }
            this.setSeries(0);
        }
    }

    private String getUUID(String filename) {
        String uuid = this.uuids.get(filename);
        if (uuid == null) {
            uuid = UUID.randomUUID().toString();
            this.uuids.put(filename, uuid);
        }
        return uuid;
    }

    private void setupServiceAndMetadata() throws DependencyException, ServiceException {
        MetadataRetrieve retrieve = this.getMetadataRetrieve();
        ServiceFactory factory = new ServiceFactory();
        this.service = factory.getInstance(OMEXMLService.class);
        OMEXMLMetadata originalOMEMeta = this.service.getOMEMetadata(retrieve);
        originalOMEMeta.resolveReferences();
        String omexml = this.service.getOMEXML(originalOMEMeta);
        this.omeMeta = this.service.createOMEXMLMetadata(omexml);
    }

    private String getOMEXML(String file2) throws FormatException, IOException {
        String xml;
        String uuid = "urn:uuid:" + this.getUUID(new Location(file2).getName());
        this.omeMeta.setUUID(uuid);
        try {
            xml = this.service.getOMEXML(this.omeMeta);
        }
        catch (ServiceException se) {
            throw new FormatException(se);
        }
        String prefix = xml.substring(0, xml.indexOf(">") + 1);
        String suffix = xml.substring(xml.indexOf(">") + 1);
        return prefix + WARNING_COMMENT + suffix;
    }

    private void saveComment(String file2, String xml) throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = new RandomAccessOutputStream(file2);
        RandomAccessInputStream in = null;
        try {
            TiffSaver saver = new TiffSaver(this.out, file2);
            saver.setBigTiff(this.isBigTiff);
            in = new RandomAccessInputStream(file2);
            saver.overwriteLastIFDOffset(in);
            saver.overwriteComment(in, xml);
            in.close();
        }
        catch (FormatException exc) {
            IOException io = new IOException("Unable to append OME-XML comment");
            io.initCause(exc);
            throw io;
        }
        finally {
            if (this.out != null) {
                this.out.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    private void populateTiffData(OMEXMLMetadata omeMeta, int[] zct, int ifd, int series, int plane) {
        omeMeta.setTiffDataFirstZ(new NonNegativeInteger(zct[0]), series, plane);
        omeMeta.setTiffDataFirstC(new NonNegativeInteger(zct[1]), series, plane);
        omeMeta.setTiffDataFirstT(new NonNegativeInteger(zct[2]), series, plane);
        omeMeta.setTiffDataIFD(new NonNegativeInteger(ifd), series, plane);
        omeMeta.setTiffDataPlaneCount(new NonNegativeInteger(1), series, plane);
    }

    private void populateImage(OMEXMLMetadata omeMeta, int series) {
        String dimensionOrder = omeMeta.getPixelsDimensionOrder(series).toString();
        int sizeZ = (Integer)omeMeta.getPixelsSizeZ(series).getValue();
        int sizeC = (Integer)omeMeta.getPixelsSizeC(series).getValue();
        int sizeT = (Integer)omeMeta.getPixelsSizeT(series).getValue();
        int imageCount = this.getPlaneCount();
        int ifdCount = this.seriesMap.size();
        if (imageCount == 0) {
            omeMeta.setTiffDataPlaneCount(new NonNegativeInteger(0), series, 0);
            return;
        }
        PositiveInteger samplesPerPixel = new PositiveInteger(sizeZ * sizeC * sizeT / imageCount);
        for (int c = 0; c < omeMeta.getChannelCount(series); ++c) {
            omeMeta.setChannelSamplesPerPixel(samplesPerPixel, series, c);
        }
        sizeC /= ((Integer)samplesPerPixel.getValue()).intValue();
        int nextPlane = 0;
        for (int plane = 0; plane < imageCount; ++plane) {
            String filename;
            int[] zct = FormatTools.getZCTCoords(dimensionOrder, sizeZ, sizeC, sizeT, imageCount, plane);
            int planeIndex = plane;
            if (this.imageLocations[series].length < imageCount) {
                planeIndex /= imageCount / this.imageLocations[series].length;
            }
            if ((filename = this.imageLocations[series][planeIndex]) == null) continue;
            Integer ifdIndex = this.ifdCounts.get(filename = new Location(filename).getName());
            int ifd = ifdIndex == null ? 0 : ifdIndex;
            omeMeta.setUUIDFileName(filename, series, nextPlane);
            String uuid = "urn:uuid:" + this.getUUID(filename);
            omeMeta.setUUIDValue(uuid, series, nextPlane);
            this.populateTiffData(omeMeta, zct, ifd, series, nextPlane);
            this.ifdCounts.put(filename, ifd + 1);
            ++nextPlane;
        }
    }

    private int planeCount() {
        MetadataRetrieve r = this.getMetadataRetrieve();
        int z = (Integer)r.getPixelsSizeZ(this.series).getValue();
        int t = (Integer)r.getPixelsSizeT(this.series).getValue();
        int c = r.getChannelCount(this.series);
        String pixelType = r.getPixelsType(this.series).getValue();
        int bytes = FormatTools.getBytesPerPixel(pixelType);
        if (bytes > 1 && c == 1) {
            c = (Integer)r.getChannelSamplesPerPixel(this.series, 0).getValue();
        }
        return z * c * t;
    }
}

