/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.io.IOException;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.FormatWriter;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.services.WlzService;

public class WlzWriter
extends FormatWriter {
    private WlzService wlz = null;
    public static final String NO_WLZ_MSG = "\nWoolz is required to read and write Woolz objects.\nPlease obtain the necessary JAR and native library files from:\nhttp://www.emouseatlas.org/emap/analysis_tools_resources/software/woolz.html.\nThe source code for these is also available from:\nhttps://github.com/ma-tech/Woolz.";
    private String outputOrder = "XYZCT";

    public WlzWriter() {
        super("Woolz", new String[]{"wlz"});
    }

    public void setOutputOrder(String outputOrder) {
        this.outputOrder = outputOrder;
    }

    @Override
    public void saveBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        if (this.wlz != null) {
            this.checkParams(no, buf, x, y, w, h);
            this.wlz.saveBytes(no, buf, x, y, w, h);
        }
    }

    @Override
    public boolean canDoStacks() {
        return true;
    }

    @Override
    public int[] getPixelTypes(String codec) {
        int[] spt = this.wlz != null ? this.wlz.getSupPixelTypes() : new int[]{};
        return spt;
    }

    @Override
    public void setId(String id) throws FormatException, IOException {
        super.setId(id);
        try {
            ServiceFactory factory = new ServiceFactory();
            this.wlz = factory.getInstance(WlzService.class);
        }
        catch (DependencyException e) {
            throw new FormatException(NO_WLZ_MSG, e);
        }
        if (this.wlz != null) {
            MetadataRetrieve meta = this.getMetadataRetrieve();
            MetadataTools.verifyMinimumPopulated(meta, this.series);
            this.wlz.open(id, "w");
            String stageLabelName = null;
            try {
                stageLabelName = meta.getStageLabelName(0);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            int oX = 0;
            int oY = 0;
            int oZ = 0;
            if (stageLabelName != null && stageLabelName.equals(this.wlz.getWlzOrgLabelName())) {
                oX = (int)Math.rint(meta.getStageLabelX(0));
                oY = (int)Math.rint(meta.getStageLabelY(0));
                oZ = (int)Math.rint(meta.getStageLabelZ(0));
            }
            int nX = (Integer)meta.getPixelsSizeX(this.series).getValue();
            int nY = (Integer)meta.getPixelsSizeY(this.series).getValue();
            int nZ = (Integer)meta.getPixelsSizeZ(this.series).getValue();
            int nC = (Integer)meta.getPixelsSizeC(this.series).getValue();
            int nT = (Integer)meta.getPixelsSizeT(this.series).getValue();
            double vX = 1.0;
            double vY = 1.0;
            double vZ = 1.0;
            if (meta.getPixelsPhysicalSizeX(0) != null) {
                vX = (Double)meta.getPixelsPhysicalSizeX(0).getValue();
            }
            if (meta.getPixelsPhysicalSizeY(0) != null) {
                vY = (Double)meta.getPixelsPhysicalSizeY(0).getValue();
            }
            if (meta.getPixelsPhysicalSizeZ(0) != null) {
                vZ = (Double)meta.getPixelsPhysicalSizeZ(0).getValue();
            }
            int gType = FormatTools.pixelTypeFromString(meta.getPixelsType(this.series).toString());
            this.wlz.setupWrite(oX, oY, oZ, nX, nY, nZ, nC, nT, vX, vY, vZ, gType);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.wlz != null) {
            this.wlz.close();
        }
    }
}

